/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import com.sun.mail.smtp.SMTPTransport;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterInstance;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.BlobsProcedureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.FormsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.ProcedureRemoveInstanceModule;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.ProcedureSendMailModule;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.StartProcedureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.TransformationFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.UpdateProcedureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetTasksCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalApplicationException;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portlet.model.UploadedFile;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.portal.api.transaction.IPostcommitResource;
import org.osivia.portal.api.transaction.ITransactionService;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormsServiceImpl
implements IFormsService {
    private static final Log procLogger = LogFactory.getLog((String)"procedures");
    private static ThreadLocal<ThreadLocalContainer> threadLocal = new ThreadLocal();
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private final DefaultCMSCustomizer cmsCustomizer;
    private final Log log;
    private final ObjectMapper mapper;
    private final ICMSServiceLocator cmsServiceLocator;
    private final ITasksService tasksService;
    private final IBundleFactory bundleFactory;
    private final PersonService personService;
    private final GroupService groupService;
    private final ITransactionService transactionService;

    public FormsServiceImpl(DefaultCMSCustomizer cmsCustomizer) {
        this.cmsCustomizer = cmsCustomizer;
        this.log = LogFactory.getLog(this.getClass());
        this.mapper = new ObjectMapper();
        this.mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        this.tasksService = (ITasksService)Locator.findMBean(ITasksService.class, (String)"osivia:service=TasksService");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        this.transactionService = (ITransactionService)Locator.findMBean(ITransactionService.class, (String)"osivia:service=TransactionService");
    }

    public Map<String, String> start(PortalControllerContext portalControllerContext, String modelWebId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.start(portalControllerContext, modelWebId, null, variables);
    }

    public Map<String, String> start(PortalControllerContext portalControllerContext, String modelWebId, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.start(portalControllerContext, modelWebId, actionId, variables, null);
    }

    public Map<String, String> start(PortalControllerContext portalControllerContext, String modelWebId, String actionId, Map<String, String> variables, Map<String, UploadedFile> uploadedFiles) throws PortalException, FormFilterException {
        List actors;
        String title;
        PropertyMap actionStepProperties;
        PropertyMap formStepProperties;
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        Locale locale = null;
        if (portalControllerContext.getHttpServletRequest() != null && portalControllerContext.getHttpServletRequest().getLocale() != null) {
            locale = portalControllerContext.getHttpServletRequest().getLocale();
        }
        Bundle bundle = this.bundleFactory.getBundle(locale);
        if (variables == null) {
            variables = new HashMap<String, String>();
        }
        Document model = this.getModel(portalControllerContext, modelWebId);
        String startingStep = StringUtils.defaultIfBlank((String)variables.get("pcd:startingStep"), (String)model.getString("pcd:startingStep"));
        if (StringUtils.isBlank((String)startingStep)) {
            String errorMessage = bundle.getString("FORMS_NO_STARTING_STEP");
            throw new PortalException(errorMessage);
        }
        if (StringUtils.equals((String)model.getType(), (String)"RecordFolder")) {
            formStepProperties = this.getStepProperties(model, "formulaire");
            String parentModelWebId = model.getString("pcd:webIdParent");
            model = this.getModel(portalControllerContext, parentModelWebId);
            actionStepProperties = this.getStepProperties(model, startingStep);
        } else {
            actionStepProperties = formStepProperties = this.getStepProperties(model, startingStep);
        }
        if (actionStepProperties == null) {
            String errorMessage = bundle.getString("FORMS_BAD_STARTING_STEP", new Object[]{startingStep});
            throw new PortalException(errorMessage);
        }
        PropertyMap actionProperties = this.getActionProperties(actionStepProperties, actionId, startingStep, bundle);
        if (uploadedFiles == null) {
            uploadedFiles = new HashMap<String, UploadedFile>(0);
        }
        variables.putAll(this.getUploadedFilesVariables(portalControllerContext, uploadedFiles));
        String procedureInitiator = "";
        HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
        if (httpServletRequest != null) {
            procedureInitiator = httpServletRequest.getRemoteUser();
            this.requiredFieldsValidation(portalControllerContext, formStepProperties, variables, uploadedFiles);
        } else {
            procedureInitiator = "admin";
            cmsContext.setScope("superuser_no_cache");
        }
        String nextStep = actionProperties.getString("stepReference");
        if (StringUtils.isBlank((String)nextStep)) {
            String errorMessage = bundle.getString("FORMS_NO_NEXT_STEP", new Object[]{actionId, nextStep});
            throw new PortalException(errorMessage);
        }
        if (StringUtils.equals((String)"endStep", (String)nextStep)) {
            title = "";
            actors = new ArrayList(0);
        } else {
            PropertyMap nextStepProperties = this.getStepProperties(model, nextStep);
            if (nextStepProperties == null) {
                String errorMessage = bundle.getString("FORMS_BAD_NEXT_STEP", new Object[]{nextStep, actionId, startingStep});
                throw new PortalException(errorMessage);
            }
            title = nextStepProperties.getString("name");
            actors = this.getActors(model, nextStep, title, nextStepProperties);
        }
        String uuid = UUID.randomUUID().toString();
        variables.put("uuid", uuid);
        String startDate = DATE_FORMAT.format(new Date());
        procLogger.info((Object)("Start procedure " + uuid + " (" + modelWebId + ") by " + procedureInitiator));
        procLogger.info((Object)("  variables " + Collections.singletonList(variables)));
        FormFilterContext filterContext = this.callFilters(modelWebId, uuid, actionId, variables, actionProperties, actors, null, uploadedFiles, portalControllerContext, procedureInitiator, startDate, startDate, procedureInitiator, nextStep, startingStep, bundle);
        boolean endStep = "endStep".equals(filterContext.getNextStep());
        if (!endStep) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("pi:currentStep", actionProperties.getString("stepReference"));
            properties.put("pi:procedureModelWebId", modelWebId);
            properties.put("pi:globalVariablesValues", this.convertVariablesToJson(portalControllerContext, variables));
            StartProcedureCommand command = new StartProcedureCommand(title, filterContext.getActors(), filterContext.getAdditionalAuthorizations(), properties);
            String savedScope = cmsContext.getScope();
            try {
                DocRef docRef = (DocRef)this.cmsCustomizer.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                cmsContext.setScope("superuser_no_cache");
                BlobsProcedureCommand blobCmd = new BlobsProcedureCommand(uploadedFiles, docRef);
                this.cmsCustomizer.executeNuxeoCommand(cmsContext, (INuxeoCommand)blobCmd);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
            finally {
                cmsContext.setScope(savedScope);
            }
            ProcedureSendMailModule sendModule = new ProcedureSendMailModule(portalControllerContext, this.cmsCustomizer.getPortletContext(), this, uuid, procedureInitiator);
            this.transactionService.registerPostcommit((IPostcommitResource)sendModule);
        }
        procLogger.info((Object)(" Procedure started " + uuid));
        return filterContext.getVariables();
    }

    private List<String> getActors(Document model, String nextStep, String title, PropertyMap nextStepProperties) {
        PropertyList groupsObjectsList;
        ArrayList<String> actors = new ArrayList<String>();
        if (!StringUtils.equals((String)"endStep", (String)nextStep) && (groupsObjectsList = nextStepProperties.getList("actors")) != null) {
            for (Object groupsObject : groupsObjectsList.list()) {
                actors.add((String)groupsObject);
            }
        }
        return actors;
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, Document task, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, task, null, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, Document task, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, task.getProperties(), actionId, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, PropertyMap taskProperties, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, taskProperties, null, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, PropertyMap taskProperties, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, taskProperties, actionId, variables, null);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, PropertyMap taskProperties, String actionId, Map<String, String> variables, Map<String, UploadedFile> uploadedFiles) throws PortalException, FormFilterException {
        Map updatedVariables;
        boolean deleteOnEnding;
        List actors;
        String title;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        Locale locale = null;
        if (portalControllerContext.getHttpServletRequest() != null && portalControllerContext.getHttpServletRequest().getLocale() != null) {
            locale = portalControllerContext.getHttpServletRequest().getLocale();
        }
        Bundle bundle = this.bundleFactory.getBundle(locale);
        PropertyMap instanceProperties = taskProperties.getMap("nt:pi");
        String instancePath = instanceProperties.getString("ecm:path");
        String previousTaskInitiator = taskProperties.getString("nt:initiator");
        String modelWebId = instanceProperties.getString("pi:procedureModelWebId");
        Document model = this.getModel(portalControllerContext, modelWebId);
        String procedureInitiator = instanceProperties.getString("pi:procedureInitiator");
        Date date = instanceProperties.getDate("dc:created");
        String startDate = DATE_FORMAT.format(date);
        date = instanceProperties.getDate("dc:modified");
        String lastModified = DATE_FORMAT.format(date);
        String currentStep = instanceProperties.getString("pi:currentStep");
        PropertyMap previousStepProperties = this.getStepProperties(model, currentStep);
        PropertyMap actionProperties = this.getActionProperties(previousStepProperties, actionId, currentStep, bundle);
        String nextStep = actionProperties.getString("stepReference");
        if (StringUtils.isBlank((String)nextStep)) {
            String errorMessage = bundle.getString("FORMS_NO_NEXT_STEP", new Object[]{actionId, nextStep});
            throw new PortalException(errorMessage);
        }
        if (StringUtils.equals((String)"endStep", (String)nextStep)) {
            title = "";
            actors = new ArrayList(0);
        } else {
            PropertyMap nextStepProperties = this.getStepProperties(model, nextStep);
            if (nextStepProperties == null) {
                String errorMessage = bundle.getString("FORMS_BAD_NEXT_STEP", new Object[]{nextStep, actionId, currentStep});
                throw new PortalException(errorMessage);
            }
            title = nextStepProperties.getString("name");
            actors = this.getActors(model, nextStep, title, nextStepProperties);
        }
        Map globalVariableValuesMap = instanceProperties.getMap("pi:globalVariablesValues").map();
        HashMap globalVariableValues = new HashMap(globalVariableValuesMap.size());
        for (Map.Entry gvvEntry : globalVariableValuesMap.entrySet()) {
            globalVariableValues.put(gvvEntry.getKey(), String.valueOf(gvvEntry.getValue()));
        }
        if (variables == null) {
            variables = new HashMap<String, String>();
        }
        if (uploadedFiles == null) {
            uploadedFiles = new HashMap<String, UploadedFile>(0);
        }
        variables.putAll(this.getUploadedFilesVariables(portalControllerContext, uploadedFiles));
        String procedureInstanceUuid = (String)globalVariableValues.get("uuid");
        this.requiredFieldsValidation(portalControllerContext, previousStepProperties, variables, uploadedFiles);
        procLogger.info((Object)("Proceed " + procedureInstanceUuid + " (" + modelWebId + ") to step " + actionProperties.getString("stepReference") + ", actors " + actors));
        procLogger.info((Object)("  global variables " + Collections.singletonList(variables)));
        FormFilterContext filterContext = this.callFilters(modelWebId, procedureInstanceUuid, actionId, variables, actionProperties, actors, globalVariableValues, uploadedFiles, portalControllerContext, procedureInitiator, startDate, lastModified, previousTaskInitiator, nextStep, currentStep, bundle);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("pi:currentStep", actionProperties.getString("stepReference"));
        properties.put("pi:procedureModelWebId", modelWebId);
        properties.put("pi:globalVariablesValues", this.convertVariablesToJson(portalControllerContext, globalVariableValues));
        UpdateProcedureCommand command = new UpdateProcedureCommand(instancePath, title, filterContext.getActors(), filterContext.getAdditionalAuthorizations(), properties);
        String savedContextScope = cmsContext.getScope();
        try {
            if (portalControllerContext.getHttpServletRequest() == null) {
                cmsContext.setScope("superuser_no_cache");
            }
            DocRef docRef = (DocRef)this.cmsCustomizer.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            cmsContext.setScope("superuser_no_cache");
            BlobsProcedureCommand blobCmd = new BlobsProcedureCommand(uploadedFiles, docRef);
            this.cmsCustomizer.executeNuxeoCommand(cmsContext, (INuxeoCommand)blobCmd);
        }
        catch (CMSException e) {
            throw new PortalException((Exception)((Object)e));
        }
        finally {
            cmsContext.setScope(savedContextScope);
        }
        boolean endStep = "endStep".equals(filterContext.getNextStep());
        if (!endStep) {
            String uuid = (String)globalVariableValues.get("uuid");
            String initiator = "";
            initiator = portalControllerContext.getHttpServletRequest() != null ? portalControllerContext.getHttpServletRequest().getRemoteUser() : "admin";
            ProcedureSendMailModule sendModule = new ProcedureSendMailModule(portalControllerContext, this.cmsCustomizer.getPortletContext(), this, uuid, initiator);
            if (this.transactionService.isStarted()) {
                this.transactionService.registerPostcommit((IPostcommitResource)sendModule);
            } else {
                sendModule.run();
            }
        }
        if ((deleteOnEnding = BooleanUtils.toBoolean((String)((String)(updatedVariables = filterContext.getVariables()).get("deleteOnEnding")))) && endStep) {
            ProcedureRemoveInstanceModule removeInstanceModule = new ProcedureRemoveInstanceModule(cmsContext, cmsService, instancePath);
            if (this.transactionService.isStarted()) {
                this.transactionService.registerPostcommit((IPostcommitResource)removeInstanceModule);
            } else {
                removeInstanceModule.run();
            }
        }
        procLogger.info((Object)(" Procedure proceeded " + (String)globalVariableValues.get("uuid")));
        return updatedVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDigest(File file) throws IOException {
        String digest;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            digest = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return digest;
    }

    private void requiredFieldsValidation(PortalControllerContext portalControllerContext, PropertyMap step, Map<String, String> variables, Map<String, UploadedFile> uploadedFiles) throws FormFilterException {
        Locale locale = null;
        if (portalControllerContext.getHttpServletRequest() != null && portalControllerContext.getHttpServletRequest().getLocale() != null) {
            locale = portalControllerContext.getHttpServletRequest().getLocale();
        }
        Bundle bundle = this.bundleFactory.getBundle(locale);
        PropertyList fields = step.getList("globalVariablesReferences");
        for (int i = 0; i < fields.size(); ++i) {
            String name;
            String value;
            PropertyMap field = fields.getMap(i);
            boolean required = BooleanUtils.isTrue((Boolean)field.getBoolean("required"));
            if (!required || !StringUtils.isBlank((String)(value = variables.get(name = field.getString("variableName"))))) continue;
            String label = StringUtils.defaultIfEmpty((String)field.getString("superLabel"), (String)name);
            String message = bundle.getString("MESSAGE_MISSING_REQUIRED_FIELD_ERROR", new Object[]{label});
            throw new FormFilterException(message);
        }
    }

    private FormFilterContext callFilters(String modelWebId, String procedureInstanceUuid, String actionId, Map<String, String> variables, PropertyMap actionProperties, List<String> actors, Map<String, String> globalVariableValues, Map<String, UploadedFile> uploadedFiles, PortalControllerContext portalControllerContext, String procedureInitiator, String startDate, String lastModified, String taskInitiator, String nextStep, String currentStep, Bundle bundle) throws FormFilterException, PortalException {
        String message;
        CustomizationPluginMgr pluginManager = this.cmsCustomizer.getPluginManager();
        Map portalFilters = pluginManager.getFormFilters();
        PropertyList actionFilters = actionProperties.getList("filtersList");
        HashMap<String, ArrayList<FormFilterInstance>> filtersByParentPathMap = new HashMap<String, ArrayList<FormFilterInstance>>();
        HashMap filtersParams = new HashMap();
        for (Object filterObject : actionFilters.list()) {
            PropertyMap filterMap = (PropertyMap)filterObject;
            FormFilter filter = (FormFilter)portalFilters.get(filterMap.getString("filterId"));
            if (filter == null) continue;
            FormFilterInstance filterInstance = new FormFilterInstance(filter, filterMap.getString("filterPath"), filterMap.getString("filterName"), filterMap.getString("filterInstanceId"));
            String parentPath = StringUtils.contains((String)filterInstance.getPath(), (char)',') ? StringUtils.substringBeforeLast((String)filterInstance.getPath(), (String)",") : "";
            ArrayList<FormFilterInstance> parentFiltersList = (ArrayList<FormFilterInstance>)filtersByParentPathMap.get(parentPath);
            if (parentFiltersList == null) {
                parentFiltersList = new ArrayList<FormFilterInstance>();
            }
            parentFiltersList.add(filterInstance);
            filtersByParentPathMap.put(parentPath, parentFiltersList);
            PropertyList argumentsList = filterMap.getList("argumentsList");
            if (argumentsList == null) continue;
            HashMap<String, String> filterParams = new HashMap<String, String>(argumentsList.size());
            for (int i = 0; i < argumentsList.size(); ++i) {
                PropertyMap argumentMap = argumentsList.getMap(i);
                if (!StringUtils.isNotBlank((String)argumentMap.getString("argumentName"))) continue;
                filterParams.put(argumentMap.getString("argumentName"), argumentMap.getString("argumentValue"));
            }
            filtersParams.put(filterInstance.getId(), filterParams);
        }
        FormFilterContext filterContext = new FormFilterContext(filtersParams, procedureInitiator, taskInitiator, startDate, lastModified, nextStep, currentStep);
        filterContext.setPortalControllerContext(portalControllerContext);
        filterContext.setModelWebId(modelWebId);
        filterContext.setProcedureInstanceUuid(procedureInstanceUuid);
        filterContext.setActionId(actionId);
        filterContext.setUploadedFiles(uploadedFiles);
        if (globalVariableValues != null) {
            globalVariableValues.putAll(variables);
            filterContext.setVariables(globalVariableValues);
        } else {
            filterContext.setVariables(variables);
        }
        if (CollectionUtils.isNotEmpty(actors)) {
            filterContext.getActors().addAll(actors);
        }
        FormFilterExecutor parentExecutor = new FormFilterExecutor(filtersByParentPathMap, "", "", bundle);
        try {
            parentExecutor.executeChildren(filterContext);
        }
        catch (FormFilterException | PortalApplicationException e) {
            throw e;
        }
        catch (PortalException e) {
            if (e.getCause() != null && e.getMessage() != null) {
                message = bundle.getString("FORMS_FILTER_ERROR_FILTER", new Object[]{e.getMessage()});
                this.log.error((Object)message, (Throwable)e);
                throw new PortalException(message, (Throwable)e);
            }
            if (e.getMessage() != null) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            this.log.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            message = bundle.getString("FORMS_FILTER_ERROR");
            this.log.error((Object)message, (Throwable)e);
            throw new PortalException(message, (Throwable)e);
        }
        return filterContext;
    }

    private Document getModel(PortalControllerContext portalControllerContext, String webId) throws PortalException {
        CMSItem cmsItem;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        cmsContext.setScope("superuser_context");
        String path = NuxeoController.webIdToFetchPath((String)webId);
        try {
            cmsItem = cmsService.getContent(cmsContext, path);
        }
        catch (CMSException e) {
            throw new PortalException((Exception)((Object)e));
        }
        return (Document)cmsItem.getNativeItem();
    }

    private PropertyMap getStepProperties(Document model, String step) {
        PropertyList steps = model.getProperties().getList("pcd:steps");
        PropertyMap properties = null;
        if (!StringUtils.equals((String)step, (String)"endStep")) {
            for (int i = 0; i < steps.size(); ++i) {
                PropertyMap map = steps.getMap(i);
                if (!StringUtils.equals((String)step, (String)map.getString("reference"))) continue;
                properties = map;
                break;
            }
        }
        return properties;
    }

    private PropertyMap getActionProperties(PropertyMap stepProperties, String actionId, String step, Bundle bundle) throws PortalException {
        if (actionId == null) {
            actionId = String.valueOf(stepProperties.get("actionIdDefault"));
        }
        if (StringUtils.isBlank((String)actionId)) {
            String errorMessage = bundle.getString("FORMS_NO_ACTION");
            throw new PortalException(errorMessage);
        }
        PropertyList actions = stepProperties.getList("actions");
        PropertyMap properties = null;
        for (int i = 0; i < actions.size(); ++i) {
            PropertyMap map = actions.getMap(i);
            if (!StringUtils.equals((String)actionId, (String)map.getString("actionId"))) continue;
            properties = map;
            break;
        }
        if (properties == null) {
            String errorMessage = bundle.getString("FORMS_BAD_ACTION", new Object[]{actionId, step});
            throw new PortalException(errorMessage);
        }
        return properties;
    }

    private void sendEmailNotification(PortalControllerContext portalControllerContext, String procedureInstanceId, String initiator) throws CMSException, PortalException {
        PortletContext portletContext = this.cmsCustomizer.getPortletContext();
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        Locale locale = null;
        if (portalControllerContext.getHttpServletRequest() != null) {
            locale = portalControllerContext.getHttpServletRequest().getLocale();
        }
        Bundle bundle = this.bundleFactory.getBundle(locale);
        if (StringUtils.isNotEmpty((String)procedureInstanceId)) {
            PropertyList actors;
            UUID uuid = UUID.fromString(procedureInstanceId);
            GetTasksCommand command = new GetTasksCommand(null, null, uuid);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            if (documents.size() != 1) {
                throw new CMSException(3);
            }
            Document task = documents.get(0);
            PropertyMap variables = task.getProperties().getMap("nt:task_variables");
            if (BooleanUtils.isTrue((Boolean)variables.getBoolean("notifEmail")) && !(actors = task.getProperties().getList("nt:actors")).isEmpty()) {
                HashSet<Name> names = new HashSet<Name>(actors.size());
                for (int i = 0; i < actors.size(); ++i) {
                    String actor = actors.getString(i);
                    Group group = StringUtils.startsWith((String)actor, (String)"user:") ? null : (StringUtils.startsWith((String)actor, (String)"group:") ? this.groupService.get(StringUtils.removeStart((String)actor, (String)"group:")) : this.groupService.get(actor));
                    if (group == null) {
                        String user = StringUtils.removeStart((String)actor, (String)"user:");
                        names.add(this.personService.getEmptyPerson().buildDn(user));
                        continue;
                    }
                    for (Name member : group.getMembers()) {
                        names.add(member);
                    }
                }
                HashSet<String> emailRecipients = new HashSet<String>(names.size());
                for (Name name : names) {
                    String email;
                    Person person = this.personService.getPerson(name);
                    if (person == null || !StringUtils.isNotBlank((String)(email = person.getMail()))) continue;
                    emailRecipients.add(email);
                }
                if (!emailRecipients.isEmpty()) {
                    Person sender = this.personService.getPerson(initiator);
                    String emailSender = StringUtils.defaultIfBlank((String)sender.getMail(), (String)initiator);
                    String expression = variables.getString("stringMsg");
                    try {
                        String acceptActionId;
                        Session mailSession = Session.getInstance((Properties)System.getProperties(), null);
                        MimeMessage message = new MimeMessage(mailSession);
                        message.setSentDate(new Date());
                        InternetAddress from = new InternetAddress(emailSender);
                        message.setFrom((Address)from);
                        InternetAddress[] to = InternetAddress.parse((String)StringUtils.join(emailRecipients, (String)","));
                        message.setRecipients(Message.RecipientType.TO, (Address[])to);
                        InternetAddress[] replyTo = new InternetAddress[]{from};
                        message.setReplyTo((Address[])replyTo);
                        String subject = StringUtils.substringBefore((String)this.transform(portalControllerContext, expression, task, true), (String)System.lineSeparator());
                        message.setSubject(subject, "UTF-8");
                        String inlineBody = this.transform(portalControllerContext, expression, task, false);
                        StringBuilder body = new StringBuilder();
                        for (String line : StringUtils.split((String)inlineBody, (String)System.lineSeparator())) {
                            body.append("<p>");
                            body.append(line);
                            body.append("</p>");
                        }
                        if (BooleanUtils.isTrue((Boolean)variables.getBoolean("acquitable")) && StringUtils.isNotBlank((String)(acceptActionId = variables.getString("actionIdYes")))) {
                            String url = this.tasksService.getCommandUrl(portalControllerContext, uuid, acceptActionId);
                            String title = bundle.getString("ACCEPT");
                            Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)title);
                            body.append("<p>");
                            body.append(DOM4JUtils.writeCompact((Element)link));
                            body.append("</p>");
                        }
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart htmlPart = new MimeBodyPart();
                        htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
                        multipart.addBodyPart((BodyPart)htmlPart);
                        message.setContent((Multipart)multipart);
                        procLogger.info((Object)("  About to send mail on " + uuid + " from " + emailSender + " to " + StringUtils.join(emailRecipients, (String)",") + " subject " + subject));
                        SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
                        transport.connect();
                        transport.sendMessage((Message)message, message.getAllRecipients());
                        transport.close();
                        procLogger.info((Object)("  Mail sentl on " + uuid));
                    }
                    catch (MessagingException e) {
                        this.log.warn((Object)"Email sending error", e.getCause());
                    }
                }
            }
        }
    }

    public String transform(PortalControllerContext portalControllerContext, String expression, Document task) throws PortalException {
        return this.transform(portalControllerContext, expression, task, false);
    }

    protected String transform(PortalControllerContext portalControllerContext, String expression, Document task, boolean disabledLinks) throws PortalException {
        PropertyMap globalVariables;
        PropertyMap instanceProperties = task.getProperties().getMap("nt:pi");
        if (instanceProperties == null) {
            instanceProperties = new PropertyMap(0);
        }
        if ((globalVariables = instanceProperties.getMap("pi:globalVariablesValues")) == null) {
            globalVariables = new PropertyMap(0);
        }
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        HashMap variables = new HashMap(globalVariables.size() + taskVariables.size());
        for (Map.Entry entry : globalVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : taskVariables.getMap().entrySet()) {
            variables.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        variables.put("procedureInitiator", instanceProperties.getString("pi:procedureInitiator"));
        variables.put("taskInitiator", task.getString("nt:initiator"));
        variables.put("taskName", task.getString("nt:name"));
        variables.put("taskUuid", task.getId());
        variables.put("taskPath", task.getPath());
        return this.transform(portalControllerContext, expression, variables, disabledLinks);
    }

    public String transform(PortalControllerContext portalControllerContext, String expression, Map<String, String> variables) throws PortalException {
        return this.transform(portalControllerContext, expression, variables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transform(PortalControllerContext portalControllerContext, String expression, Map<String, String> variables, boolean disabledLinks) throws PortalException {
        String transformedExpression;
        String value;
        UUID uuid = null;
        if (variables != null && StringUtils.isNotBlank((String)(value = variables.get("uuid")))) {
            uuid = UUID.fromString(value);
        }
        ThreadLocalContainer container = new ThreadLocalContainer(this, portalControllerContext, uuid, disabledLinks);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (MapUtils.isNotEmpty(variables)) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                context.setVariable(entry.getKey(), factory.createValueExpression((Object)entry.getValue(), String.class));
            }
        }
        try {
            context.setFunction("user", "name", TransformationFunctions.getUserDisplayNameMethod());
            context.setFunction("user", "email", TransformationFunctions.getUserEmailMethod());
            context.setFunction("group", "emails", TransformationFunctions.getGroupEmailsMethod());
            context.setFunction("document", "title", TransformationFunctions.getDocumentTitleMethod());
            context.setFunction("command", "link", TransformationFunctions.getCommandLinkMethod());
            context.setFunction("task", "link", TransformationFunctions.getViewTaskLinkMethod());
            context.setFunction("document", "linkWithText", TransformationFunctions.getDocumentLinkWithTextMethod());
            context.setFunction("portal", "link", TransformationFunctions.getPortalLinkMethod());
            context.setFunction("portal", "translate", TransformationFunctions.getPortalTranslateMethod());
            context.setFunction("portal", "prop", TransformationFunctions.getPortalPropertyMethod());
            if (disabledLinks) {
                context.setFunction("user", "link", TransformationFunctions.getUserDisplayNameMethod());
                context.setFunction("document", "link", TransformationFunctions.getDocumentTitleMethod());
            } else {
                context.setFunction("user", "link", TransformationFunctions.getUserLinkMethod());
                context.setFunction("document", "link", TransformationFunctions.getDocumentLinkMethod());
            }
            context.setFunction("discussion", "messageLink", TransformationFunctions.getViewMessageLinkMethod());
        }
        catch (NoSuchMethodException e) {
            throw new PortalException((Exception)e);
        }
        catch (SecurityException e) {
            throw new PortalException((Exception)e);
        }
        ValueExpression value2 = factory.createValueExpression((ELContext)context, StringUtils.trimToEmpty((String)expression), String.class);
        try {
            threadLocal.set(container);
            transformedExpression = String.valueOf(value2.getValue((ELContext)context));
        }
        finally {
            threadLocal.remove();
        }
        return transformedExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, String> init(PortalControllerContext portalControllerContext, Document document, Map<String, String> variables) throws PortalException, FormFilterException {
        if (document == null) return variables;
        if (variables == null) {
            variables = new HashMap();
        }
        HashMap uploadedFiles = new HashMap(0);
        Principal userPrincipal = portalControllerContext.getHttpServletRequest().getUserPrincipal();
        String procedureInitiator = null;
        procedureInitiator = userPrincipal != null ? userPrincipal.getName() : "anonymous";
        Locale locale = portalControllerContext.getHttpServletRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        PropertyMap initActionProperties = null;
        PropertyMap currentStepProperties = null;
        String startDate = null;
        String lastModified = null;
        String previousTaskInitiator = null;
        String modelWebId = null;
        String procedureInstanceUuid = null;
        if (StringUtils.equals((String)document.getType(), (String)"ProcedureModel")) {
            String startingStep = document.getString("pcd:startingStep");
            if (!StringUtils.isNotBlank((String)startingStep)) {
                String errorMessage = bundle.getString("FORMS_NO_STARTING_STEP");
                throw new PortalException(errorMessage);
            }
            modelWebId = document.getString("ttc:webid");
            PropertyMap startingStepProperties = this.getStepProperties(document, startingStep);
            if (startingStepProperties == null) {
                String errorMessage = bundle.getString("FORMS_BAD_STARTING_STEP", new Object[]{startingStep});
                throw new PortalException(errorMessage);
            }
            currentStepProperties = startingStepProperties;
        } else if (StringUtils.equals((String)document.getType(), (String)"RecordFolder")) {
            String startingStep = variables.get("pcd:startingStep");
            if (!StringUtils.isNotBlank((String)startingStep)) {
                String errorMessage = bundle.getString("FORMS_NO_STARTING_STEP");
                throw new PortalException(errorMessage);
            }
            modelWebId = document.getString("pcd:webIdParent");
            PropertyMap startingStepProperties = this.getStepProperties(document = this.getModel(portalControllerContext, modelWebId), startingStep);
            if (startingStepProperties == null) {
                String errorMessage = bundle.getString("FORMS_BAD_STARTING_STEP", new Object[]{startingStep});
                throw new PortalException(errorMessage);
            }
            currentStepProperties = startingStepProperties;
        } else {
            PropertyMap instanceProperties = null;
            if (StringUtils.equals((String)document.getType(), (String)"ProcedureInstance")) {
                instanceProperties = document.getProperties();
            } else if (StringUtils.equals((String)document.getType(), (String)"TaskDoc")) {
                PropertyMap taskProperties = document.getProperties();
                instanceProperties = taskProperties.getMap("nt:pi");
                previousTaskInitiator = taskProperties.getString("nt:initiator");
            }
            modelWebId = instanceProperties.getString("pi:procedureModelWebId");
            Document model = this.getModel(portalControllerContext, modelWebId);
            if (StringUtils.equals((String)model.getType(), (String)"RecordFolder")) {
                modelWebId = model.getString("pcd:webIdParent");
                model = this.getModel(portalControllerContext, modelWebId);
            }
            String currentStep = instanceProperties.getString("pi:currentStep");
            currentStepProperties = this.getStepProperties(model, currentStep);
            Map globalVariableValuesMap = instanceProperties.getMap("pi:globalVariablesValues").map();
            HashMap globalVariableValues = new HashMap(globalVariableValuesMap.size());
            for (Map.Entry gvvEntry : globalVariableValuesMap.entrySet()) {
                globalVariableValues.put(gvvEntry.getKey(), String.valueOf(gvvEntry.getValue()));
            }
            procedureInstanceUuid = (String)globalVariableValues.get("uuid");
            Date date = instanceProperties.getDate("dc:created");
            startDate = DATE_FORMAT.format(date);
            date = instanceProperties.getDate("dc:modified");
            lastModified = DATE_FORMAT.format(date);
        }
        if (currentStepProperties == null) return variables;
        initActionProperties = currentStepProperties.getMap("initAction");
        if (initActionProperties == null) return variables;
        return this.callFilters(modelWebId, procedureInstanceUuid, null, variables, initActionProperties, null, null, uploadedFiles, portalControllerContext, procedureInitiator, startDate, lastModified, previousTaskInitiator, null, null, bundle).getVariables();
    }

    public Map<String, String> getUploadedFilesVariables(PortalControllerContext portalControllerContext, Map<String, UploadedFile> uploadedFiles) throws PortalException {
        HashMap<String, String> variables;
        if (MapUtils.isEmpty(uploadedFiles)) {
            variables = new HashMap<String, String>(0);
        } else {
            variables = new HashMap(uploadedFiles.size());
            for (Map.Entry<String, UploadedFile> entry : uploadedFiles.entrySet()) {
                String digest;
                String variableName = entry.getKey();
                UploadedFile uploadedFile = entry.getValue();
                File temporaryFile = uploadedFile.getTemporaryFile();
                if (uploadedFile.isDeleted()) {
                    variables.put(variableName, null);
                    continue;
                }
                if (temporaryFile == null) continue;
                try {
                    digest = this.getDigest(temporaryFile);
                }
                catch (IOException e) {
                    throw new PortalException((Exception)e);
                }
                JSONObject object = new JSONObject();
                object.put((Object)"digest", (Object)digest);
                object.put((Object)"fileName", (Object)uploadedFile.getTemporaryMetadata().getFileName());
                variables.put(variableName, object.toString());
            }
        }
        return variables;
    }

    public String convertToJson(PortalControllerContext portalControllerContext, Object object) throws PortalException {
        ObjectWriter writer = this.mapper.writer();
        try {
            return writer.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
    }

    public String convertVariablesToJson(PortalControllerContext portalControllerContext, Map<String, String> variables) throws PortalException {
        HashSet objects = new HashSet();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            HashMap<String, String> object = new HashMap<String, String>(2);
            object.put("name", entry.getKey());
            object.put("value", StringUtils.trimToEmpty((String)entry.getValue()));
            objects.add(object);
        }
        return this.convertToJson(portalControllerContext, objects);
    }

    public static PortalControllerContext getPortalControllerContext() {
        ThreadLocalContainer container = (ThreadLocalContainer)threadLocal.get();
        PortalControllerContext portalControllerContext = container == null ? null : ThreadLocalContainer.access$000((ThreadLocalContainer)container);
        return portalControllerContext;
    }

    public static UUID getUuid() {
        ThreadLocalContainer container = (ThreadLocalContainer)threadLocal.get();
        UUID uuid = container == null ? null : ThreadLocalContainer.access$100((ThreadLocalContainer)container);
        return uuid;
    }

    public static boolean areLinksDisabled() {
        ThreadLocalContainer container = (ThreadLocalContainer)threadLocal.get();
        boolean disabledLinks = container == null ? false : ThreadLocalContainer.access$200((ThreadLocalContainer)container);
        return disabledLinks;
    }
}

