/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.selectors.VocabularySelect2Portlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.page.PageProperties;

public class VocabularySelect2Portlet
extends CMSPortlet {
    private static final String LABEL_WINDOW_PROPERTY = "osivia.selector.label";
    private static final String ALL_LABEL_WINDOW_PROPERTY = "osivia.selector.allLabel";
    private static final String ID_WINDOW_PROPERTY = "osivia.selector.id";
    private static final String VOCABULARY_WINDOW_PROPERTY = "osivia.selector.vocabulary";
    private static final String MONO_VALUED_WINDOW_PROPERTY = "osivia.selector.monoValued";
    private static final String VIEW_PATH = "/WEB-INF/jsp/selectors/select2/view.jsp";
    private static final String ADMIN_PATH = "/WEB-INF/jsp/selectors/select2/admin.jsp";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Map selectors;
        List selector;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Configuration configuration = this.getConfiguration(window);
        request.setAttribute("configuration", (Object)configuration);
        if (configuration.getId() != null && configuration.getVocabulary() != null && (selector = (List)(selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"))).get(configuration.getId())) != null) {
            LinkedHashMap<String, String> selectedItems = new LinkedHashMap<String, String>(selector.size());
            request.setAttribute("selectedItems", selectedItems);
            for (String key : selector) {
                String vocabularyKey = key.contains("/") ? StringUtils.substringAfterLast((String)key, (String)"/") : key;
                String value = VocabularyHelper.getVocabularyLabel((NuxeoController)nuxeoController, (String)configuration.getVocabulary(), (String)vocabularyKey);
                selectedItems.put(key, value);
            }
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PATH);
        dispatcher.include(request, response);
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Configuration configuration = this.getConfiguration(window);
        request.setAttribute("configuration", (Object)configuration);
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(ADMIN_PATH);
        dispatcher.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        Configuration configuration = this.getConfiguration(window);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("save".equals(action) && configuration.getId() != null && configuration.getVocabulary() != null) {
                ArrayList<Object> selector;
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (request.getParameter("selectors") != null) {
                    response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                }
                if ((selector = (ArrayList<Object>)selectors.get(configuration.getId())) == null) {
                    selector = new ArrayList<Object>();
                    selectors.put(configuration.getId(), selector);
                } else {
                    selector.clear();
                }
                if (request.getParameter("clear") == null) {
                    Object[] values = request.getParameterValues("vocabulary");
                    if (ArrayUtils.isEmpty((Object[])values) || values.length == 1 && StringUtils.isEmpty((String)values[0])) {
                        selectors.remove(configuration.getId());
                    } else {
                        for (Object value : values) {
                            selector.add(value);
                        }
                    }
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                response.removePublicRenderParameter("search-filter");
                PageProperties.getProperties().setRefreshingPage(true);
                request.setAttribute("osivia.unsetMaxMode", (Object)String.valueOf(true));
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty(LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("label")));
                window.setProperty(ALL_LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("allLabel")));
                window.setProperty(ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("id")));
                window.setProperty(VOCABULARY_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("vocabulary")));
                window.setProperty(MONO_VALUED_WINDOW_PROPERTY, String.valueOf(BooleanUtils.toBoolean((String)request.getParameter("monoValued"))));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    private Configuration getConfiguration(PortalWindow window) {
        Configuration configuration = new Configuration(this);
        configuration.setLabel(window.getProperty(LABEL_WINDOW_PROPERTY));
        configuration.setAllLabel(window.getProperty(ALL_LABEL_WINDOW_PROPERTY));
        configuration.setId(window.getProperty(ID_WINDOW_PROPERTY));
        configuration.setVocabulary(window.getProperty(VOCABULARY_WINDOW_PROPERTY));
        configuration.setMonoValued(BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)window.getProperty(MONO_VALUED_WINDOW_PROPERTY))));
        return configuration;
    }
}

