/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.transaction.IPostcommitResource;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class ProcedureRemoveInstanceModule
implements IPostcommitResource {
    ICMSService cmsService;
    CMSServiceCtx cmsContext;
    String procedureInstancePath;
    private static final Log log = LogFactory.getLog(ProcedureRemoveInstanceModule.class);
    private static final Log procLogger = LogFactory.getLog((String)"procedures");

    ProcedureRemoveInstanceModule(CMSServiceCtx cmsContext, ICMSService cmsService, String procedureInstancePath) {
        this.cmsContext = cmsContext;
        this.cmsService = cmsService;
        this.procedureInstancePath = procedureInstancePath;
    }

    public void run() {
        try {
            String savedScope = this.cmsContext.getScope();
            String savedForcedScope = this.cmsContext.getForcePublicationInfosScope();
            boolean saveForceReload = this.cmsContext.isForceReload();
            try {
                this.cmsContext.setForceReload(true);
                this.cmsContext.setScope("superuser_no_cache");
                this.cmsContext.setForcePublicationInfosScope("superuser_no_cache");
                this.cmsService.deleteDocument(this.cmsContext, this.procedureInstancePath);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
            finally {
                this.cmsContext.setForceReload(saveForceReload);
                this.cmsContext.setScope(savedScope);
                this.cmsContext.setForcePublicationInfosScope(savedForcedScope);
            }
        }
        catch (Exception e) {
            log.error((Object)"ProcedureRemoveInstanceModule error - ", e.getCause());
        }
    }
}

