/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.portlet.PrivilegedPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ProcedureTemplateModule
extends PrivilegedPortletModule {
    private static final Log LOGGER = LogFactory.getLog(ProcedureTemplateModule.class);
    private static final String VAR__RQST_USR = "${user}";

    public ProcedureTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    public int getAuthType() {
        return NuxeoCommandContext.AUTH_TYPE_SUPERUSER;
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        super.doView(request, response, portletContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String procedureModelWebid = window.getProperty("osivia.forms.list.model.id");
        String dashboardName = window.getProperty("osivia.forms.dashboard.id");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        Document procedureModel = this.getDocument(nuxeoController, procedureModelWebid);
        PropertyMap properties = procedureModel.getProperties();
        PropertyMap dashboardM = this.getDashboard(properties, dashboardName);
        request.setAttribute("dashboardName", (Object)dashboardM.getString("name"));
        List dashBoardColumns = dashboardM.getList("columns").list();
        request.setAttribute("dashboardColumns", (Object)dashBoardColumns);
        request.setAttribute("exportVarList", (Object)dashboardM.getList("exportVarList").list());
        Map variablesDefinitions = this.getVariablesDefinitions(properties);
        request.setAttribute("variablesDefinitions", (Object)variablesDefinitions);
        Map varsOptionsMap = this.buildVarOptionsMap(variablesDefinitions);
        request.setAttribute("varOptionsMap", (Object)varsOptionsMap);
        List documents = (List)request.getAttribute("documents");
        for (DocumentDTO documentDTO : documents) {
            this.updateDocValues(dashBoardColumns, variablesDefinitions, varsOptionsMap, documentDTO);
        }
        Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
        List sortValueL = (List)selectors.get("sortValue");
        List sortOrderL = (List)selectors.get("sortOrder");
        String sortValue = null;
        if (CollectionUtils.isNotEmpty((Collection)sortValueL)) {
            sortValue = (String)sortValueL.get(0);
        }
        String sortOrder = null;
        if (CollectionUtils.isNotEmpty((Collection)sortOrderL)) {
            sortOrder = (String)sortOrderL.get(0);
        }
        sortValue = StringUtils.defaultIfBlank((String)sortValue, (String)"rcd:globalVariablesValues._title");
        sortValue = StringUtils.removeStart((String)sortValue, (String)"rcd:globalVariablesValues.");
        sortValue = StringUtils.removeStart((String)sortValue, (String)"pi:globalVariablesValues.");
        request.setAttribute("sortValue", (Object)sortValue);
        request.setAttribute("sortOrder", (Object)StringUtils.defaultIfBlank((String)sortOrder, (String)"ASC"));
    }

    private void updateDocValues(List<Object> dashBoardColumns, Map<String, Map<String, String>> variablesDefinitions, Map<String, Map<String, String>> varsOptionsMap, DocumentDTO documentDTO) {
        Map globalVariablesValues = this.getGlobalVariableValues(documentDTO);
        if (globalVariablesValues != null) {
            for (Object columnO : dashBoardColumns) {
                PropertyMap column = (PropertyMap)columnO;
                String variableName = column.getString("variableName");
                String varValue = (String)globalVariablesValues.get(variableName);
                Map<String, String> varOptionsMap = varsOptionsMap.get(variableName);
                Map<String, String> variableDefinition = variablesDefinitions.get(variableName);
                this.updateValue(documentDTO, variableName, varValue, varOptionsMap, variableDefinition);
            }
        }
    }

    private Map<String, String> getGlobalVariableValues(DocumentDTO documentDTO) {
        Map docProperties = documentDTO.getProperties();
        Map globalVariablesValues = null;
        if (StringUtils.equals((String)documentDTO.getDocument().getType(), (String)"Record")) {
            globalVariablesValues = (Map)docProperties.get("rcd:globalVariablesValues");
        } else if (StringUtils.equals((String)documentDTO.getDocument().getType(), (String)"ProcedureInstance")) {
            globalVariablesValues = (Map)docProperties.get("pi:globalVariablesValues");
        }
        return globalVariablesValues;
    }

    private void updateValue(DocumentDTO documentDTO, String variableName, String varValue, Map<String, String> varOptionsMap, Map<String, String> variableDefinition) {
        if (StringUtils.isNotBlank((String)varValue)) {
            String value;
            String type = variableDefinition == null ? null : variableDefinition.get("type");
            if ("FILE".equals(type) || "PICTURE".equals(type)) {
                try {
                    JSONObject jsonObject = JSONObject.fromObject((Object)varValue);
                    String digest = jsonObject.getString("digest");
                    String fileName = jsonObject.getString("fileName");
                    value = null;
                    Iterator iterator = documentDTO.getAttachments().iterator();
                    while (value == null && iterator.hasNext()) {
                        DocumentAttachmentDTO attachment = (DocumentAttachmentDTO)iterator.next();
                        if (!StringUtils.equals((String)digest, (String)attachment.getDigest()) || !StringUtils.equals((String)fileName, (String)attachment.getName())) continue;
                        value = attachment;
                    }
                }
                catch (JSONException e) {
                    value = null;
                }
            } else if (varOptionsMap != null) {
                Object[] splittedValues = StringUtils.split((String)varValue, (char)',');
                for (int j = 0; j < splittedValues.length; ++j) {
                    splittedValues[j] = varOptionsMap.get(splittedValues[j]) != null ? varOptionsMap.get(splittedValues[j]) : splittedValues[j];
                }
                value = StringUtils.join((Object[])splittedValues, (char)',');
            } else {
                value = varValue;
            }
            documentDTO.getProperties().put(variableName, value);
        }
    }

    protected void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        super.processAction(request, response, portletContext);
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (StringUtils.equals((String)"admin", (String)request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.forms.list.model.id", StringUtils.trimToNull((String)request.getParameter("procedureModelId")));
                window.setProperty("osivia.forms.dashboard.id", StringUtils.trimToNull((String)request.getParameter("dashboardId")));
            }
        } else if (StringUtils.equals((String)PortletMode.VIEW.toString(), (String)request.getPortletMode().toString())) {
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            ArrayList<String> sortValueL = (ArrayList<String>)selectors.get("sortValue");
            ArrayList<String> sortOrderL = (ArrayList<String>)selectors.get("sortOrder");
            if (sortValueL == null) {
                sortValueL = new ArrayList<String>();
            } else {
                sortValueL.clear();
            }
            if (sortOrderL == null) {
                sortOrderL = new ArrayList<String>();
            } else {
                sortOrderL.clear();
            }
            String sortValue = request.getParameter("sortValue");
            if (!StringUtils.startsWith((String)sortValue, (String)"dc:")) {
                sortValue = StringUtils.equals((String)window.getProperty("osivia.doctype"), (String)"RecordFolder") ? "rcd:globalVariablesValues.".concat(sortValue) : "pi:globalVariablesValues.".concat(sortValue);
            }
            sortValueL.add(StringUtils.defaultIfBlank((String)sortValue, (String)"rcd:globalVariablesValues._title"));
            sortOrderL.add(StringUtils.defaultIfBlank((String)request.getParameter("sortOrder"), (String)"ASC"));
            selectors.put("sortValue", sortValueL);
            selectors.put("sortOrder", sortOrderL);
            response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
        }
    }

    protected void serveResource(ResourceRequest request, ResourceResponse response, PortletContext portletContext) throws PortletException, IOException {
        String resourceID = request.getResourceID();
        if (StringUtils.equals((String)resourceID, (String)"exportCSV")) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String procedureModelWebid = window.getProperty("osivia.forms.list.model.id");
            String dashboardNameProperty = window.getProperty("osivia.forms.dashboard.id");
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
            Document procedureModel = this.getDocument(nuxeoController, procedureModelWebid);
            PropertyMap properties = procedureModel.getProperties();
            PropertyMap dashboardM = this.getDashboard(properties, dashboardNameProperty);
            Map variablesDefinitions = this.getVariablesDefinitions(properties);
            PropertyList exportVarList = dashboardM.getList("exportVarList");
            String dashboardName = dashboardM.getString("name");
            List documents = (List)request.getAttribute("documents");
            response.setContentType("text/csv");
            response.setCharacterEncoding("UTF-8");
            response.setProperty("Content-disposition", "attachment; filename=\"" + dashboardName + ".csv\"");
            try {
                this.printCSV(documents, exportVarList, variablesDefinitions, response.getPortletOutputStream(), nuxeoController);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCSV(List<DocumentDTO> documents, PropertyList exportVarList, Map<String, Map<String, String>> variablesDefinitions, OutputStream portletOutputStream, NuxeoController nuxeoController) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(portletOutputStream);
        writer.write(65279);
        try {
            String[] header = null;
            if (exportVarList != null && !exportVarList.isEmpty()) {
                header = new String[exportVarList.size()];
                for (int i = 0; i < exportVarList.size(); ++i) {
                    String exportVar = exportVarList.getString(i);
                    Map<String, String> exportVarDef = variablesDefinitions.get(exportVar);
                    header[i] = exportVarDef != null ? StringUtils.defaultIfBlank((String)exportVarDef.get("label"), (String)exportVar) : exportVar;
                }
                CSVPrinter printer = CSVFormat.EXCEL.withHeader(header).print((Appendable)writer);
                Object[] record = null;
                for (DocumentDTO documentDTO : documents) {
                    Map docProperties = documentDTO.getProperties();
                    Map globalVariablesValues = this.getGlobalVariableValues(documentDTO);
                    record = new Object[exportVarList.size()];
                    for (int i = 0; i < exportVarList.size(); ++i) {
                        Map varsOptionsMap = this.buildVarOptionsMap(variablesDefinitions);
                        String variableName = exportVarList.getString(i);
                        String varValue = (String)globalVariablesValues.get(variableName);
                        Map varOptionsMap = (Map)varsOptionsMap.get(variableName);
                        Map<String, String> variableDefinition = variablesDefinitions.get(variableName);
                        this.updateValue(documentDTO, variableName, varValue, varOptionsMap, variableDefinition);
                        record[i] = docProperties.get(variableName);
                    }
                    printer.printRecord(record);
                }
                printer.close();
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private Map<String, Map<String, String>> buildVarOptionsMap(Map<String, Map<String, String>> variablesDefinitions) {
        HashMap<String, Map<String, String>> varsOptionsMap = new HashMap<String, Map<String, String>>(variablesDefinitions.size());
        for (Map<String, String> variablesDefinition : variablesDefinitions.values()) {
            String[] varOptionT;
            String varName = variablesDefinition.get("name");
            String varOptions = variablesDefinition.get("varOptions");
            HashMap<String, String> varOptionsMap = null;
            if (StringUtils.isNotBlank((String)varOptions) && (varOptionT = StringUtils.splitByWholeSeparator((String)(varOptions = StringUtils.substringBetween((String)varOptions, (String)"[", (String)"]")), (String)"},{")) != null) {
                varOptionsMap = new HashMap<String, String>(varOptionT.length);
                for (int j = 0; j < varOptionT.length; ++j) {
                    String varOption = varOptionT[j];
                    String[] varOptionLV = StringUtils.split((String)varOption, (char)',');
                    if (varOptionLV == null) continue;
                    String varOptionValue = null;
                    String varOptionLabel = null;
                    for (int k = 0; k < varOptionLV.length; ++k) {
                        String varOptionLVS = varOptionLV[k];
                        if (StringUtils.startsWith((String)(varOptionLVS = StringUtils.replaceChars((String)varOptionLVS, (String)"\"{}", (String)"")), (String)"label")) {
                            varOptionLabel = StringUtils.substringAfterLast((String)varOptionLVS, (String)":");
                            continue;
                        }
                        if (!StringUtils.startsWith((String)varOptionLVS, (String)"value")) continue;
                        varOptionValue = StringUtils.substringAfterLast((String)varOptionLVS, (String)":");
                    }
                    if (!StringUtils.isNotBlank(varOptionValue) || !StringUtils.isNotBlank(varOptionLabel)) continue;
                    varOptionsMap.put(varOptionValue, varOptionLabel);
                }
            }
            varsOptionsMap.put(varName, varOptionsMap);
        }
        return varsOptionsMap;
    }

    public String getFilter(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String procedureModelWebid = window.getProperty("osivia.forms.list.model.id");
        String dashboardName = window.getProperty("osivia.forms.dashboard.id");
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        if (StringUtils.isNotBlank((String)procedureModelWebid)) {
            Document procedureModel = this.getDocument(nuxeoController, procedureModelWebid);
            if (!StringUtils.equals((String)procedureModel.getType(), (String)"RecordFolder")) {
                PropertyList groups;
                PropertyMap dashboardM = this.getDashboard(procedureModel.getProperties(), dashboardName);
                if (dashboardM != null && this.isAuthorized(groups = dashboardM.getList("groups"))) {
                    String requestFilter = dashboardM.getString("requestFilter");
                    return this.parseRequest(requestFilter, request.getUserPrincipal().getName());
                }
            } else {
                return "";
            }
        }
        return "1 = 0";
    }

    private boolean isAuthorized(PropertyList groups) {
        return groups == null || groups.isEmpty() || groups.list().contains("members");
    }

    private String parseRequest(String request, String user) {
        request = StringUtils.replace((String)request, (String)VAR__RQST_USR, (String)user);
        return request;
    }

    private Document getDocument(NuxeoController nuxeoController, String procedureModelWebid) {
        NuxeoDocumentContext procedureModelContext = nuxeoController.getDocumentContext("webId:" + procedureModelWebid);
        Document procedureModel = procedureModelContext.getDocument();
        return procedureModel;
    }

    private PropertyMap getDashboard(PropertyMap properties, String dashboardName) {
        PropertyList dashboardsList = properties.getList("pcd:dashboards");
        if (StringUtils.isNotBlank((String)dashboardName)) {
            for (Object dashboardO : dashboardsList.list()) {
                PropertyMap dashboardM = (PropertyMap)dashboardO;
                if (!StringUtils.equals((String)dashboardM.getString("name"), (String)dashboardName)) continue;
                return dashboardM;
            }
        } else {
            return dashboardsList.getMap(0);
        }
        return null;
    }

    private Map<String, Map<String, String>> getVariablesDefinitions(PropertyMap properties) {
        PropertyList varDef = properties.getList("pcd:globalVariablesDefinitions");
        HashMap<String, Map<String, String>> variablesDefinitions = new HashMap<String, Map<String, String>>(varDef.size() + 2);
        for (Object varDefO : varDef.list()) {
            PropertyMap varDefM = (PropertyMap)varDefO;
            String name = varDefM.getString("name");
            String label = varDefM.getString("label");
            String type = varDefM.getString("type");
            String varOptions = varDefM.getString("varOptions");
            variablesDefinitions.put(name, this.buildVariableDefinition(name, label, type, varOptions));
        }
        variablesDefinitions.put("dc:created", this.buildVariableDefinition("dc:created", "Cr\u00e9\u00e9 le", "DATETIME", null));
        variablesDefinitions.put("dc:modified", this.buildVariableDefinition("dc:modified", "Modifi\u00e9 le", "DATETIME", null));
        return variablesDefinitions;
    }

    private Map<String, String> buildVariableDefinition(String name, String label, String type, String varOptions) {
        HashMap<String, String> variableDefinition = new HashMap<String, String>();
        variableDefinition.put("name", name);
        variableDefinition.put("label", label);
        variableDefinition.put("type", type);
        variableDefinition.put("varOptions", varOptions);
        if ("VOCABULARY".equals(type) && StringUtils.isNotBlank((String)varOptions)) {
            String vocabularyId;
            try {
                JSONObject object = JSONObject.fromObject((Object)varOptions);
                vocabularyId = object.getString("vocabularyId");
            }
            catch (JSONException e) {
                vocabularyId = null;
            }
            variableDefinition.put("vocabularyId", vocabularyId);
        }
        return variableDefinition;
    }
}

