/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class UserPagesPreloadCommand
implements INuxeoCommand {
    private final boolean useES = NuxeoCompatibility.canUseES();
    private final List<String> domains;

    public UserPagesPreloadCommand(List<String> domains) {
        this.domains = domains;
    }

    public Object execute(Session session) throws Exception {
        OperationRequest request = this.useES ? this.getESRequest(session) : this.getVCSRequest(session);
        String username = session.getLogin().getUsername();
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT * FROM Document ");
        queryBuilder.append("WHERE ecm:mixinType = 'Space' ");
        queryBuilder.append("AND ttc:isPreloadedOnLogin = 1 ");
        queryBuilder.append("AND (ecm:isProxy = 1 OR (ecm:isProxy = 0 AND ecm:mixinType <> 'WebView')) ");
        queryBuilder.append("AND ecm:currentLifeCycleState <> 'deleted' ");
        queryBuilder.append("AND ecm:isCheckedInVersion = 0 ");
        queryBuilder.append("AND (NOT ecm:path STARTSWITH '/default-domain/UserWorkspaces' OR dc:creator = '").append(username).append("') ");
        if (CollectionUtils.isNotEmpty((Collection)this.domains)) {
            queryBuilder.append("AND (");
            boolean first = true;
            for (String domain : this.domains) {
                if (first) {
                    first = false;
                } else {
                    queryBuilder.append(" OR ");
                }
                queryBuilder.append("ecm:path STARTSWITH '").append(domain).append("'");
            }
            queryBuilder.append(") ");
        }
        queryBuilder.append("ORDER BY ttc:tabOrder ASC");
        request.set("query", (Object)queryBuilder.toString());
        return request.execute();
    }

    protected OperationRequest getESRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore,common,toutatice");
        return request;
    }

    protected OperationRequest getVCSRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.Query");
        request.setHeader("X-NXDocumentProperties", "dublincore,common,toutatice");
        return request;
    }

    public String getId() {
        return "UserPagesPreloadCommand";
    }
}

