/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesPreloadCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserProfileCommand;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class UserPagesLoader {
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        HttpServletRequest request = cmsCtx.getServletRequest();
        CMSService cmsService = (CMSService)this.cmsServiceLocator.getCMSService();
        ArrayList<CMSPage> pages = new ArrayList<CMSPage>();
        if (request.getUserPrincipal() != null) {
            ArrayList<String> domains;
            String userName = request.getUserPrincipal().getName();
            cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new GetUserProfileCommand(userName));
            ArrayList domainsAttribute = new ArrayList();
            if (CollectionUtils.isEmpty(domainsAttribute)) {
                domains = null;
            } else {
                domains = new ArrayList<String>(domainsAttribute.size());
                for (Object attribute : domainsAttribute) {
                    if (!(attribute instanceof String)) continue;
                    String domain = (String)attribute;
                    domains.add(domain);
                }
            }
            Documents children = (Documents)cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new UserPagesPreloadCommand(domains));
            for (Document child : children) {
                String spacePath = DocumentHelper.computeNavPath((String)child.getPath());
                CMSItem publishSpace = cmsService.createNavigationItem(cmsCtx, spacePath, child.getTitle(), child, spacePath);
                CMSPage userPage = new CMSPage();
                userPage.setPublishSpace(publishSpace);
                pages.add(userPage);
            }
        }
        return pages;
    }
}

