/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.cms.Symlink;
import org.osivia.portal.api.cms.Symlinks;
import org.osivia.portal.api.cms.VirtualNavigationUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.NavigationItem;

public class DocumentPublishSpaceNavigationCommand
implements INuxeoCommand {
    private static final String DEFAULT_NAVIGATION_SCHEMAS = "dublincore, common, toutatice, regions, record";
    private final CMSServiceCtx cmsContext;
    private final CMSItem spaceConfig;
    private final boolean live;
    private final List<INavigationAdapterModule> navigationAdapters;

    public DocumentPublishSpaceNavigationCommand(CMSServiceCtx cmsContext, CMSItem spaceConfig, boolean forceLiveVersion, List<INavigationAdapterModule> navigationAdapters) {
        this.cmsContext = cmsContext;
        this.spaceConfig = spaceConfig;
        this.live = forceLiveVersion || "1".equals(this.spaceConfig.getProperties().get("displayLiveVersion"));
        this.navigationAdapters = navigationAdapters;
    }

    public Object execute(Session session) throws Exception {
        NavigationItem navigationItem;
        Symlinks symlinks;
        String basePath = this.spaceConfig.getNavigationPath();
        if (CollectionUtils.isEmpty((Collection)this.navigationAdapters)) {
            symlinks = null;
        } else {
            symlinks = new Symlinks();
            PortalControllerContext portalControllerContext = this.cmsContext.getPortalControllerContext();
            for (INavigationAdapterModule navigationAdapter : this.navigationAdapters) {
                Symlinks adapterSymlinks = navigationAdapter.getSymlinks(portalControllerContext);
                if (adapterSymlinks == null) continue;
                symlinks.addAll(adapterSymlinks);
            }
        }
        Set extraPaths = symlinks == null || CollectionUtils.isEmpty((Collection)symlinks.getPaths()) ? new HashSet(0) : symlinks.getPaths();
        OperationRequest operationRequest = session.newRequest("Document.Query");
        StringBuilder clause = new StringBuilder();
        clause.append("(ecm:path STARTSWITH '");
        clause.append(basePath);
        if (!this.live) {
            clause.append("' OR ecm:path = '");
            clause.append(basePath);
            clause.append(".proxy");
        }
        clause.append("') AND (ecm:mixinType = 'Folderish' OR ttc:showInMenu = 1)");
        NuxeoQueryFilterContext filter = this.live ? NuxeoQueryFilterContext.CONTEXT_LIVE : NuxeoQueryFilterContext.CONTEXT_DEFAULT;
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)filter, (String)clause.toString());
        if (CollectionUtils.isNotEmpty(extraPaths)) {
            filteredClause = this.updateClause(basePath, filteredClause, extraPaths);
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ");
        query.append(filteredClause);
        query.append(" ORDER BY ecm:pos");
        operationRequest.set("query", (Object)query.toString());
        StringBuilder navigationSchemas = new StringBuilder();
        navigationSchemas.append(DEFAULT_NAVIGATION_SCHEMAS);
        String extraNavigationSchemas = System.getProperty("nuxeo.navigationSchemas");
        if (StringUtils.isNotBlank((String)extraNavigationSchemas)) {
            navigationSchemas.append(", ");
            navigationSchemas.append(extraNavigationSchemas);
        }
        operationRequest.setHeader("X-NXDocumentProperties", navigationSchemas.toString());
        Documents children = (Documents)operationRequest.execute();
        LinkedHashMap<String, NavigationItem> navigationItems = new LinkedHashMap<String, NavigationItem>(children.size());
        for (Document child : children) {
            String navigationPath;
            String path = child.getPath();
            if (StringUtils.startsWith((String)path, (String)basePath)) {
                navigationPath = path;
            } else {
                Symlink symlink = null;
                if (symlinks != null && CollectionUtils.isNotEmpty((Collection)symlinks.getLinks())) {
                    Iterator iterator = symlinks.getLinks().iterator();
                    while (symlink == null && iterator.hasNext()) {
                        Symlink link = (Symlink)iterator.next();
                        if (!StringUtils.startsWith((String)path, (String)link.getTargetPath())) continue;
                        symlink = link;
                    }
                }
                navigationPath = symlink == null ? basePath + "/_" + StringUtils.substringAfterLast((String)path, (String)"/") : ("Staple".equals(child.getType()) ? VirtualNavigationUtils.adaptPath((String)symlink.getNavigationPath(), (String)((String)child.getProperties().get("ttc:webid"))) : symlink.getNavigationPath() + "/_" + StringUtils.substringAfterLast((String)path, (String)"/"));
            }
            navigationPath = DocumentHelper.computeNavPath((String)navigationPath);
            navigationItem = (NavigationItem)navigationItems.get(navigationPath);
            if (navigationItem == null) {
                navigationItem = new NavigationItem();
                navigationItems.put(navigationPath, navigationItem);
            }
            navigationItem.setMainDoc((Object)child);
            navigationItem.setPath(navigationPath);
        }
        for (Map.Entry entry : navigationItems.entrySet()) {
            String navigationPath = (String)entry.getKey();
            String parentPath = StringUtils.substringBeforeLast((String)navigationPath, (String)"/");
            if (!StringUtils.startsWith((String)navigationPath, (String)basePath)) continue;
            navigationItem = (NavigationItem)entry.getValue();
            NavigationItem parent = (NavigationItem)navigationItems.get(parentPath);
            if (parent == null) continue;
            parent.getChildren().add(navigationItem);
        }
        return navigationItems;
    }

    private String updateClause(String basePath, String clause, Set<String> extraPaths) throws CMSException {
        StringBuilder extendedClause = new StringBuilder();
        boolean first = true;
        for (String extraPath : extraPaths) {
            if (first) {
                first = false;
            } else {
                extendedClause.append(" OR ");
            }
            extendedClause.append("ecm:path STARTSWITH '");
            extendedClause.append(extraPath);
            extendedClause.append("'");
        }
        String filteredExtendedClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)extendedClause.toString());
        StringBuilder updatedFilteredClause = new StringBuilder();
        updatedFilteredClause.append("(");
        updatedFilteredClause.append(clause);
        updatedFilteredClause.append(") OR (");
        updatedFilteredClause.append(filteredExtendedClause);
        updatedFilteredClause.append(")");
        return updatedFilteredClause.toString();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("|");
        builder.append(this.spaceConfig.getCmsPath());
        builder.append("|");
        builder.append(this.live);
        return builder.toString();
    }
}

