/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.service;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.LayoutException;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowComparator;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.core.service.AbstractLayoutManager;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.dev.DevTagHandler;
import org.nuxeo.ecm.platform.forms.layout.functions.LayoutFunctions;
import org.nuxeo.ecm.platform.forms.layout.service.DisabledPropertyRefDescriptor;
import org.nuxeo.ecm.platform.forms.layout.service.DisabledPropertyRefRegistry;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;

public class WebLayoutManagerImpl
extends AbstractLayoutManager
implements WebLayoutManager {
    public static final ComponentName NAME = new ComponentName(WebLayoutManagerImpl.class.getName());
    private static final Log log = LogFactory.getLog(WebLayoutManagerImpl.class);
    private static final long serialVersionUID = 1L;
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String LAYOUT_TYPES_EP_NAME = "layouttypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    public static final String PROPS_REF_EP_NAME = "disabledPropertyRefs";
    protected DisabledPropertyRefRegistry disabledPropertyRefsReg = new DisabledPropertyRefRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.registerWidgetType(((WidgetTypeDescriptor)contribution).getWidgetTypeDefinition());
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            this.registerLayoutType(((LayoutTypeDescriptor)contribution).getLayoutTypeDefinition());
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.registerLayout(((LayoutDescriptor)contribution).getLayoutDefinition());
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.registerWidget(((WidgetDescriptor)contribution).getWidgetDefinition());
        } else if (extensionPoint.equals(PROPS_REF_EP_NAME)) {
            this.registerDisabledPropertyRef((DisabledPropertyRefDescriptor)contribution);
        } else {
            log.error((Object)String.format("Unknown extension point '%s', can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.unregisterWidgetType(((WidgetTypeDescriptor)contribution).getWidgetTypeDefinition());
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            this.unregisterLayoutType(((LayoutTypeDescriptor)contribution).getLayoutTypeDefinition());
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.unregisterLayout(((LayoutDescriptor)contribution).getLayoutDefinition());
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.unregisterWidget(((WidgetDescriptor)contribution).getWidgetDefinition());
        } else if (extensionPoint.equals(PROPS_REF_EP_NAME)) {
            this.unregisterDisabledPropertyRef((DisabledPropertyRefDescriptor)contribution);
        } else {
            log.error((Object)String.format("Unknown extension point '%s', can't unregister !", extensionPoint));
        }
    }

    public String getDefaultStoreCategory() {
        return "jsf";
    }

    protected String getStoreCategory(String cat) {
        if (StringUtils.isBlank((String)cat)) {
            return this.getDefaultStoreCategory();
        }
        return cat;
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(String typeName) throws WidgetException {
        return this.getWidgetTypeHandler(this.getDefaultStoreCategory(), typeName);
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(String typeCategory, String typeName) throws WidgetException {
        WidgetTypeHandler handler;
        WidgetType type;
        if (StringUtils.isBlank((String)typeCategory)) {
            typeCategory = this.getDefaultStoreCategory();
        }
        if ((type = this.getLayoutStore().getWidgetType(typeCategory, typeName)) == null) {
            return null;
        }
        try {
            handler = (WidgetTypeHandler)type.getWidgetTypeClass().newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Caught error when instanciating widget type handler", (Throwable)e);
            return null;
        }
        handler.setProperties(type.getProperties());
        return handler;
    }

    protected static Object evaluateExpression(FaceletContext context, String expression) {
        if (expression == null) {
            return null;
        }
        if (context == null) {
            return expression;
        }
        Object value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)expression);
        if (value != null && value instanceof String) {
            value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)((String)value));
        }
        return value;
    }

    protected static Boolean getBooleanValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        log.error((Object)String.format("Could not get boolean value for '%s' in expression '%s'", value, expression));
        return Boolean.FALSE;
    }

    protected static String getStringValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        log.error((Object)String.format("Could not get string value for '%s' in expression '%s'", value, expression));
        return null;
    }

    protected static String getModeFromLayoutMode(FaceletContext context, WidgetDefinition wDef, String layoutMode) {
        String wMode = WebLayoutManagerImpl.getStringValue(context, wDef.getMode(layoutMode));
        if (wMode == null) {
            wMode = BuiltinModes.getWidgetModeFromLayoutMode((String)layoutMode);
        }
        return wMode;
    }

    @Override
    public Widget getWidget(FaceletContext ctx, String widgetName, String widgetCategory, String layoutMode, String valueName, String layoutName) {
        WidgetReferenceImpl widgetRef = new WidgetReferenceImpl(widgetCategory, widgetName);
        WidgetDefinition wDef = this.lookupWidget((WidgetReference)widgetRef);
        if (wDef != null) {
            return this.getWidget(ctx, layoutName, null, wDef, layoutMode, valueName, 0);
        }
        return null;
    }

    @Override
    public Widget getWidget(FaceletContext ctx, WidgetDefinition wDef, String layoutMode, String valueName, String layoutName) {
        if (wDef != null) {
            return this.getWidget(ctx, layoutName, null, wDef, layoutMode, valueName, 0);
        }
        return null;
    }

    protected Widget getWidget(FaceletContext context, String layoutName, LayoutDefinition layoutDef, WidgetDefinition wDef, String layoutMode, String valueName, int level) {
        WidgetTypeConfiguration conf;
        WidgetReference[] swRefs;
        VariableMapper orig = null;
        if (context != null) {
            orig = context.getVariableMapper();
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            context.setVariableMapper((VariableMapper)vm);
            ExpressionFactory eFactory = context.getExpressionFactory();
            ValueExpression modeVe = eFactory.createValueExpression((Object)layoutMode, String.class);
            vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        }
        String wMode = WebLayoutManagerImpl.getModeFromLayoutMode(context, wDef, layoutMode);
        if (context != null) {
            context.setVariableMapper(orig);
        }
        if ("hidden".equals(wMode)) {
            return null;
        }
        ArrayList<Widget> subWidgets = new ArrayList<Widget>();
        WidgetDefinition[] swDefs = wDef.getSubWidgetDefinitions();
        if (swDefs != null) {
            for (WidgetDefinition swDef : swDefs) {
                Widget subWidget = this.getWidget(context, layoutName, layoutDef, swDef, wMode, valueName, level + 1);
                if (subWidget == null) continue;
                subWidgets.add(subWidget);
            }
        }
        if ((swRefs = wDef.getSubWidgetReferences()) != null) {
            for (WidgetReference swRef : swRefs) {
                WidgetDefinition swDef = this.lookupWidget(layoutDef, swRef);
                if (swDef == null) {
                    log.error((Object)String.format("Widget '%s' not found in layout %s", swRef.getName(), layoutName));
                    continue;
                }
                Widget subWidget = this.getWidget(context, layoutName, layoutDef, swDef, wMode, valueName, level + 1);
                if (subWidget == null) continue;
                subWidgets.add(subWidget);
            }
        }
        boolean required = WebLayoutManagerImpl.getBooleanValue(context, wDef.getRequired(layoutMode, wMode));
        String wType = wDef.getType();
        String wTypeCat = wDef.getTypeCategory();
        HashMap props = new HashMap();
        HashMap controls = new HashMap();
        String actualWTypeCat = this.getStoreCategory(wTypeCat);
        WidgetTypeDefinition def = this.getLayoutStore().getWidgetTypeDefinition(actualWTypeCat, wType);
        WidgetTypeConfiguration widgetTypeConfiguration = conf = def != null ? def.getConfiguration() : null;
        if (conf != null) {
            Map defaultControls;
            Map defaultProps = conf.getDefaultPropertyValues(wMode);
            if (defaultProps != null && !defaultProps.isEmpty()) {
                props.putAll(defaultProps);
            }
            if ((defaultControls = conf.getDefaultControlValues(wMode)) != null && !defaultControls.isEmpty()) {
                controls.putAll(defaultControls);
            }
        }
        props.putAll(wDef.getProperties(layoutMode, wMode));
        controls.putAll(wDef.getControls(layoutMode, wMode));
        WidgetImpl widget = new WidgetImpl(layoutName, wDef.getName(), wMode, wType, valueName, wDef.getFieldDefinitions(), wDef.getLabel(layoutMode), wDef.getHelpLabel(layoutMode), wDef.isTranslated(), wDef.isHandlingLabels(), props, required, subWidgets.toArray(new Widget[0]), level, wDef.getSelectOptions(), LayoutFunctions.computeWidgetDefinitionId((WidgetDefinition)wDef), wDef.getRenderingInfos(layoutMode));
        widget.setControls(controls);
        widget.setTypeCategory(actualWTypeCat);
        if (Framework.isDevModeSet()) {
            widget.setDefinition(wDef);
        }
        return widget;
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName) throws LayoutException {
        return this.getLayout(ctx, layoutName, mode, valueName, null, false);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        return this.getLayout(ctx, layoutName, null, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String layoutCategory, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        LayoutDefinition layoutDef;
        if (StringUtils.isBlank((String)layoutCategory)) {
            layoutCategory = this.getDefaultStoreCategory();
        }
        if ((layoutDef = this.getLayoutStore().getLayoutDefinition(layoutCategory, layoutName)) == null) {
            log.debug((Object)String.format("Layout '%s' not found for category '%s'", layoutName, layoutCategory));
            return null;
        }
        return this.getLayout(ctx, layoutDef, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, LayoutDefinition layoutDef, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        Map lprops;
        if (layoutDef == null) {
            log.debug((Object)"Layout definition is null");
            return null;
        }
        if (ctx == null) {
            log.warn((Object)"Layout creation computed in a null facelet context: expressions found in the layout definition will not be evaluated");
        }
        String layoutName = layoutDef.getName();
        LayoutRowDefinition[] rowsDef = layoutDef.getRows();
        ArrayList<LayoutRowImpl> rows = new ArrayList<LayoutRowImpl>();
        HashSet<String> foundRowNames = new HashSet<String>();
        int rowIndex = -1;
        for (LayoutRowDefinition rowDef : rowsDef) {
            ++rowIndex;
            String rowName = rowDef.getName();
            if (rowName == null) {
                rowName = rowDef.getDefaultName(rowIndex);
                if (selectedRows != null) {
                    log.debug((Object)String.format("Generating default name '%s' in layout '%s' for row or column at index %s", rowName, layoutName, rowIndex));
                }
            }
            boolean emptyRow = true;
            if (selectedRows != null && !selectedRows.contains(rowName) && !rowDef.isAlwaysSelected() || selectedRows == null && !selectAllRowsByDefault && !rowDef.isSelectedByDefault() && !rowDef.isAlwaysSelected()) continue;
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            for (WidgetReference widgetRef : rowDef.getWidgetReferences()) {
                String widgetName = widgetRef.getName();
                if (widgetName == null || widgetName.length() == 0) {
                    widgets.add(null);
                    continue;
                }
                WidgetDefinition wDef = this.lookupWidget(layoutDef, widgetRef);
                if (wDef == null) {
                    log.error((Object)String.format("Widget '%s' not found in layout %s", widgetName, layoutName));
                    widgets.add(null);
                    continue;
                }
                Widget widget = this.getWidget(ctx, layoutName, layoutDef, wDef, mode, valueName, 0);
                if (widget != null) {
                    emptyRow = false;
                }
                widgets.add(widget);
            }
            if (!emptyRow) {
                rows.add(new LayoutRowImpl(rowName, rowDef.isSelectedByDefault(), rowDef.isAlwaysSelected(), widgets, rowDef.getProperties(mode), LayoutFunctions.computeLayoutRowDefinitionId((LayoutRowDefinition)rowDef)));
            }
            foundRowNames.add(rowName);
        }
        if (selectedRows != null) {
            Collections.sort(rows, new LayoutRowComparator(selectedRows));
            for (String selectedRow : selectedRows) {
                if (foundRowNames.contains(selectedRow)) continue;
                log.debug((Object)String.format("Selected row or column named '%s' was not found in layout '%s'", selectedRow, layoutName));
            }
        }
        String layoutTypeCategory = layoutDef.getTypeCategory();
        String actualLayoutTypeCategory = this.getStoreCategory(layoutTypeCategory);
        LayoutTypeDefinition layoutTypeDef = null;
        String layoutType = layoutDef.getType();
        if (!StringUtils.isBlank((String)layoutType) && (layoutTypeDef = this.getLayoutStore().getLayoutTypeDefinition(actualLayoutTypeCategory, layoutType)) == null) {
            log.debug((Object)String.format("Layout type '%s' not found for category '%s'", layoutType, layoutTypeCategory));
        }
        String template = layoutDef.getTemplate(mode);
        HashMap props = new HashMap();
        if (layoutTypeDef != null) {
            Map typeProps;
            LayoutTypeConfiguration conf;
            if (StringUtils.isEmpty((String)template)) {
                template = layoutTypeDef.getTemplate(mode);
            }
            if ((conf = layoutTypeDef.getConfiguration()) != null && (typeProps = conf.getDefaultPropertyValues(mode)) != null) {
                props.putAll(typeProps);
            }
        }
        if ((lprops = layoutDef.getProperties(mode)) != null) {
            props.putAll(lprops);
        }
        LayoutImpl layout = new LayoutImpl(layoutDef.getName(), mode, template, rows, layoutDef.getColumns(), props, LayoutFunctions.computeLayoutDefinitionId((LayoutDefinition)layoutDef));
        layout.setValueName(valueName);
        layout.setType(layoutType);
        layout.setTypeCategory(actualLayoutTypeCategory);
        if (Framework.isDevModeSet()) {
            String devTemplate;
            layout.setDefinition(layoutDef);
            Map templates = layoutDef.getTemplates();
            String string = devTemplate = templates != null ? (String)templates.get("dev") : null;
            if (layoutTypeDef != null && StringUtils.isEmpty((String)devTemplate)) {
                Map typeTemplates = layoutTypeDef.getTemplates();
                devTemplate = typeTemplates != null ? (String)typeTemplates.get("dev") : null;
            }
            layout.setDevTemplate(devTemplate);
        }
        return layout;
    }

    protected WidgetDefinition lookupWidget(LayoutDefinition layoutDef, WidgetReference widgetRef) {
        String widgetName = widgetRef.getName();
        WidgetDefinition wDef = null;
        if (layoutDef != null) {
            wDef = layoutDef.getWidgetDefinition(widgetName);
        }
        if (wDef == null) {
            wDef = this.lookupWidget(widgetRef);
        }
        return wDef;
    }

    protected WidgetDefinition lookupWidget(WidgetReference widgetRef) {
        String widgetName = widgetRef.getName();
        String cat = widgetRef.getCategory();
        WidgetDefinition wDef = StringUtils.isBlank((String)cat) ? this.getWidgetDefinition(widgetName) : this.getLayoutStore().getWidgetDefinition(cat, widgetName);
        if (wDef != null) {
            wDef.setGlobal(true);
        }
        return wDef;
    }

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig config, Widget widget) {
        return this.getFaceletHandler(ctx, config, widget, null);
    }

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig config, Widget widget, FaceletHandler nextHandler) {
        String widgetTypeName = widget.getType();
        String widgetTypeCategory = widget.getTypeCategory();
        WidgetTypeHandler handler = this.getWidgetTypeHandler(widgetTypeCategory, widgetTypeName);
        if (handler == null) {
            FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, config);
            String message = String.format("No widget handler found for type '%s' in category '%s'", widgetTypeName, widgetTypeCategory);
            log.error((Object)message);
            ComponentHandler output = helper.getErrorComponentHandler(null, message);
            return output;
        }
        FaceletHandler[] subHandlers = null;
        Widget[] subWidgets = widget.getSubWidgets();
        ArrayList<FaceletHandler> subHandlersList = new ArrayList<FaceletHandler>();
        if (nextHandler != null) {
            subHandlersList.add(nextHandler);
        }
        if (subWidgets != null) {
            for (Widget subWidget : subWidgets) {
                FaceletHandler h = this.getFaceletHandler(ctx, config, subWidget, null);
                if (h == null) continue;
                subHandlersList.add(h);
            }
        }
        if (!subHandlersList.isEmpty()) {
            subHandlers = subHandlersList.toArray(new FaceletHandler[0]);
        }
        FaceletHandler widgetHandler = handler.getFaceletHandler(ctx, config, widget, subHandlers);
        if (FaceletHandlerHelper.isDevModeEnabled(ctx)) {
            FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, config);
            FaceletHandler devHandler = handler.getDevFaceletHandler(ctx, config, widget);
            if (devHandler == null) {
                return widgetHandler;
            }
            String widgetTagConfigId = widget.getTagConfigId();
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression widgetVe = eFactory.createValueExpression((Object)widget, Widget.class);
            variables.put(RenderVariables.widgetVariables.widget.name(), widgetVe);
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name() + "*");
            FaceletHandler devAliasHandler = helper.getAliasTagHandler(widgetTagConfigId, variables, blockedPatterns, devHandler);
            String refId = widget.getName();
            DevTagHandler widgetDevHandler = new DevTagHandler(config, refId, widgetHandler, devAliasHandler);
            return widgetDevHandler;
        }
        return widgetHandler;
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, Map<String, Serializable> properties, Widget[] subWidgets) {
        return this.createWidget(ctx, type, mode, valueName, null, null, null, null, properties, subWidgets);
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, List<FieldDefinition> fieldDefinitions, String label, String helpLabel, Boolean translated, Map<String, Serializable> properties, Widget[] subWidgets) {
        return this.createWidget(ctx, this.createWidgetDefinition(ctx, type, null, mode, valueName, fieldDefinitions, null, label, helpLabel, translated, properties, subWidgets), mode, valueName, subWidgets);
    }

    @Override
    public Widget createWidget(FaceletContext ctx, WidgetDefinition wDef, String mode, String valueName, Widget[] subWidgets) {
        Map modeControls;
        Map modeProps;
        WidgetTypeConfiguration conf;
        String wType = wDef.getType();
        String wTypeCat = wDef.getTypeCategory();
        HashMap props = new HashMap();
        HashMap controls = new HashMap();
        String actualWTypeCat = this.getStoreCategory(wTypeCat);
        WidgetTypeDefinition def = this.getLayoutStore().getWidgetTypeDefinition(actualWTypeCat, wType);
        boolean required = false;
        WidgetTypeConfiguration widgetTypeConfiguration = conf = def != null ? def.getConfiguration() : null;
        if (conf != null) {
            Map defaultControls;
            Map defaultProps = conf.getDefaultPropertyValues(mode);
            if (defaultProps != null && !defaultProps.isEmpty()) {
                props.putAll(defaultProps);
            }
            if ((defaultControls = conf.getDefaultControlValues(mode)) != null && !defaultControls.isEmpty()) {
                controls.putAll(defaultControls);
            }
        }
        if ((modeProps = wDef.getProperties(mode, mode)) != null) {
            props.putAll(modeProps);
            Serializable requiredProp = (Serializable)props.get("required");
            if (requiredProp != null) {
                if (requiredProp instanceof Boolean) {
                    required = (Boolean)requiredProp;
                } else if (requiredProp instanceof String) {
                    required = WebLayoutManagerImpl.getBooleanValue(ctx, (String)((Object)requiredProp));
                } else {
                    log.error((Object)String.format("Invalid property '%s' on widget: '%s'", "required", requiredProp));
                }
            }
        }
        if ((modeControls = wDef.getControls(mode, mode)) != null) {
            controls.putAll(modeControls);
        }
        WidgetImpl widget = new WidgetImpl("layout", wDef.getName(), mode, wType, valueName, wDef.getFieldDefinitions(), wDef.getLabel(mode), wDef.getHelpLabel(mode), wDef.isTranslated(), props, required, subWidgets, 0, null, LayoutFunctions.computeWidgetDefinitionId((WidgetDefinition)wDef));
        widget.setControls(controls);
        widget.setTypeCategory(actualWTypeCat);
        widget.setDynamic(wDef.isDynamic());
        widget.setGlobal(wDef.isGlobal());
        if (Framework.isDevModeSet()) {
            widget.setDefinition(wDef);
        }
        return widget;
    }

    protected WidgetDefinition createWidgetDefinition(FaceletContext ctx, String type, String category, String mode, String valueName, List<FieldDefinition> fieldDefinitions, String widgetName, String label, String helpLabel, Boolean translated, Map<String, Serializable> properties, Widget[] subWidgets) {
        String wName = widgetName;
        if (StringUtils.isBlank((String)widgetName)) {
            wName = type;
        }
        WidgetDefinitionImpl wDef = new WidgetDefinitionImpl(wName, type, label, helpLabel, Boolean.TRUE.equals(translated), null, fieldDefinitions, properties, null);
        wDef.setDynamic(true);
        return wDef;
    }

    protected void registerDisabledPropertyRef(DisabledPropertyRefDescriptor desc) {
        this.disabledPropertyRefsReg.addContribution(desc);
        log.info((Object)String.format("Registered disabled property reference descriptor: %s", desc.toString()));
    }

    protected void unregisterDisabledPropertyRef(DisabledPropertyRefDescriptor desc) {
        this.disabledPropertyRefsReg.removeContribution(desc);
        log.info((Object)String.format("Removed disabled property reference descriptor: %s", desc.toString()));
    }

    @Override
    public boolean referencePropertyAsExpression(String name, Serializable value, String widgetType, String widgetMode, String template) {
        return this.referencePropertyAsExpression(name, value, widgetType, null, widgetMode, template);
    }

    @Override
    public boolean referencePropertyAsExpression(String name, Serializable value, String widgetType, String widgetTypeCategory, String widgetMode, String template) {
        if (value instanceof String && ComponentTagUtils.isValueReference((String)((String)((Object)value)))) {
            return false;
        }
        String cat = widgetTypeCategory;
        if (widgetTypeCategory == null) {
            cat = "jsf";
        }
        for (DisabledPropertyRefDescriptor desc : this.disabledPropertyRefsReg.getDisabledPropertyRefs()) {
            if (!Boolean.TRUE.equals(desc.getEnabled()) || !desc.matches(name, widgetType, cat, widgetMode, template)) continue;
            return false;
        }
        return true;
    }
}

