/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;
import org.osivia.procedures.instances.operations.AbstractProcedureUnrestrictedSessionRunner;

public class StartProcedureUnrestrictedSessionRunner
extends AbstractProcedureUnrestrictedSessionRunner {
    private DocumentModel procedureInstance;
    private final String procedureInitiator;
    private final String title;
    private final Properties properties;
    private final StringList actors;
    private final StringList additionalAuthorizations;
    private final BlobList blobList;
    private final DocumentRoutingService documentRoutingService;

    public StartProcedureUnrestrictedSessionRunner(CoreSession session, String procedureInitiator, String title, Properties properties, StringList actors, StringList additionalAuthorizations, BlobList blobList) {
        super(session, properties);
        this.procedureInitiator = procedureInitiator;
        this.title = title;
        this.properties = properties;
        this.actors = actors;
        this.additionalAuthorizations = additionalAuthorizations;
        this.blobList = blobList;
        this.documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
    }

    public void run() throws ClientException {
        DocumentModel genericModel = this.getGenericModel();
        DocumentModel model = this.getModel();
        this.procedureInstance = this.createProcedureInstance(model);
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add(this.procedureInstance.getId());
        this.addAttachments(this.procedureInstance);
        this.associateObject(this.procedureInstance, identifiers);
        String processId = this.documentRoutingService.createNewInstance(genericModel.getName(), identifiers, this.session, true);
        this.createTask(model, this.procedureInstance, processId, this.title, this.actors, this.additionalAuthorizations);
    }

    private DocumentModel getGenericModel() {
        String id = this.documentRoutingService.getRouteModelDocIdWithId(this.session, "generic-model");
        IdRef ref = new IdRef(id);
        return this.session.getDocument((DocumentRef)ref);
    }

    private DocumentModel createProcedureInstance(DocumentModel model) {
        DocumentModel procedureInstanceContainer = this.getProcedureInstanceContainer(model);
        String parentPath = procedureInstanceContainer.getPathAsString();
        DocumentModel procedureInstanceModel = this.session.createDocumentModel(parentPath, model.getName(), "ProcedureInstance");
        DocumentModel procedureInstance = this.session.createDocument(procedureInstanceModel);
        this.properties.put((Object)"pi:procedureInitiator", (Object)this.procedureInitiator);
        try {
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)procedureInstance, (Properties)this.properties);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        return this.session.saveDocument(procedureInstance);
    }

    private DocumentModel getProcedureInstanceContainer(DocumentModel model) {
        Path modelPath = model.getPath();
        Path containerPath = modelPath.uptoSegment(modelPath.segmentCount() - 2);
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ecm:primaryType = 'ProceduresInstancesContainer' ");
        query.append("AND ecm:path STARTSWITH '").append(containerPath.toString()).append("' ");
        DocumentModelList result = this.session.query(query.toString());
        if (result.size() != 1) {
            throw new ClientException("Procedure instance container not found.");
        }
        DocumentModel procedureInstanceContainer = (DocumentModel)result.get(0);
        return procedureInstanceContainer;
    }

    private void addAttachments(DocumentModel procedureInstance) {
        List attachments;
        if (this.blobList != null && CollectionUtils.isNotEmpty((Collection)(attachments = (List)procedureInstance.getProperty("pi:attachments").getValue(List.class)))) {
            int i = 0;
            for (Object attachment : attachments) {
                Map map = (Map)attachment;
                Object blobObject = map.get("blob");
                if (blobObject == null) {
                    Property property = procedureInstance.getProperty("pi:attachments/" + i + "/blob");
                    String fileName = (String)map.get("fileName");
                    Blob currentBlob = null;
                    for (Blob blob : this.blobList) {
                        if (!StringUtils.equals((String)blob.getFilename(), (String)fileName)) continue;
                        currentBlob = blob;
                    }
                    DocumentHelper.addBlob((Property)property, currentBlob);
                }
                ++i;
            }
            this.session.saveDocument(procedureInstance);
        }
    }

    private void associateObject(DocumentModel procedureInstance, List<String> identifiers) {
        List procedureObjectInstancesList = (List)procedureInstance.getProperty("pi:procedureObjectInstances").getValue(List.class);
        if (CollectionUtils.isNotEmpty((Collection)procedureObjectInstancesList)) {
            for (Object procedureObjectInstances : procedureObjectInstancesList) {
                Map procedureObjectInstancesMap = (Map)procedureObjectInstances;
                String procedureObjectId = (String)procedureObjectInstancesMap.get("procedureObjectId");
                if (procedureObjectId == null) continue;
                identifiers.add(procedureObjectId);
            }
        }
    }

    public DocumentModel getProcedureInstance() {
        return this.procedureInstance;
    }
}

