/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.standalone.CommandsTask;

public class InstallTask
extends CommandsTask {
    public InstallTask(PackageUpdateService pus) {
        super(pus);
    }

    @Override
    public boolean isInstallTask() {
        return true;
    }

    @Override
    protected File getCommandsFile() throws PackageException {
        return this.pkg.getInstallFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun(Map<String, String> params) throws PackageException {
        try {
            super.doRun(params);
        }
        finally {
            File file = this.pkg.getData().getEntry("uninstall.xml");
            this.writeLog(file);
        }
    }

    @Override
    protected void rollbackDone() throws PackageException {
        this.service.setPackageState(this.pkg, PackageState.DOWNLOADED);
    }

    @Override
    protected void taskDone() throws PackageException {
        this.service.setPackageState(this.pkg, PackageState.STARTED);
    }

    @Override
    protected void flush() throws PackageException {
    }
}

