/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.api.SharedResourceLoader;
import org.nuxeo.runtime.api.login.LoginAs;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.trackers.files.FileEvent;

public final class Framework {
    private static final Log log = LogFactory.getLog(Framework.class);
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String NUXEO_TESTING_SYSTEM_PROP = "org.nuxeo.runtime.testing";
    public static final String NUXEO_STRICT_RUNTIME_SYSTEM_PROP = "org.nuxeo.runtime.strict";
    private static RuntimeService runtime;
    private static final ListenerList listeners;
    protected static SharedResourceLoader resourceLoader;
    protected static Boolean isOSGiServiceSupported;

    private Framework() {
    }

    public static void initialize(RuntimeService runtimeService) throws Exception {
        if (runtime != null) {
            throw new Exception("Nuxeo Framework was already initialized");
        }
        runtime = runtimeService;
        Framework.reloadResourceLoader();
        runtime.start();
    }

    public static void reloadResourceLoader() throws Exception {
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        resourceLoader = new SharedResourceLoader(new URL[]{rs.toURI().toURL()}, Framework.class.getClassLoader());
    }

    public static void reloadResourceLoader(List<URL> urlsToAdd, List<URL> urlsToRemove) throws MalformedURLException {
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        URL[] existing = null;
        if (resourceLoader != null) {
            existing = resourceLoader.getURLs();
        }
        resourceLoader = new SharedResourceLoader(new URL[]{rs.toURI().toURL()}, Framework.class.getClassLoader());
        if (existing != null) {
            for (URL oldURL : existing) {
                if (urlsToRemove != null && urlsToRemove.contains(oldURL)) continue;
                resourceLoader.addURL(oldURL);
            }
        }
        if (urlsToAdd != null) {
            for (URL newURL : urlsToAdd) {
                resourceLoader.addURL(newURL);
            }
        }
    }

    public static void shutdown() throws Exception {
        if (runtime != null) {
            runtime.stop();
            runtime = null;
        }
    }

    public static synchronized boolean isInitialized() {
        return runtime != null;
    }

    public static SharedResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static RuntimeService getRuntime() {
        return runtime;
    }

    public static <T> T getService(Class<T> serviceClass) {
        ServiceProvider provider = DefaultServiceProvider.getProvider();
        if (provider != null) {
            return provider.getService(serviceClass);
        }
        Framework.checkRuntimeInitialized();
        return runtime.getService(serviceClass);
    }

    public static <T> T getLocalService(Class<T> serviceClass) {
        return Framework.getService(serviceClass);
    }

    public static Object lookup(String key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPrivileged(Runnable runnable) {
        try {
            LoginContext loginContext = Framework.login();
            try {
                runnable.run();
            }
            finally {
                if (loginContext != null) {
                    loginContext.logout();
                }
            }
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    public static LoginContext login() throws LoginException {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login();
        }
        return null;
    }

    public static LoginContext loginAs(String username) throws LoginException {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.loginAs(username);
        }
        return null;
    }

    public static LoginContext loginAsUser(String username) throws LoginException {
        return Framework.getLocalService(LoginAs.class).loginAs(username);
    }

    public static LoginContext login(String username, Object password) throws LoginException {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(username, password);
        }
        return null;
    }

    public static LoginContext login(CallbackHandler cbHandler) throws LoginException {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(cbHandler);
        }
        return null;
    }

    public static void sendEvent(RuntimeServiceEvent event) {
        Object[] listenersArray;
        for (Object listener : listenersArray = listeners.getListeners()) {
            ((RuntimeServiceListener)listener).handleEvent(event);
        }
    }

    public static void addListener(RuntimeServiceListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(RuntimeServiceListener listener) {
        listeners.remove((Object)listener);
    }

    public static String getProperty(String key) {
        return Framework.getProperty(key, null);
    }

    public static String getProperty(String key, String defValue) {
        Framework.checkRuntimeInitialized();
        return runtime.getProperty(key, defValue);
    }

    public static Properties getProperties() {
        Framework.checkRuntimeInitialized();
        return runtime.getProperties();
    }

    public static String expandVars(String expression) {
        Framework.checkRuntimeInitialized();
        return runtime.expandVars(expression);
    }

    public static boolean isOSGiServiceSupported() {
        if (isOSGiServiceSupported == null) {
            isOSGiServiceSupported = Framework.isBooleanPropertyTrue("ecr.osgi.services");
        }
        return isOSGiServiceSupported;
    }

    public static boolean isDevModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_DEV_SYSTEM_PROP);
    }

    public static boolean isTestModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_TESTING_SYSTEM_PROP);
    }

    public static boolean isBooleanPropertyFalse(String propName) {
        String v = Framework.getProperty(propName);
        if (v == null) {
            v = System.getProperty(propName);
        }
        if (StringUtils.isBlank((String)v)) {
            return false;
        }
        return !Boolean.parseBoolean(v);
    }

    public static boolean isBooleanPropertyTrue(String propName) {
        String v = Framework.getProperty(propName);
        if (v == null) {
            v = System.getProperty(propName);
        }
        return Boolean.parseBoolean(v);
    }

    public static void handleDevError(Throwable t) {
        if (Framework.isBooleanPropertyTrue(NUXEO_STRICT_RUNTIME_SYSTEM_PROP)) {
            System.err.println("Fatal error caught in strict runtime mode => exiting.");
            t.printStackTrace();
            System.exit(1);
        } else {
            log.error((Object)t, t);
        }
    }

    public static void trackFile(File aFile, Object aMarker) {
        FileEvent.onFile(Framework.class, aFile, aMarker).send();
    }

    @Deprecated
    public static void trackFile(File file, Object marker, FileDeleteStrategy fileDeleteStrategy) {
        Framework.trackFile(file, marker);
    }

    protected static void checkRuntimeInitialized() {
        if (runtime == null) {
            throw new IllegalStateException("Runtime not initialized");
        }
    }

    public static void main(String[] args) {
    }

    static {
        listeners = new ListenerList();
    }
}

