/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.LambdaAdaptor;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.model.ComponentManager;

public class ServicePassivator {
    public static Passivator passivate() {
        return new Passivator();
    }

    public static Termination proceed(long quiet, long timeout, boolean enforce, Runnable runnable) {
        return ServicePassivator.passivate().withQuietDelay(quiet).monitor().withTimeout(timeout).withEnforceMode(enforce).await().proceed(runnable);
    }

    public static <X extends Exception> void proceed(long quiet, long timeout, boolean enforce, final LambdaAdaptor.RunnableCheckException<X> runnable, Class<X> oftype) throws X {
        class CheckExceptionHolder
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            CheckExceptionHolder(Throwable cause) {
                super(cause);
            }

            void rethrow(Class<X> oftype) throws Exception {
                if (this.getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw (Exception)oftype.cast(this.getCause());
            }
        }
        try {
            ServicePassivator.passivate().withQuietDelay(quiet).monitor().withTimeout(timeout).withEnforceMode(enforce).await().proceed(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception cause) {
                        throw new CheckExceptionHolder(cause);
                    }
                }
            });
        }
        catch (CheckExceptionHolder cause) {
            cause.rethrow(oftype);
        }
    }

    static class WaitForProvider
    implements ServiceProvider {
        final CountDownLatch condition;
        final ServiceProvider passthrough;

        WaitForProvider(CountDownLatch condition, ServiceProvider passthrough) {
            this.condition = condition;
            this.passthrough = passthrough;
        }

        @Override
        public <T> T getService(Class<T> serviceClass) {
            try {
                this.condition.await();
            }
            catch (InterruptedException error) {
                Thread.currentThread().interrupt();
                throw new AssertionError((Object)("Interrupted while waiting for " + serviceClass));
            }
            return this.passthrough.getService(serviceClass);
        }
    }

    static class RuntimeProvider
    implements ServiceProvider {
        RuntimeProvider() {
        }

        @Override
        public <T> T getService(Class<T> serviceClass) {
            return Framework.getRuntime().getService(serviceClass);
        }
    }

    static class DelegateProvider
    implements ServiceProvider {
        final ServiceProvider next;

        DelegateProvider(ServiceProvider provider) {
            this.next = provider;
        }

        @Override
        public <T> T getService(Class<T> serviceClass) {
            return this.next.getService(serviceClass);
        }
    }

    static class PassivateProvider
    implements ServiceProvider {
        final Thread ownerThread;
        final Passivator.Accounting accounting;
        final ServiceProvider passthrough;
        final ServiceProvider waitfor;

        PassivateProvider(Thread ownerThread, Passivator.Accounting accounting, ServiceProvider waitfor, ServiceProvider passthrough) {
            this.ownerThread = ownerThread;
            this.accounting = accounting;
            this.waitfor = waitfor;
            this.passthrough = passthrough;
        }

        @Override
        public <T> T getService(Class<T> typeof) {
            if (Thread.currentThread() == this.ownerThread) {
                return this.passthrough.getService(typeof);
            }
            return this.accounting.take(typeof).map(new LambdaAdaptor.Function<Passivator.Accounting.InScopeOfContext, ServiceProvider>(){

                @Override
                public ServiceProvider apply(Passivator.Accounting.InScopeOfContext value) {
                    return PassivateProvider.this.passthrough;
                }
            }).orElse(this.waitfor).getService(typeof);
        }
    }

    public static interface Termination {
        public Termination onSuccess(Runnable var1);

        public Termination onFailure(LambdaAdaptor.Consumer<Passivator.Accounting.InScopeOfContext> var1);

        public Termination peek(LambdaAdaptor.Consumer<Termination> var1);

        public static class Failure
        implements Termination {
            final Passivator.Accounting.InScopeOfContext snapshot;

            Failure(Passivator.Accounting.InScopeOfContext snapshot) {
                this.snapshot = snapshot;
            }

            @Override
            public Termination onSuccess(Runnable finisher) {
                return this;
            }

            @Override
            public Termination onFailure(LambdaAdaptor.Consumer<Passivator.Accounting.InScopeOfContext> recoverer) {
                recoverer.accept(this.snapshot);
                return this;
            }

            @Override
            public Termination peek(LambdaAdaptor.Consumer<Termination> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static class Success
        implements Termination {
            @Override
            public Termination onSuccess(Runnable finisher) {
                finisher.run();
                return this;
            }

            @Override
            public Termination onFailure(LambdaAdaptor.Consumer<Passivator.Accounting.InScopeOfContext> recoverer) {
                return this;
            }

            @Override
            public Termination peek(LambdaAdaptor.Consumer<Termination> consumer) {
                consumer.accept(this);
                return this;
            }
        }
    }

    public static class Waiter {
        final Monitor monitor;
        final long timeout;
        final boolean enforce;

        Waiter(Monitor monitor, long timeout, boolean enforce) {
            this.monitor = monitor;
            this.timeout = timeout;
            this.enforce = enforce;
        }

        public Waiter peek(LambdaAdaptor.Consumer<Waiter> consumer) {
            consumer.accept(this);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Termination proceed(Runnable runnable) {
            try {
                this.monitor.passivator.log.debug((Object)("waiting " + this.timeout + "s for passivation"));
                boolean passivated = this.monitor.passivated.await(this.timeout, TimeUnit.SECONDS);
                if (!this.enforce || passivated) {
                    this.monitor.passivator.log.debug((Object)"proceeding");
                    ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                    try {
                        runnable.run();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tcl);
                    }
                }
                Termination termination = this.monitor.passivator.accounting.last.map(new LambdaAdaptor.Function<Passivator.Accounting.InScopeOfContext, Termination>(){

                    @Override
                    public Termination apply(Passivator.Accounting.InScopeOfContext context) {
                        return new Termination.Failure(context);
                    }
                }).orElseGet(new LambdaAdaptor.Supplier<Termination>(){

                    @Override
                    public Termination get() {
                        return new Termination.Success();
                    }
                });
                return termination;
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Interrupted while waiting for passivation", cause);
            }
            finally {
                this.monitor.cancel();
            }
        }
    }

    public static class Monitor {
        final Passivator passivator;
        final CountDownLatch passivated = new CountDownLatch(1);
        final long quietDelay;
        final Timer timer = new Timer(ServicePassivator.class.getSimpleName().toLowerCase());
        final TimerTask scheduledTask = new TimerTask(){

            @Override
            public void run() {
                LambdaAdaptor.Optional<Passivator.Accounting.InScopeOfContext> observed = Monitor.this.passivator.accounting.reset();
                if (observed.isPresent()) {
                    return;
                }
                this.cancel();
                Monitor.this.passivated.countDown();
            }
        };
        long timeout = 30L;
        boolean enforce = true;

        Monitor(Passivator passivator, long quietDelay) {
            this.passivator = passivator;
            this.quietDelay = quietDelay;
            this.run();
        }

        void run() {
            long delay = TimeUnit.MILLISECONDS.convert(this.quietDelay, TimeUnit.SECONDS);
            if (delay <= 0L) {
                this.passivated.countDown();
                return;
            }
            this.timer.scheduleAtFixedRate(this.scheduledTask, delay, delay);
            this.passivator.log.debug((Object)"monitoring accesses");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            try {
                this.timer.cancel();
            }
            finally {
                this.passivator.commit();
            }
        }

        public Monitor withTimeout(long value) {
            this.timeout = value;
            return this;
        }

        public Monitor withEnforceMode(boolean value) {
            this.enforce = value;
            return this;
        }

        public Monitor peek(LambdaAdaptor.Consumer<Monitor> consumer) {
            consumer.accept(this);
            return this;
        }

        public Waiter await() {
            return new Waiter(this, this.timeout, this.enforce);
        }
    }

    public static class Passivator {
        final Log log = LogFactory.getLog(ServicePassivator.class);
        final CountDownLatch achieved = new CountDownLatch(1);
        final Accounting accounting = new Accounting();
        LambdaAdaptor.Optional<ServiceProvider> installed = LambdaAdaptor.Optional.empty();
        long quietDelay = 5L;

        Passivator() {
            this.run();
        }

        void run() {
            this.installed = LambdaAdaptor.Optional.ofNullable(DefaultServiceProvider.getProvider());
            ServiceProvider passthrough = this.installed.map(new LambdaAdaptor.Function<ServiceProvider, ServiceProvider>(){

                @Override
                public ServiceProvider apply(ServiceProvider t) {
                    return new DelegateProvider(t);
                }
            }).orElseGet(new LambdaAdaptor.Supplier<ServiceProvider>(){

                @Override
                public ServiceProvider get() {
                    return new RuntimeProvider();
                }
            });
            WaitForProvider waitfor = new WaitForProvider(this.achieved, passthrough);
            PassivateProvider passivator = new PassivateProvider(Thread.currentThread(), this.accounting, waitfor, passthrough);
            DefaultServiceProvider.setProvider(passivator);
            this.log.debug((Object)"installed passivator", this.log.isTraceEnabled() ? new Throwable("stack trace") : null);
        }

        void resetProvider() {
            PassivateProvider passivator = (PassivateProvider)DefaultServiceProvider.getProvider();
            ServiceProvider previous = passivator.passthrough instanceof DelegateProvider ? ((DelegateProvider)passivator.passthrough).next : null;
            DefaultServiceProvider.setProvider(previous);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit() {
            try {
                DefaultServiceProvider.setProvider(this.installed.orElse(null));
            }
            finally {
                this.achieved.countDown();
                this.log.debug((Object)"uninstalled passivator");
            }
        }

        public Passivator withQuietDelay(long delay) {
            this.quietDelay = delay;
            return this;
        }

        public Passivator peek(LambdaAdaptor.Consumer<Passivator> consumer) {
            consumer.accept(this);
            return this;
        }

        public Monitor monitor() {
            return new Monitor(this, this.quietDelay);
        }

        public class Accounting {
            volatile LambdaAdaptor.Optional<InScopeOfContext> last = LambdaAdaptor.Optional.empty();
            final CallstackDumper dumper = new CallstackDumper();

            LambdaAdaptor.Optional<InScopeOfContext> take(Class<?> serviceof) {
                final Class[] callstack = this.dumper.dump();
                LambdaAdaptor.Optional<InScopeOfContext> snapshot = this.inscopeof(callstack).map(new LambdaAdaptor.Function<Class<?>, InScopeOfContext>(){

                    @Override
                    public InScopeOfContext apply(Class<?> inscopeof) {
                        return new InScopeOfContext(inscopeof, Thread.currentThread(), callstack);
                    }
                });
                snapshot.ifPresent(new LambdaAdaptor.Consumer<InScopeOfContext>(){

                    @Override
                    public void accept(InScopeOfContext context) {
                        Accounting.this.register(context);
                    }
                });
                return snapshot;
            }

            void register(InScopeOfContext context) {
                this.last = LambdaAdaptor.Optional.of(context);
            }

            public LambdaAdaptor.Optional<InScopeOfContext> get() {
                return this.last;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            LambdaAdaptor.Optional<InScopeOfContext> reset() {
                try {
                    LambdaAdaptor.Optional<InScopeOfContext> optional = this.last;
                    return optional;
                }
                finally {
                    this.last = LambdaAdaptor.Optional.empty();
                }
            }

            LambdaAdaptor.Optional<Class<?>> inscopeof(Class<?>[] callstack) {
                ComponentManager cm = Framework.getRuntime().getComponentManager();
                if (cm != null) {
                    for (Class<?> typeof : callstack) {
                        if (cm.getComponentProvidingService(typeof) == null) continue;
                        return LambdaAdaptor.Optional.of(typeof);
                    }
                }
                return LambdaAdaptor.Optional.empty();
            }

            class CallstackDumper
            extends SecurityManager {
                CallstackDumper() {
                }

                Class<?>[] dump() {
                    return super.getClassContext();
                }
            }

            public class InScopeOfContext {
                final Class<?> serviceof;
                final Thread thread;
                final Class<?>[] callstack;

                InScopeOfContext(Class<?> serviceof, Thread thread, Class<?>[] callstack) {
                    this.serviceof = serviceof;
                    this.thread = thread;
                    this.callstack = callstack;
                }

                public String toString() {
                    StringBuilder builder = new StringBuilder().append("on ").append(this.thread).append(" in scope of ").append(this.serviceof).append(System.lineSeparator());
                    for (Class<?> typeof : this.callstack) {
                        builder = builder.append("  ").append(typeof).append(System.lineSeparator());
                    }
                    return builder.toString();
                }
            }
        }
    }
}

