/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import it.tidalwave.image.metadata.DrewEXIFLoader;
import it.tidalwave.image.metadata.EXIFDirectoryGenerated;
import it.tidalwave.image.metadata.EXIFLoader;
import it.tidalwave.image.metadata.RAWEXIFLoader;
import it.tidalwave.image.metadata.TIFFEXIFLoader;
import java.awt.color.ICC_Profile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

public class EXIFDirectory
extends EXIFDirectoryGenerated {
    private static final long serialVersionUID = 3088068666726854749L;
    private static final String CLASS = EXIFDirectory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final SimpleDateFormat EXIF_DATE_PARSER = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static final SimpleDateFormat EXIF_DATE_PARSER2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void loadEXIF(IIOMetadata iioMetadata) {
        Object node;
        EXIFLoader exifLoader = null;
        exifLoader = this.isSubClass(iioMetadata.getClass(), "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata") ? new TIFFEXIFLoader() : (this.isSubClass(iioMetadata.getClass(), "it.tidalwave.imageio.raw.RAWMetadataSupport") ? new RAWEXIFLoader() : new DrewEXIFLoader());
        if (exifLoader != null && (node = ((EXIFLoader)exifLoader).findEXIFNode(iioMetadata)) != null) {
            this.load(node);
        }
    }

    public byte[] getUserComment() {
        try {
            return super.getUserComment();
        }
        catch (Exception e) {
            int i = this.strategy.getInteger(37510);
            return ("" + i).getBytes();
        }
    }

    public ICC_Profile getICCProfile() {
        byte[] iccBytes = this.getInterColourProfile();
        if (iccBytes == null) {
            throw new NoSuchElementException("34675");
        }
        return ICC_Profile.getInstance(iccBytes);
    }

    public Date getDateTimeAsDate() {
        Date date = EXIFDirectory.parseDate(this.getDateTime());
        if (this.isSubsecTimeAvailable()) {
            date = this.adjust(date, this.getSubsecTime());
        }
        return date;
    }

    public Date getDateTimeOriginalAsDate() {
        Date date = EXIFDirectory.parseDate(this.getDateTimeOriginal());
        if (this.isSubsecTimeOriginalAvailable()) {
            date = this.adjust(date, this.getSubsecTimeOriginal());
        }
        return date;
    }

    public Date getDateTimeDigitizedAsDate() {
        Date date = EXIFDirectory.parseDate(this.getDateTimeDigitized());
        if (this.isSubsecTimeDigitizedAvailable()) {
            date = this.adjust(date, this.getSubsecTimeDigitized());
        }
        return date;
    }

    private Date adjust(Date date, String subsec) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int millis = Integer.parseInt(subsec) * 10;
        calendar.add(14, millis);
        return calendar.getTime();
    }

    private static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return EXIF_DATE_PARSER.parse(string);
        }
        catch (Exception e) {
            try {
                return EXIF_DATE_PARSER2.parse(string);
            }
            catch (Exception e1) {
                System.err.println("*** BAD DATE " + string);
                return null;
            }
        }
    }

    private void print(Node node) {
    }
}

