/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.CoreServiceOrphanVersionRemovalFilterDescriptor;
import org.nuxeo.ecm.core.CoreServicePolicyDescriptor;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.versioning.DefaultVersionRemovalPolicy;
import org.nuxeo.ecm.core.versioning.OrphanVersionRemovalFilter;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class CoreService
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(CoreService.class);
    private ComponentContext context;
    private VersionRemovalPolicy versionRemovalPolicy;
    private List<OrphanVersionRemovalFilter> orphanVersionRemovalFilters = new ArrayList<OrphanVersionRemovalFilter>();

    public List<OrphanVersionRemovalFilter> getOrphanVersionRemovalFilters() {
        return this.orphanVersionRemovalFilters;
    }

    public VersionRemovalPolicy getVersionRemovalPolicy() {
        if (this.versionRemovalPolicy == null) {
            this.versionRemovalPolicy = new DefaultVersionRemovalPolicy();
        }
        return this.versionRemovalPolicy;
    }

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    public void registerExtension(Extension extension) {
        String point = extension.getExtensionPoint();
        if ("versionRemovalPolicy".equals(point)) {
            for (Object contrib : extension.getContributions()) {
                if (contrib instanceof CoreServicePolicyDescriptor) {
                    this.registerVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
                    continue;
                }
                log.error((Object)("Invalid contribution to extension point 'versionRemovalPolicy': " + contrib.getClass().getName()));
            }
        } else if ("orphanVersionRemovalFilter".equals(point)) {
            for (Object contrib : extension.getContributions()) {
                if (contrib instanceof CoreServiceOrphanVersionRemovalFilterDescriptor) {
                    this.registerOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
                    continue;
                }
                log.error((Object)("Invalid contribution to extension point 'orphanVersionRemovalFilter': " + contrib.getClass().getName()));
            }
        } else {
            log.error((Object)("Unknown extension point: " + point));
        }
    }

    public void unregisterExtension(Extension extension) {
    }

    private void registerVersionRemovalPolicy(CoreServicePolicyDescriptor desc) {
        String klass = desc.getKlass();
        try {
            this.versionRemovalPolicy = (VersionRemovalPolicy)this.context.getRuntimeContext().loadClass(klass).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate versionRemovalPolicy: " + klass), (Throwable)e);
        }
    }

    private void registerOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor desc) {
        String klass = desc.getKlass();
        try {
            this.orphanVersionRemovalFilters.add((OrphanVersionRemovalFilter)this.context.getRuntimeContext().loadClass(klass).newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate versionRemovalPolicy: " + klass), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cleanupOrphanVersions(final long commitSize) {
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        if (repositoryService == null) {
            return 0L;
        }
        List<String> repositoryNames = repositoryService.getRepositoryNames();
        final AtomicLong count = new AtomicLong();
        for (String repositoryName : repositoryNames) {
            boolean startTransaction;
            boolean bl = startTransaction = !TransactionHelper.isTransactionActiveOrMarkedRollback();
            if (startTransaction && !TransactionHelper.startTransaction()) {
                throw new RuntimeException("Cannot start transaction");
            }
            boolean completedAbruptly = true;
            try {
                new UnrestrictedSessionRunner(repositoryName){

                    public void run() {
                        count.addAndGet(CoreService.this.doCleanupOrphanVersions(this.session, commitSize));
                    }
                }.runUnrestricted();
                completedAbruptly = false;
            }
            finally {
                try {
                    if (!completedAbruptly) continue;
                    TransactionHelper.setTransactionRollbackOnly();
                }
                finally {
                    if (!startTransaction) continue;
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doCleanupOrphanVersions(CoreSession session, long commitSize) {
        HashMap<String, ArrayList<String>> versionSeriesToVersionIds = new HashMap<String, ArrayList<String>>();
        String findVersions = "SELECT ecm:uuid, ecm:versionVersionableId FROM Document WHERE ecm:isVersion = 1";
        try (IterableQueryResult res = session.queryAndFetch(findVersions, "NXQL", new Object[0]);){
            for (Map map : res) {
                String versionSeriesId = (String)map.get("ecm:versionVersionableId");
                String versionId = (String)map.get("ecm:uuid");
                ArrayList<String> versionIds = (ArrayList<String>)versionSeriesToVersionIds.get(versionSeriesId);
                if (versionIds == null) {
                    versionIds = new ArrayList<String>(4);
                    versionSeriesToVersionIds.put(versionSeriesId, versionIds);
                }
                versionIds.add(versionId);
            }
        }
        HashSet<String> seriesIds = new HashSet<String>();
        String findLive = "SELECT ecm:uuid FROM Document WHERE ecm:isProxy = 0 AND ecm:isVersion = 0";
        res = session.queryAndFetch(findLive, "NXQL", new Object[0]);
        try {
            for (Map map : res) {
                String id = (String)map.get("ecm:uuid");
                seriesIds.add(id);
            }
        }
        finally {
            res.close();
        }
        String findProxies = "SELECT ecm:proxyVersionableId FROM Document WHERE ecm:isProxy = 1";
        res = session.queryAndFetch(findProxies, "NXQL", new Object[0]);
        try {
            for (Map map : res) {
                String versionSeriesId = (String)map.get("ecm:proxyVersionableId");
                seriesIds.add(versionSeriesId);
            }
        }
        finally {
            res.close();
        }
        HashSet ids = new HashSet();
        for (Map.Entry en : versionSeriesToVersionIds.entrySet()) {
            if (seriesIds.contains(en.getKey())) continue;
            List versionIds = (List)en.getValue();
            ids.addAll(versionIds);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        if (!ids.isEmpty()) {
            long n = 0L;
            for (String id : ids) {
                session.removeDocument((DocumentRef)new IdRef(id));
                if (++n < commitSize) continue;
                session.save();
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
                n = 0L;
            }
            session.save();
        }
        return ids.size();
    }
}

