/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.inheritance;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.service.inheritance.ToutaticeInheritanceService;
import fr.toutatice.ecm.platform.service.inheritance.ToutaticeInheritanceSetter;
import fr.toutatice.ecm.platform.service.inheritance.ToutaticeInheritanceSetterDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.actions.seam.SeamActionContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class ToutaticeInheritanceServiceImpl
extends DefaultComponent
implements ToutaticeInheritanceService {
    private static final Log log = LogFactory.getLog(ToutaticeInheritanceServiceImpl.class);
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    public static final ComponentName ID = new ComponentName("fr.toutatice.ecm.platform.service.inheritance");
    public static final String EXTENSION_POINTS_SETTERS = "setters";
    protected final Map<String, ToutaticeInheritanceSetterDescriptor> settersDescriptors = new HashMap<String, ToutaticeInheritanceSetterDescriptor>();
    protected ActionManager actionManager;

    public void deactivate(ComponentContext context) throws Exception {
        this.settersDescriptors.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINTS_SETTERS.equals(extensionPoint)) {
            ToutaticeInheritanceSetterDescriptor setterContribution = (ToutaticeInheritanceSetterDescriptor)contribution;
            Class<?> clazz = setterContribution.getClazz();
            if (null != clazz && ToutaticeInheritanceSetter.class.isAssignableFrom(clazz)) {
                ToutaticeInheritanceSetter setter = (ToutaticeInheritanceSetter)clazz.newInstance();
                setterContribution.setSetter(setter);
                this.settersDescriptors.put(setterContribution.getName(), setterContribution);
            } else {
                log.warn((Object)("Failed to register the contribution '" + contributor.getName() + "'. Either a null clazz is defined or it doesn't implement the interface 'ToutaticeInheritanceSetter'"));
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINTS_SETTERS.equals(extensionPoint)) {
            ToutaticeInheritanceSetterDescriptor setterContribution = (ToutaticeInheritanceSetterDescriptor)contribution;
            this.settersDescriptors.remove(setterContribution.getName());
        }
    }

    @Override
    public void run(Event event, boolean isSynchronousExecution) {
        DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
        CoreSession session = eventContext.getCoreSession();
        eventContext.setProperty("recursionDepthCount", (Serializable)new Integer(0));
        try {
            InheritanceSilentModeRunner runner = new InheritanceSilentModeRunner(session, event, isSynchronousExecution);
            runner.silentRun(true, FILTERED_SERVICES_LIST);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to run the inheritance process, error: " + e.getMessage()));
        }
    }

    private ActionManager getActionService() throws Exception {
        if (null == this.actionManager) {
            this.actionManager = (ActionManager)Framework.getService(ActionManager.class);
        }
        return this.actionManager;
    }

    private class InheritanceSilentModeRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private Event event;
        private boolean synchronously;

        public InheritanceSilentModeRunner(CoreSession session, Event event, boolean synchronously) {
            super(session);
            this.event = event;
            this.synchronously = synchronously;
        }

        public void run() throws ClientException {
            DocumentEventContext eventContext = (DocumentEventContext)this.event.getContext();
            String eventName = this.event.getName();
            DocumentModel document = eventContext.getSourceDocument();
            this.run(eventContext, document, eventName, null);
        }

        private void run(DocumentEventContext eventContext, DocumentModel document, String eventName, Action threadAction) {
            DocumentModelList parents = null;
            if (document.isImmutable()) {
                return;
            }
            try {
                SeamActionContext actionContext = new SeamActionContext();
                actionContext.setCurrentDocument(document);
                actionContext.setDocumentManager(this.session);
                actionContext.setCurrentPrincipal((NuxeoPrincipal)this.session.getPrincipal());
                List<Object> actions = new ArrayList<Action>();
                if (null != threadAction) {
                    Action a = ToutaticeInheritanceServiceImpl.this.getActionService().getAction(threadAction.getId(), (ActionContext)actionContext, true);
                    if (null != a) {
                        actions.add(a);
                    }
                } else {
                    String ACTION_ID_PREFIX = String.format("OPENTOUTATICE_INHERITANCE_%s@", this.synchronously ? "SYNC" : "ASYNC");
                    actions = ToutaticeInheritanceServiceImpl.this.getActionService().getActions(ACTION_ID_PREFIX + eventName, (ActionContext)actionContext);
                }
                for (Action action : actions) {
                    int recursionDepthLevel;
                    Map properties = action.getProperties();
                    Map srcProperties = (Map)properties.get("source");
                    if (null != srcProperties) {
                        String thisIncludedPrty = (String)srcProperties.get("thisIncluded");
                        boolean thisIncluded = StringUtils.isNotBlank((String)thisIncludedPrty) ? Boolean.parseBoolean(thisIncludedPrty) : false;
                        String immediateOnlyPrty = (String)srcProperties.get("immediateOnly");
                        boolean immediateOnly = StringUtils.isNotBlank((String)immediateOnlyPrty) ? Boolean.parseBoolean(immediateOnlyPrty) : true;
                        String[] srcFilters = (String[])srcProperties.get("filters");
                        DocumentModel root = document;
                        if ("emptyDocumentModelCreated".equals(eventName)) {
                            String parentPath = (String)((Object)eventContext.getProperty("parentPath"));
                            if (StringUtils.isBlank((String)parentPath)) {
                                return;
                            }
                            root = this.session.getDocument((DocumentRef)new PathRef(parentPath));
                            thisIncluded = true;
                        }
                        parents = ToutaticeDocumentHelper.getParentList((CoreSession)this.session, (DocumentModel)root, (Filter)new InheritanceParentFilter(ToutaticeInheritanceServiceImpl.this.getActionService(), (ActionContext)actionContext, srcFilters), (boolean)true, (boolean)immediateOnly, (boolean)thisIncluded);
                    }
                    Map dstProperties = (Map)properties.get("destination");
                    String setterName = (String)dstProperties.get("setter");
                    String recursivityProp = (String)dstProperties.get("recursion");
                    boolean isRecursive = StringUtils.isNotBlank((String)recursivityProp) ? Boolean.parseBoolean(recursivityProp) : false;
                    String recursionDepthLevelProp = (String)dstProperties.get("recursionDepthLevel");
                    int n = recursionDepthLevel = StringUtils.isNotBlank((String)recursionDepthLevelProp) ? Integer.parseInt(recursionDepthLevelProp) : 0;
                    if (ToutaticeInheritanceServiceImpl.this.settersDescriptors.containsKey(setterName)) {
                        ToutaticeInheritanceSetterDescriptor sDesc = ToutaticeInheritanceServiceImpl.this.settersDescriptors.get(setterName);
                        ToutaticeInheritanceSetter setter = sDesc.getSetter();
                        boolean isUpdated = setter.execute((EventContext)eventContext, null != parents && 0 < parents.size() ? (DocumentModel)parents.get(0) : null, document);
                        if (isUpdated && !"emptyDocumentModelCreated".equals(eventName)) {
                            this.session.saveDocument(document);
                        }
                        Integer recursionCount = (Integer)eventContext.getProperty("recursionDepthCount");
                        if (!document.isFolder() || !isRecursive || 0 != recursionDepthLevel && recursionCount >= recursionDepthLevel) continue;
                        recursionCount = recursionCount + 1;
                        eventContext.setProperty("recursionDepthCount", (Serializable)recursionCount);
                        DocumentModelList children = this.session.getChildren(document.getRef(), null, new Filter(){
                            private static final long serialVersionUID = 1L;

                            public boolean accept(DocumentModel docModel) {
                                boolean status = false;
                                try {
                                    status = !docModel.isImmutable() && !"deleted".equals(docModel.getCurrentLifeCycleState());
                                }
                                catch (ClientException e) {
                                    log.error((Object)("Failed to evaluate children, error: " + e.getMessage()));
                                }
                                return status;
                            }
                        }, null);
                        for (DocumentModel child : children) {
                            this.run(eventContext, child, eventName, action);
                        }
                        recursionCount = recursionCount - 1;
                        eventContext.setProperty("recursionDepthCount", (Serializable)recursionCount);
                        continue;
                    }
                    log.warn((Object)("Referenced unknown setter '" + setterName + "'"));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed while processing inheritance, error: " + e.getMessage()));
            }
        }
    }

    private class InheritanceParentFilter
    implements Filter {
        private static final long serialVersionUID = 1L;
        private ActionManager actionManager;
        private String[] filters;
        private ActionContext actionContext;

        public InheritanceParentFilter(ActionManager manager, ActionContext context, String[] filters) {
            this.actionManager = manager;
            this.filters = filters;
            this.actionContext = context;
        }

        public boolean accept(DocumentModel docModel) {
            String filterId;
            boolean status = true;
            this.actionContext.setCurrentDocument(docModel);
            this.actionContext.putLocalVariable("PrecomputedFilters", null);
            String[] arr$ = this.filters;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (status = this.actionManager.checkFilter(filterId = arr$[i$], this.actionContext)); ++i$) {
            }
            return status;
        }
    }
}

