/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.listener;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class FolderishInfosListener
implements EventListener {
    private static final String DELETED_FOLDERISH_WEBIDS_QUERY = "select ttc:webid from Document where ecm:mixinType = 'Folderish' and ecm:ancestorId = '%s' and ecm:currentLifeCycleState = 'deleted' and ecm:isVersion = 0 and ecm:isProxy = 0";

    public void handleEvent(Event event) throws ClientException {
        if ("aboutToRemove".equals(event.getName()) && event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            CoreSession session = docCtx.getCoreSession();
            DocumentModel srcDoc = docCtx.getSourceDocument();
            if (srcDoc.isFolder() && srcDoc.hasSchema("toutatice")) {
                this.storeRemovedWebids(docCtx, session, srcDoc);
            }
        }
    }

    private void storeRemovedWebids(DocumentEventContext docCtx, CoreSession session, DocumentModel srcDoc) {
        String currentWebId = (String)((Object)srcDoc.getPropertyValue("ttc:webid"));
        StringBuffer wIds = new StringBuffer().append("('").append(currentWebId).append("'");
        IterableQueryResult results = ToutaticeEsQueryHelper.unrestrictedQueryAndAggregate((CoreSession)session, (String)String.format(DELETED_FOLDERISH_WEBIDS_QUERY, srcDoc.getId()));
        if (results != null) {
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                wIds.append(",'");
                String webId = (String)((Map)iterator.next()).get("ttc:webid");
                wIds.append(webId);
                wIds.append("'");
            }
            results.close();
        }
        wIds.append(")");
        docCtx.setProperty("parentCheckoutIds", (Serializable)((Object)wIds.toString()));
    }
}

