/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.portal.infos.provider;

import fr.toutatice.ecm.checkin.helper.DocumentCheckinHelper;
import fr.toutatice.ecm.platform.service.lock.DocumentLockInfosProvider;
import fr.toutatice.ecm.platform.service.lock.DocumentLockInfosProviderImpl;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class CheckinLockInfosProvider
extends DocumentLockInfosProviderImpl {
    private static final Log log = LogFactory.getLog(CheckinLockInfosProvider.class);

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        long begin = System.currentTimeMillis();
        Map lockInfos = super.fetchInfos(coreSession, currentDocument);
        DocumentCheckinHelper checkinHelper = DocumentCheckinHelper.getInstance();
        if (checkinHelper.isDraft(currentDocument) || checkinHelper.hasDraft(currentDocument)) {
            if (checkinHelper.isDraft(currentDocument)) {
                lockInfos.remove("lockCreationDate");
                lockInfos.remove("lockOwner");
                lockInfos.put("lockStatus", DocumentLockInfosProvider.LockStatus.no_lock);
            } else if (checkinHelper.hasDraft(currentDocument)) {
                lockInfos.put("lockStatus", DocumentLockInfosProvider.LockStatus.locked);
            }
            return lockInfos;
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
        }
        return lockInfos;
    }
}

