/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.automation.SetWebID;
import fr.toutatice.ecm.platform.service.webid.TTCUIDGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.uidgen.UIDGenerator;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class IdsRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(IdsRunner.class);
    private static final String NO_DEFINED_WEBID_LIVES_QUERY = "select * from Document where (ttc:webid = '' or ttc:webid is NULL) and ecm:isProxy = 0 and ecm:isVersion = 0 ";
    private static final String NO_DEFINED_WEBID_VERSIONS_QUERY = "select * from Document where (ttc:webid = '' or ttc:webid is NULL) and ecm:isVersion = 1 ";
    private static final String HAS_TTC_CLAUSE = " and ecm:primaryType not in ('DefaultSearch', 'PublicationRelation', 'ManagementRoot', 'AdministrativeStatusContainer', 'CommentRelation', 'Comment', 'uarDemImpressionFermee_cv', 'doc_acaren_faceted_search', 'MerEnsSMContentView_cv', 'SimpleTask', 'DefaultRelation', 'ConditionalTask', 'UserInvitationContainer', 'uarDemImpressionAGerer_cv', 'StepFolder', 'cv_unu_DUN_cv', 'uarDemImpressionEnAttenteValidation_cv', 'cv_clp_ContentOnline_cv', 'UserInvitation', 'Post', 'AdministrativeStatus', 'DocumentRouteModelsRoot', 'HiddenFolder', 'cv_le_Content_approved_cv', 'UserProfile', 'uarDemImpressionFermeeOpe_cv', 'uarDemImpressionTraitee_cv', 'pud_cv', 'Tag', 'DocumentRoute', 'Tagging', 'uarDemImpressionRecue_cv', 'cv_le_Content_all_cv', 'DocumentRouteStep', 'cv_clp_Content_cv', 'MonProfil', 'ConditionalStepFolder', 'cv_le_Content_submitted_cv', 'demande_cv', 'uarDemImpressionTerminee_cv', 'TaskRoot', 'uarDemImpressionEnCours_cv', 'DocumentRouteInstancesRoot', 'FollowLifeCycleTransitionTask', 'PublishTask', 'UserWorkspacesRoot', 'RouteNode', 'FacetedSearchDefault', 'TaskDoc', 'cv_le_Content_integrated_cv', 'MaintenanceConfiguration', 'uarDemImpressionEnRecharge_cv', 'CommentRoot') ";
    private static final String NOT_UWS_CLAUSE = " and not(ecm:path startswith '/home' or ecm:path startswith '/userworkspace-domain') ";
    private static final String UWS_CLAUSE = " and ecm:path startswith '/home' ";
    private static final String PARENT_SPACE_CLAUSE = " and ecm:path startswith '%s' ";
    private static final String INCLUDE_UWS_PARAM = "uws";
    private static final String SPACE_MARKER_PARAM = "_SPACE_";
    private static final String ONLY_VERSIONS_PARAM = "onlyVersions";
    private boolean onlyVersions = false;
    private boolean excludesUws = true;
    private String spacePath = "";
    private static UIDGenerator wIdGenerator;
    private int nbDocsInTransac = 0;
    private int nbCollisions = 0;

    private static UIDGenerator getWebIdGenerator() {
        if (wIdGenerator == null) {
            TTCUIDGeneratorService service = (TTCUIDGeneratorService)Framework.getRuntime().getComponent("fr.toutatice.ecm.platform.service.webid.TTCUIDGeneratorService");
            wIdGenerator = service.getDefaultUIDGenerator();
        }
        return wIdGenerator;
    }

    public IdsRunner(CoreSession session) {
        super(session);
    }

    @Override
    public void setParams(String reqParams) {
        String[] params = StringUtils.split((String)reqParams, (String)",");
        if (params != null) {
            for (int ind = 0; ind < params.length; ++ind) {
                if (StringUtils.equals((String)params[ind], (String)INCLUDE_UWS_PARAM)) {
                    this.excludesUws = false;
                }
                if (StringUtils.startsWith((String)params[ind], (String)SPACE_MARKER_PARAM)) {
                    this.spacePath = StringUtils.substringAfter((String)params[ind], (String)SPACE_MARKER_PARAM);
                }
                if (!StringUtils.equals((String)params[ind], (String)ONLY_VERSIONS_PARAM)) continue;
                this.onlyVersions = true;
            }
        }
    }

    @Override
    public int setInputs(int limit) {
        DocumentModel parentSpace;
        String psWId;
        int size = 0;
        String spaceParentClause = StringUtils.isNotEmpty((String)this.spacePath) ? String.format(PARENT_SPACE_CLAUSE, this.spacePath) : "";
        String uwsClause = this.excludesUws ? NOT_UWS_CLAUSE : UWS_CLAUSE;
        String extraClause = HAS_TTC_CLAUSE + spaceParentClause + uwsClause;
        if (StringUtils.isNotEmpty((String)spaceParentClause) && StringUtils.isBlank((String)(psWId = (String)((Object)(parentSpace = this.session.getDocument((DocumentRef)new PathRef(this.spacePath))).getPropertyValue("ttc:webid"))))) {
            this.inputs.add((Object)parentSpace);
        }
        if (!this.onlyVersions) {
            long bq = System.currentTimeMillis();
            this.inputs = this.session.query(NO_DEFINED_WEBID_LIVES_QUERY + extraClause, limit);
            if (log.isDebugEnabled()) {
                long eq = System.currentTimeMillis();
                log.debug((Object)("[Lives query]: " + String.valueOf(eq - bq) + " ms"));
            }
        } else {
            long bqv = System.currentTimeMillis();
            this.inputs = this.session.query(NO_DEFINED_WEBID_VERSIONS_QUERY + extraClause, limit);
            if (log.isDebugEnabled()) {
                long eqv = System.currentTimeMillis();
                log.debug((Object)("[Versions query]: " + String.valueOf(eqv - bqv) + " ms"));
            }
        }
        size = this.inputs.size();
        this.totalInputs += size;
        return size;
    }

    @Override
    public void run() throws ClientException {
        if (!this.onlyVersions) {
            this.migrateLivesNVersions();
        } else {
            this.migrateOnlyVersions();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[----- Collisions number: " + String.valueOf(this.nbCollisions) + " -----]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateLivesNVersions() {
        if (this.inputs.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[----- Migrating lives and their versions -----]");
            }
            long begin = System.currentTimeMillis();
            LauncherTransactionHelper.checkNStartTransaction();
            try {
                for (DocumentModel live : this.inputs) {
                    String webId = this.generateWebId(this.session, live);
                    this.setId(live, webId);
                    List versions = this.session.getVersions(live.getRef());
                    for (DocumentModel version : versions) {
                        this.setIdOnVersion(version, webId);
                    }
                    if (this.nbDocsInTransac <= 100) continue;
                    this.nbDocsInTransac = 0;
                    break;
                }
                this.session.save();
            }
            catch (Exception e) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
                log.error((Object)e);
            }
            finally {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            if (log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                log.debug((Object)("[----- Lives and their versions migrated: " + String.valueOf(end - begin) + " ms -----]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateOnlyVersions() {
        if (this.inputs.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[----- Migrating only versions -----]");
            }
            long begin = System.currentTimeMillis();
            LauncherTransactionHelper.checkNStartTransaction();
            try {
                for (DocumentModel version : this.inputs) {
                    DocumentModel live = this.session.getWorkingCopy(version.getRef());
                    String webId = (String)((Object)live.getPropertyValue("ttc:webid"));
                    if (StringUtils.isNotBlank((String)webId)) {
                        this.setIdOnVersion(version, webId);
                        continue;
                    }
                    if (live == null) continue;
                    log.error((Object)("No webId on: " + live.getPathAsString()));
                }
                this.session.save();
            }
            catch (Exception e) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
                log.error((Object)e);
            }
            finally {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            if (log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                log.debug((Object)("[----- Versions migrated: " + String.valueOf(end - begin) + " ms -----]"));
            }
        }
    }

    private String generateWebId(CoreSession session, DocumentModel doc) throws DocumentException {
        String webId = IdsRunner.getWebIdGenerator().createUID(doc);
        while (SetWebID.UnrestrictedSilentSetWebIdRunner.isNotUnique((CoreSession)session, (DocumentModel)doc, (String)webId)) {
            webId = IdsRunner.getWebIdGenerator().createUID(doc);
            ++this.nbCollisions;
        }
        return webId;
    }

    private void setId(DocumentModel doc, String webid) {
        if (doc != null) {
            long begin = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Treating live: " + doc.getPathAsString()));
            }
            doc.setPropertyValue("ttc:webid", (Serializable)((Object)webid));
            this.session.saveDocument(doc);
            ++this.treatedInputs;
            ++this.nbDocsInTransac;
            if (log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                log.debug((Object)("SetId [" + webid + "] on live: " + String.valueOf(end - begin) + " ms"));
            }
        }
    }

    private void setIdOnVersion(DocumentModel version, String webid) {
        if (version != null) {
            long begin = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Treating version: " + version.getPathAsString()));
            }
            version.putContextData("allowVersionWrite", (Serializable)Boolean.valueOf(true));
            version.setPropertyValue("ttc:webid", (Serializable)((Object)webid));
            this.session.saveDocument(version);
            ++this.treatedInputs;
            ++this.totalInputs;
            ++this.nbDocsInTransac;
            if (log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                log.debug((Object)("SetId [" + webid + "] on version: " + String.valueOf(end - begin) + " ms"));
            }
        }
    }
}

