/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.util.jar.JarFileCloser;
import org.nuxeo.osgi.util.jar.URLClassLoaderCloser;
import org.nuxeo.osgi.util.jar.URLJarFileIntrospectionError;
import org.nuxeo.osgi.util.jar.URLJarFileIntrospector;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.SharedResourceLoader;

public class URLJarFileCloser
implements JarFileCloser {
    protected final URLClassLoaderCloser applicationCloser;
    protected final URLJarFileIntrospector introspector;

    public URLJarFileCloser(URLJarFileIntrospector anIntrospector, ClassLoader appCL) throws URLJarFileIntrospectionError {
        this.introspector = anIntrospector;
        this.applicationCloser = appCL instanceof URLClassLoader ? this.introspector.newURLClassLoaderCloser((URLClassLoader)appCL) : null;
    }

    @Override
    public void close(JarFile file) throws IOException {
        file.close();
        URL location = new File(file.getName()).toURI().toURL();
        boolean closed = false;
        try {
            SharedResourceLoader loader = Framework.getResourceLoader();
            if (loader != null) {
                closed = this.introspector.newURLClassLoaderCloser((URLClassLoader)loader).close(location);
            }
        }
        catch (URLJarFileIntrospectionError cause) {
            LogFactory.getLog(URLJarFileCloser.class).error((Object)"Cannot introspect shared resource loader", (Throwable)cause);
        }
        if (!closed && this.applicationCloser != null) {
            closed = this.applicationCloser.close(location);
        }
        this.introspector.close(location);
    }
}

