/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerService;
import org.nuxeo.ecm.core.storage.binary.CachingBinaryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class LazyBinary
extends Binary {
    private static final long serialVersionUID = 1L;
    protected boolean hasLength;
    protected transient CachingBinaryManager cbm;

    public LazyBinary(String digest, String repoName, CachingBinaryManager cbm) {
        super(digest, repoName);
        this.cbm = cbm;
    }

    public LazyBinary(String digest, long length, String repoName, CachingBinaryManager cbm) {
        this(digest, repoName, cbm);
        this.length = length;
        this.hasLength = true;
    }

    protected CachingBinaryManager getCachingBinaryManager() {
        if (this.cbm == null) {
            if (this.repoName == null) {
                throw new UnsupportedOperationException("Cannot find binary manager, no repository name");
            }
            BinaryManagerService bms = (BinaryManagerService)((Object)Framework.getLocalService(BinaryManagerService.class));
            this.cbm = (CachingBinaryManager)bms.getBinaryManager(this.repoName);
        }
        return this.cbm;
    }

    @Override
    public InputStream getStream() throws IOException {
        File file = this.getCachingBinaryManager().getFile(this.digest);
        if (file != null) {
            this.length = file.length();
            this.hasLength = true;
        }
        return file == null ? null : new FileInputStream(file);
    }

    @Override
    public StreamSource getStreamSource() {
        File file;
        try {
            file = this.getCachingBinaryManager().getFile(this.digest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file != null) {
            this.length = file.length();
            this.hasLength = true;
        }
        return file == null ? null : new FileSource(file);
    }

    @Override
    public long getLength() {
        if (!this.hasLength) {
            Long len;
            try {
                len = this.getCachingBinaryManager().getLength(this.digest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.length = len == null ? 0L : len;
            this.hasLength = true;
        }
        return this.length;
    }
}

