/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.ICloneable;
import com.phloc.commons.IHasSize;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStack<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE>
implements IHasSize,
ICloneable<NonBlockingStack<ELEMENTTYPE>> {
    public NonBlockingStack() {
    }

    public NonBlockingStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        ContainerHelper.getConcatenatedInline(this, ELEMENTTYPEArray);
    }

    public NonBlockingStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public NonBlockingStack(@Nullable NonBlockingStack<? extends ELEMENTTYPE> nonBlockingStack) {
        if (nonBlockingStack != null) {
            this.addAll(nonBlockingStack);
        }
    }

    @Nullable
    public ELEMENTTYPE push(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.add(ELEMENTTYPE);
        return ELEMENTTYPE;
    }

    @Nullable
    public ELEMENTTYPE pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.remove(this.size() - 1);
    }

    @Nullable
    public ELEMENTTYPE peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.get(this.size() - 1);
    }

    @Nullable
    public ELEMENTTYPE firstElement() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.get(0);
    }

    @Override
    @Nonnull
    public NonBlockingStack<ELEMENTTYPE> getClone() {
        return new NonBlockingStack<ELEMENTTYPE>(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(super.hashCode()).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("list", super.toString()).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> create() {
        return new NonBlockingStack<ELEMENTTYPE>();
    }

    @Nonnull
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> create(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return new NonBlockingStack<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> create(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return new NonBlockingStack<ELEMENTTYPE>(collection);
    }

    @Nonnull
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> create(@Nullable NonBlockingStack<? extends ELEMENTTYPE> nonBlockingStack) {
        return new NonBlockingStack<ELEMENTTYPE>(nonBlockingStack);
    }
}

