/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.sort;

import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValue;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValueComparable;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter s_aInstance = new TreeSorter();

    private TreeSorter() {
    }

    private static <VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        if (iBasicTree == null) {
            throw new NullPointerException("tree");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        ((ITreeItem)iBasicTree.getRootItem()).reorderChildItems(comparator);
        TreeWalker.walkTree(iBasicTree, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildItems(comparator);
                }
            }
        });
    }

    public static <VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super VALUETYPE> comparator) {
        ComparatorTreeItemValue comparatorTreeItemValue = new ComparatorTreeItemValue(comparator);
        TreeSorter._sort(iBasicTree, comparatorTreeItemValue);
    }

    public static <VALUETYPE extends Comparable<? super VALUETYPE>, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemValueComparable comparatorTreeItemValueComparable = new ComparatorTreeItemValueComparable();
        TreeSorter._sort(iBasicTree, comparatorTreeItemValueComparable);
    }
}

