/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.decorators.ProxyShortIterator;

public final class UnmodifiableShortIterator
extends ProxyShortIterator {
    private ShortIterator m_aProxied;

    UnmodifiableShortIterator(@Nonnull ShortIterator shortIterator) {
        this.m_aProxied = shortIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This ShortIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected ShortIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final ShortIterator wrap(@Nullable ShortIterator shortIterator) {
        if (null == shortIterator) {
            return null;
        }
        if (shortIterator instanceof UnmodifiableShortIterator) {
            return shortIterator;
        }
        return new UnmodifiableShortIterator(shortIterator);
    }
}

