/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.ConnectionResetException;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCRowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerService;
import org.nuxeo.ecm.core.storage.sql.jdbc.ResultSetQueryResult;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.TableUpgrader;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;
import org.nuxeo.runtime.api.Framework;

public class JDBCMapper
extends JDBCRowMapper
implements Mapper {
    private static final Log log = LogFactory.getLog(JDBCMapper.class);
    public static Map<String, Serializable> testProps = new HashMap<String, Serializable>();
    public static final String TEST_UPGRADE = "testUpgrade";
    public static final String TEST_UPGRADE_VERSIONS = "testUpgradeVersions";
    public static final String TEST_UPGRADE_LAST_CONTRIBUTOR = "testUpgradeLastContributor";
    public static final String TEST_UPGRADE_LOCKS = "testUpgradeLocks";
    protected TableUpgrader tableUpgrader;
    private final QueryMakerService queryMakerService;
    private final Session.PathResolver pathResolver;
    private final RepositoryImpl repository;
    protected boolean clusteringEnabled;

    public JDBCMapper(Model model, Session.PathResolver pathResolver, SQLInfo sqlInfo, XADataSource xadatasource, ClusterNodeHandler clusterNodeHandler, JDBCConnectionPropagator connectionPropagator, boolean noSharing, RepositoryImpl repository) throws StorageException {
        super(model, sqlInfo, xadatasource, clusterNodeHandler, connectionPropagator, noSharing);
        this.pathResolver = pathResolver;
        this.repository = repository;
        this.clusteringEnabled = clusterNodeHandler != null;
        try {
            this.queryMakerService = (QueryMakerService)Framework.getService(QueryMakerService.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.tableUpgrader = new TableUpgrader(this);
        this.tableUpgrader.add("versions", "islatest", "upgradeVersions", TEST_UPGRADE_VERSIONS);
        this.tableUpgrader.add("dublincore", "lastContributor", "upgradeLastContributor", TEST_UPGRADE_LAST_CONTRIBUTOR);
        this.tableUpgrader.add("locks", "owner", "upgradeLocks", TEST_UPGRADE_LOCKS);
    }

    @Override
    public int getTableSize(String tableName) {
        return this.sqlInfo.getDatabase().getTable(tableName).getColumns().size();
    }

    @Override
    public void createDatabase(String ddlMode) throws StorageException {
        try {
            this.createTables(ddlMode);
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    protected String getTableName(String origName) {
        if (this.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    /*
     * WARNING - void declaration
     */
    protected void createTables(String ddlMode) throws SQLException {
        Serializable addedColumns;
        SQLStatement.ListCollector ddlCollector = new SQLStatement.ListCollector();
        this.sqlInfo.executeSQLStatements(null, ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("first", ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("beforeTableCreation", ddlMode, this.connection, this.logger, ddlCollector);
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements(TEST_UPGRADE, ddlMode, this.connection, this.logger, null);
        }
        String schemaName = this.dialect.getConnectionSchema(this.connection);
        DatabaseMetaData metadata = this.connection.getMetaData();
        Set<String> tableNames = JDBCMapper.findTableNames(metadata, schemaName);
        Database database = this.sqlInfo.getDatabase();
        HashMap added = new HashMap();
        for (Table table : database.getTables()) {
            String tableName = this.getTableName(table.getPhysicalName());
            if (!tableNames.contains(tableName.toUpperCase())) {
                ddlCollector.add(table.getCreateSql());
                ddlCollector.addAll(table.getPostCreateSqls(this.model));
                added.put(table.getKey(), null);
                this.sqlInfo.sqlStatementsProperties.put("create_table_" + tableName.toLowerCase(), Boolean.TRUE);
                continue;
            }
            HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
            HashMap<String, String> columnTypeNames = new HashMap<String, String>();
            HashMap<String, Integer> columnTypeSizes = new HashMap<String, Integer>();
            try (ResultSet rs = metadata.getColumns(null, schemaName, tableName, "%");){
                while (rs.next()) {
                    String string = rs.getString("TABLE_SCHEM");
                    if (string != null && "INFORMATION_SCHEMA".equals(string.toUpperCase())) continue;
                    String columnName = rs.getString("COLUMN_NAME").toUpperCase();
                    columnTypes.put(columnName, rs.getInt("DATA_TYPE"));
                    columnTypeNames.put(columnName, rs.getString("TYPE_NAME"));
                    columnTypeSizes.put(columnName, rs.getInt("COLUMN_SIZE"));
                }
            }
            addedColumns = new LinkedList();
            for (Column column : table.getColumns()) {
                Integer actualSize;
                String actualName;
                String upperName = column.getPhysicalName().toUpperCase();
                Integer n = (Integer)columnTypes.remove(upperName);
                if (n == null) {
                    log.warn((Object)("Adding missing column in database: " + column.getFullQuotedName()));
                    ddlCollector.add(table.getAddColumnSql(column));
                    ddlCollector.addAll(table.getPostAddSqls(column, this.model));
                    addedColumns.add(column);
                    continue;
                }
                int expected = column.getJdbcType();
                int actual = n;
                if (column.setJdbcType(actual, actualName = (String)columnTypeNames.get(upperName), actualSize = (Integer)columnTypeSizes.get(upperName))) continue;
                log.error((Object)String.format("SQL type mismatch for %s: expected %s, database has %s / %s (%s)", column.getFullQuotedName(), expected, n, actualName, actualSize));
            }
            for (String string : this.dialect.getIgnoredColumns(table)) {
                columnTypes.remove(string.toUpperCase());
            }
            if (!columnTypes.isEmpty()) {
                log.warn((Object)("Database contains additional unused columns for table " + table.getQuotedName() + ": " + StringUtils.join(new ArrayList(columnTypes.keySet()), (String)", ")));
            }
            if (addedColumns.isEmpty()) continue;
            if (added.containsKey(table.getKey())) {
                throw new AssertionError();
            }
            added.put(table.getKey(), addedColumns);
        }
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements("testUpgradeOldTables", ddlMode, this.connection, this.logger, ddlCollector);
        }
        for (Map.Entry entry : added.entrySet()) {
            List addedColumns2 = (List)entry.getValue();
            String tableKey = (String)entry.getKey();
            this.upgradeTable(tableKey, addedColumns2, ddlMode, ddlCollector);
        }
        this.sqlInfo.executeSQLStatements("afterTableCreation", ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("last", ddlMode, this.connection, this.logger, ddlCollector);
        this.dialect.performAdditionalStatements(this.connection);
        List<String> ddl = ddlCollector.getStrings();
        boolean bl = ddlMode.contains("ignore");
        boolean dump = ddlMode.contains("dump");
        boolean abort = ddlMode.contains("abort");
        if ((dump || abort) && !ddl.isEmpty()) {
            File dumpFile = new File(Environment.getDefault().getLog(), "ddl-vcs-" + this.repository.getName() + ".sql");
            try {
                FileOutputStream out = new FileOutputStream(dumpFile);
                addedColumns = null;
                try {
                    Throwable throwable = null;
                    try (PrintStream ps = new PrintStream(out);){
                        for (String string : this.dialect.getDumpStart()) {
                            ps.println(string);
                        }
                        for (String string : ddl) {
                            void var18_50;
                            String string2 = string.trim();
                            if (string2.endsWith(";")) {
                                String string3 = string2.substring(0, string2.length() - 1);
                            }
                            ps.println(this.dialect.getSQLForDump((String)var18_50));
                        }
                        for (String string : this.dialect.getDumpStop()) {
                            ps.println(string);
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable x2) {
                    addedColumns = x2;
                    throw x2;
                }
                finally {
                    if (out != null) {
                        if (addedColumns != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)addedColumns).addSuppressed(x2);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            if (abort) {
                log.error((Object)("Dumped DDL to: " + dumpFile));
                throw new NuxeoException("Database initialization failed for: " + this.repository.getName() + ", DDL must be executed: " + dumpFile);
            }
        }
        if (!bl) {
            try (Statement st = this.connection.createStatement();){
                for (String sql : ddl) {
                    this.logger.log(sql.replace("\n", "\n    "));
                    try {
                        st.execute(sql);
                    }
                    catch (SQLException sQLException) {
                        throw new SQLException("Error executing: " + sql + " : " + sQLException.getMessage(), sQLException);
                    }
                    this.countExecute();
                }
            }
            st = this.connection.createStatement();
            var13_18 = null;
            try {
                for (String sql : this.dialect.getStartupSqls(this.model, this.sqlInfo.database)) {
                    this.logger.log(sql.replace("\n", "\n    "));
                    try {
                        st.execute(sql);
                    }
                    catch (SQLException sQLException) {
                        throw new SQLException("Error executing: " + sql + " : " + sQLException.getMessage(), sQLException);
                    }
                    this.countExecute();
                }
            }
            catch (Throwable throwable) {
                var13_18 = throwable;
                throw throwable;
            }
            finally {
                if (st != null) {
                    if (var13_18 != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable x2) {
                            var13_18.addSuppressed(x2);
                        }
                    } else {
                        st.close();
                    }
                }
            }
        }
    }

    protected void upgradeTable(String tableKey, List<Column> addedColumns, String ddlMode, SQLStatement.ListCollector ddlCollector) throws SQLException {
        this.tableUpgrader.upgrade(tableKey, addedColumns, ddlMode, ddlCollector);
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName.toUpperCase());
        }
        rs.close();
        return tableNames;
    }

    @Override
    public int getClusterNodeIdType() {
        return this.sqlInfo.getClusterNodeIdType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClusterNode(Serializable nodeId) throws StorageException {
        Calendar now = Calendar.getInstance();
        try {
            String sql = this.sqlInfo.getCreateClusterNodeSql();
            List<Column> columns = this.sqlInfo.getCreateClusterNodeColumns();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Arrays.asList(nodeId, now));
                }
                columns.get(0).setToPreparedStatement(ps, 1, nodeId);
                columns.get(1).setToPreparedStatement(ps, 2, now);
                ps.execute();
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterNode(Serializable nodeId) throws StorageException {
        try {
            String sql = this.sqlInfo.getDeleteClusterNodeSql();
            Column column = this.sqlInfo.getDeleteClusterNodeColumn();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Arrays.asList(nodeId));
                }
                column.setToPreparedStatement(ps, 1, nodeId);
                ps.execute();
            }
            finally {
                this.closeStatement(ps);
            }
            this.deleteClusterInvals(nodeId);
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteClusterInvals(Serializable nodeId) throws SQLException {
        String sql = this.sqlInfo.getDeleteClusterInvalsSql();
        Column column = this.sqlInfo.getDeleteClusterInvalsColumn();
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Arrays.asList(nodeId));
            }
            column.setToPreparedStatement(ps, 1, nodeId);
            int n = ps.executeUpdate();
            this.countExecute();
            if (this.logger.isLogEnabled()) {
                this.logger.logCount(n);
            }
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)("deleteClusterInvals: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void insertClusterInvalidations(Serializable nodeId, Invalidations invalidations) throws StorageException {
        String sql = this.dialect.getClusterInsertInvalidations();
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            int kind = 1;
            while (true) {
                Set<RowId> rowIds = invalidations.getKindSet(kind);
                HashMap<Serializable, HashSet<String>> res = new HashMap<Serializable, HashSet<String>>();
                for (RowId rowId : rowIds) {
                    HashSet<String> tableNames = (HashSet<String>)res.get(rowId.id);
                    if (tableNames == null) {
                        tableNames = new HashSet<String>();
                        res.put(rowId.id, tableNames);
                    }
                    tableNames.add(rowId.tableName);
                }
                for (Map.Entry entry : res.entrySet()) {
                    Serializable id = (Serializable)entry.getKey();
                    String[] fragments = JDBCMapper.join((Collection)entry.getValue(), ' ');
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(sql, Arrays.asList(nodeId, id, fragments, Long.valueOf(kind)));
                    }
                    String[] frags = this.dialect.supportsArrays() && columns.get(2).getJdbcType() == 2003 ? fragments.split(" ") : fragments;
                    columns.get(0).setToPreparedStatement(ps, 1, nodeId);
                    columns.get(1).setToPreparedStatement(ps, 2, id);
                    columns.get(2).setToPreparedStatement(ps, 3, (Serializable)frags);
                    columns.get(3).setToPreparedStatement(ps, 4, Long.valueOf(kind));
                    ps.execute();
                    this.countExecute();
                }
                if (kind == 1) {
                    kind = 2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not invalidate", e);
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static final String join(Collection<String> strings, char sep) {
        if (strings.isEmpty()) {
            throw new RuntimeException();
        }
        if (strings.size() == 1) {
            return strings.iterator().next();
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (String word : strings) {
            buf.append(word);
            buf.append(sep);
        }
        buf.setLength(size - 1);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invalidations getClusterInvalidations(Serializable nodeId) throws StorageException {
        Invalidations invalidations = new Invalidations();
        String sql = this.dialect.getClusterGetInvalidations();
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Arrays.asList(nodeId));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ResultSet rs = null;
            try {
                this.setToPreparedStatement(ps, 1, nodeId);
                rs = ps.executeQuery();
                this.countExecute();
                while (rs.next()) {
                    Serializable id = columns.get(1).getFromResultSet(rs, 1);
                    Serializable frags = columns.get(2).getFromResultSet(rs, 2);
                    int kind = ((Long)columns.get(3).getFromResultSet(rs, 3)).intValue();
                    String[] fragments = this.dialect.supportsArrays() && frags instanceof String[] ? (String[])frags : ((String)((Object)frags)).split(" ");
                    invalidations.add(id, fragments, kind);
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(ps, rs);
                throw throwable;
            }
            this.closeStatement(ps, rs);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> " + invalidations);
            }
            if (this.dialect.isClusteringDeleteNeeded()) {
                this.deleteClusterInvals(nodeId);
            }
            return invalidations;
        }
        catch (Exception e) {
            this.checkConnectionReset(e, true);
            throw new StorageException("Could not invalidate", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable getRootId(String repositoryId) throws StorageException {
        String sql = this.sqlInfo.getSelectRootIdSql();
        try {
            ResultSet rs;
            PreparedStatement ps;
            block9: {
                Serializable serializable;
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Collections.singletonList(repositoryId));
                }
                ps = this.connection.prepareStatement(sql);
                rs = null;
                try {
                    ps.setString(1, repositoryId);
                    rs = ps.executeQuery();
                    this.countExecute();
                    if (rs.next()) break block9;
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> (none)");
                    }
                    serializable = null;
                }
                catch (Throwable throwable) {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                this.closeStatement(ps, rs);
                return serializable;
            }
            Column column = this.sqlInfo.getSelectRootIdWhatColumn();
            Serializable id = column.getFromResultSet(rs, 1);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> id=" + id);
            }
            if (rs.next()) {
                throw new StorageException("Row query for " + repositoryId + " returned several rows: " + sql);
            }
            Serializable serializable = id;
            this.closeStatement(ps, rs);
            return serializable;
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootId(Serializable repositoryId, Serializable id) throws StorageException {
        String sql = this.sqlInfo.getInsertRootIdSql();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                List<Column> columns = this.sqlInfo.getInsertRootIdColumns();
                ArrayList<Serializable> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(2);
                }
                int i = 0;
                for (Column column : columns) {
                    Serializable v;
                    ++i;
                    String key = column.getKey();
                    if (key.equals("id")) {
                        v = id;
                    } else if (key.equals("name")) {
                        v = repositoryId;
                    } else {
                        throw new RuntimeException(key);
                    }
                    column.setToPreparedStatement(ps, i, v);
                    if (debugValues == null) continue;
                    debugValues.add(v);
                }
                if (debugValues != null) {
                    this.logger.logSQL(sql, debugValues);
                    debugValues.clear();
                }
                ps.execute();
                this.countExecute();
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not insert: " + sql, e);
        }
    }

    protected QueryMaker findQueryMaker(String queryType) throws StorageException {
        for (Class<? extends QueryMaker> klass : this.queryMakerService.getQueryMakers()) {
            QueryMaker queryMaker;
            try {
                queryMaker = klass.newInstance();
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            if (!queryMaker.accepts(queryType)) continue;
            return queryMaker;
        }
        return null;
    }

    protected void prepareUserReadAcls(QueryFilter queryFilter) throws StorageException {
        String sql = this.dialect.getPrepareUserReadAclsSql();
        Object principals = queryFilter.getPrincipals();
        if (sql == null || principals == null) {
            return;
        }
        if (!this.dialect.supportsArrays()) {
            principals = StringUtils.join((Object[])principals, (String)"|");
        }
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singleton(principals));
            }
            this.setToPreparedStatement(ps, 1, (Serializable)principals);
            ps.execute();
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to prepare user read acl cache", e);
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.query(query, queryType, queryFilter, countTotal ? -1L : 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws StorageException {
        PartialList<Serializable> partialList;
        String sql;
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new StorageException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, this.pathResolver, query, queryFilter, new Object[0]);
        if (q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            return new PartialList<Serializable>(Collections.emptyList(), 0L);
        }
        long limit = queryFilter.getLimit();
        long offset = queryFilter.getOffset();
        if (this.logger.isLogEnabled()) {
            sql = q.selectInfo.sql;
            if (limit != 0L) {
                sql = sql + " -- LIMIT " + limit + " OFFSET " + offset;
            }
            if (countUpTo != 0L) {
                sql = sql + " -- COUNT TOTAL UP TO " + countUpTo;
            }
            this.logger.logSQL(sql, q.selectParams);
        }
        sql = q.selectInfo.sql;
        if (countUpTo == 0L && limit > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, limit, offset);
            limit = 0L;
            offset = 0L;
        } else if (countUpTo > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, Math.max(countUpTo + 1L, limit + offset), 0L);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean available;
            ps = this.connection.prepareStatement(sql, 1004, 1007);
            int i = 1;
            for (Serializable object : q.selectParams) {
                this.setToPreparedStatement(ps, i++, object);
            }
            rs = ps.executeQuery();
            this.countExecute();
            long totalSize = -1L;
            if (limit == 0L || offset == 0L) {
                available = rs.first();
                if (!available) {
                    totalSize = 0L;
                }
                if (limit == 0L) {
                    limit = -1L;
                }
            } else {
                available = rs.absolute((int)offset + 1);
            }
            Column column = q.selectInfo.whatColumns.get(0);
            LinkedList<Serializable> ids = new LinkedList<Serializable>();
            int rowNum = 0;
            while (available && limit != 0L) {
                Serializable id;
                try {
                    id = column.getFromResultSet(rs, 1);
                }
                catch (SQLDataException e) {
                    available = false;
                    break;
                }
                ids.add(id);
                rowNum = rs.getRow();
                available = rs.next();
                --limit;
            }
            if (countUpTo != 0L && totalSize == -1L) {
                if (!available && rowNum != 0) {
                    totalSize = rowNum;
                } else {
                    rs.last();
                    totalSize = rs.getRow();
                }
                if (countUpTo > 0L && totalSize > countUpTo) {
                    totalSize = -2L;
                }
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(ids, countUpTo != 0L, totalSize);
            }
            partialList = new PartialList<Serializable>(ids, totalSize);
        }
        catch (Exception e) {
            try {
                this.checkConnectionReset(e);
                throw new StorageException("Invalid query: " + query, e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)"Cannot close connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(ps, rs);
            return partialList;
        }
        catch (SQLException e) {
            log.error((Object)"Cannot close connection", (Throwable)e);
        }
        return partialList;
    }

    public int setToPreparedStatement(PreparedStatement ps, int i, Serializable object) throws SQLException {
        if (object instanceof Calendar) {
            this.dialect.setToPreparedStatementTimestamp(ps, i, (Serializable)object, null);
        } else if (object instanceof Date) {
            ps.setDate(i, (Date)object);
        } else if (object instanceof Long) {
            ps.setLong(i, (Long)object);
        } else if (object instanceof ColumnType.WrappedId) {
            this.dialect.setId(ps, i, (Serializable)((Object)object.toString()));
        } else if (object instanceof Object[]) {
            int jdbcType;
            if (object instanceof String[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.STRING).jdbcType;
            } else if (object instanceof Boolean[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.BOOLEAN).jdbcType;
            } else if (object instanceof Long[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.LONG).jdbcType;
            } else if (object instanceof Double[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.DOUBLE).jdbcType;
            } else if (object instanceof Date[]) {
                jdbcType = 91;
            } else if (object instanceof Clob[]) {
                jdbcType = 2005;
            } else if (object instanceof Calendar[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.TIMESTAMP).jdbcType;
                object = this.dialect.getTimestampFromCalendar((Calendar[])object);
            } else {
                jdbcType = object instanceof Integer[] ? this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.INTEGER).jdbcType : this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.CLOB).jdbcType;
            }
            Array array = this.dialect.createArrayOf(jdbcType, object, this.connection);
            ps.setArray(i, array);
        } else {
            ps.setObject(i, object);
        }
        return i;
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new StorageException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        try {
            return new ResultSetQueryResult(queryMaker, query, queryFilter, this.pathResolver, this, params);
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Invalid query: " + queryType + ": " + query, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Serializable> getAncestorsIds(Collection<Serializable> ids) throws StorageException {
        HashSet<Serializable> hashSet;
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectAncestorsIds();
        if (select == null) {
            return this.getAncestorsIdsIterative(ids);
        }
        Serializable whereIds = this.newIdArray(ids);
        HashSet<Serializable> res = new HashSet<Serializable>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(select.sql, Collections.singleton(whereIds));
            }
            Column what = select.whatColumns.get(0);
            ps = this.connection.prepareStatement(select.sql);
            this.setToPreparedStatementIdArray(ps, 1, whereIds);
            rs = ps.executeQuery();
            this.countExecute();
            LinkedList<Serializable> debugIds = null;
            if (this.logger.isLogEnabled()) {
                debugIds = new LinkedList<Serializable>();
            }
            while (rs.next()) {
                if (this.dialect.supportsArraysReturnInsteadOfRows()) {
                    Serializable[] resultIds;
                    for (Serializable id : resultIds = this.dialect.getArrayResult(rs.getArray(1))) {
                        if (id == null) continue;
                        res.add(id);
                        if (!this.logger.isLogEnabled()) continue;
                        debugIds.add(id);
                    }
                    continue;
                }
                Serializable id = what.getFromResultSet(rs, 1);
                if (id == null) continue;
                res.add(id);
                if (!this.logger.isLogEnabled()) continue;
                debugIds.add(id);
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(debugIds, false, 0L);
            }
            hashSet = res;
        }
        catch (Exception e) {
            try {
                this.checkConnectionReset(e);
                throw new StorageException("Failed to get ancestors ids", e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(ps, rs);
            return hashSet;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashSet;
    }

    protected Set<Serializable> getAncestorsIdsIterative(Collection<Serializable> ids) throws StorageException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<Serializable> todo = new LinkedList<Serializable>(ids);
            HashSet<Serializable> done = new HashSet<Serializable>();
            HashSet<Serializable> res = new HashSet<Serializable>();
            while (!todo.isEmpty()) {
                done.addAll(todo);
                SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectParentIds(todo.size());
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(select.sql, todo);
                }
                Column what = select.whatColumns.get(0);
                Column where = select.whereColumns.get(0);
                ps = this.connection.prepareStatement(select.sql);
                int i = 1;
                for (Serializable id : todo) {
                    where.setToPreparedStatement(ps, i++, id);
                }
                rs = ps.executeQuery();
                this.countExecute();
                todo = new LinkedList();
                LinkedList<Serializable> debugIds = null;
                if (this.logger.isLogEnabled()) {
                    debugIds = new LinkedList<Serializable>();
                }
                while (rs.next()) {
                    Serializable id;
                    id = what.getFromResultSet(rs, 1);
                    if (id == null) continue;
                    res.add(id);
                    if (!done.contains(id)) {
                        todo.add(id);
                    }
                    if (!this.logger.isLogEnabled()) continue;
                    debugIds.add(id);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logIds(debugIds, false, 0L);
                }
                rs.close();
                ps.close();
            }
            HashSet<Serializable> hashSet = res;
            return hashSet;
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to get ancestors ids", e);
        }
        finally {
            try {
                this.closeStatement(ps, rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void updateReadAcls() throws StorageException {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: updating");
        }
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getUpdateReadAclsSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql);
            }
            st.execute(sql);
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to update read acls", e);
        }
        finally {
            try {
                this.closeStatement(st);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: done.");
        }
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"rebuildReadAcls: rebuilding ...");
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getRebuildReadAclsSql();
            this.logger.log(sql);
            st.execute(sql);
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to rebuild read acls", e);
        }
        finally {
            try {
                this.closeStatement(st);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        log.debug((Object)"rebuildReadAcls: done.");
    }

    protected Connection connection(boolean autocommit) throws StorageException {
        this.checkConnectionValid();
        try {
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException e) {
            throw new StorageException("Cannot set auto commit mode onto " + this + "'s connection", e);
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock callInTransaction(Callable<Lock> callable, boolean tx) throws StorageException {
        boolean ok = false;
        this.checkConnectionValid();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("callInTransaction setAutoCommit " + !tx));
            }
            this.connection.setAutoCommit(!tx);
        }
        catch (SQLException e) {
            throw new StorageException("Cannot set auto commit mode onto " + this + "'s connection", e);
        }
        try {
            Lock result;
            try {
                result = callable.call();
            }
            catch (StorageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            ok = true;
            Lock lock = result;
            return lock;
        }
        finally {
            if (tx) {
                try {
                    try {
                        if (ok) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"callInTransaction commit");
                            }
                            this.connection.commit();
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"callInTransaction rollback");
                            }
                            this.connection.rollback();
                        }
                    }
                    finally {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"callInTransaction restoring autoCommit=true");
                        }
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
        }
    }

    @Override
    public Lock getLock(Serializable id) throws StorageException {
        Row row;
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("getLock " + id + " while autoCommit=" + this.connection.getAutoCommit()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        RowId rowId = new RowId("locks", id);
        try {
            row = this.readSimpleRow(rowId);
        }
        catch (ConnectionResetException e) {
            row = this.readSimpleRow(rowId);
        }
        return row == null ? null : new Lock((String)((Object)row.get("owner")), (Calendar)row.get("created"));
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setLock " + id + " owner=" + lock.getOwner()));
        }
        SetLock call = new SetLock(id, lock);
        return this.callInTransaction(call, this.clusteringEnabled);
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) throws StorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeLock " + id + " owner=" + owner + " force=" + force));
        }
        RemoveLock call = new RemoveLock(id, owner, force);
        return this.callInTransaction(call, !force);
    }

    @Override
    public void markReferencedBinaries(BinaryGarbageCollector gc) throws StorageException {
        log.debug((Object)"Starting binaries GC mark");
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.connection.createStatement();
            int i = -1;
            for (String sql : this.sqlInfo.getBinariesSql) {
                Column col = this.sqlInfo.getBinariesColumns.get(++i);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                rs = st.executeQuery(sql);
                this.countExecute();
                int n = 0;
                while (rs.next()) {
                    ++n;
                    String digest = (String)((Object)col.getFromResultSet(rs, 1));
                    if (digest == null) continue;
                    gc.mark(digest);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logCount(n);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new RuntimeException("Failed to mark binaries for gC", e);
        }
        finally {
            try {
                this.closeStatement(st, rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        log.debug((Object)"End of binaries GC mark");
    }

    protected static String systemToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.checkConnectionValid();
            this.xaresource.start(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA start on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (StorageException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
        catch (XAException e) {
            this.checkConnectionReset(e);
            this.logger.error("XA start error on " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA end on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NullPointerException e) {
            this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            if (flags != 0x20000000) {
                this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            }
            throw e;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaresource.prepare(xid);
        }
        catch (XAException e) {
            this.logger.error("XA prepare error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaresource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.logger.error("XA commit error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public void connect() throws StorageException {
        this.openConnections();
    }

    @Override
    public void disconnect() {
        this.closeConnections();
    }

    protected class RemoveLock
    implements Callable<Lock> {
        protected final Serializable id;
        protected final String owner;
        protected final boolean force;

        protected RemoveLock(Serializable id, String owner, boolean force) {
            this.id = id;
            this.owner = owner;
            this.force = force;
        }

        @Override
        public Lock call() throws StorageException {
            Lock oldLock;
            Lock lock = oldLock = this.force ? null : JDBCMapper.this.getLock(this.id);
            if (!this.force && this.owner != null) {
                if (oldLock == null) {
                    return null;
                }
                if (!JDBCMapper.this.repository.getLockManager().canLockBeRemoved(oldLock, this.owner)) {
                    return new Lock(oldLock, true);
                }
            }
            if (this.force || oldLock != null) {
                JDBCMapper.this.deleteRows("locks", Collections.singleton(this.id));
            }
            return oldLock;
        }
    }

    protected class SetLock
    implements Callable<Lock> {
        protected final Serializable id;
        protected final Lock lock;

        protected SetLock(Serializable id, Lock lock) {
            this.id = id;
            this.lock = lock;
        }

        @Override
        public Lock call() throws StorageException {
            Lock oldLock = JDBCMapper.this.getLock(this.id);
            if (oldLock == null) {
                Row row = new Row("locks", this.id);
                row.put("owner", (Serializable)((Object)this.lock.getOwner()));
                row.put("created", this.lock.getCreated());
                JDBCMapper.this.insertSimpleRows("locks", Collections.singletonList(row));
            }
            return oldLock;
        }
    }
}

