/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectDerby
extends Dialect {
    private final String derbyFunctions = "org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions";

    public DialectDerby(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectDerby.jdbcInfo("VARCHAR(32672)", 12);
                }
                if (type.isClob()) {
                    return DialectDerby.jdbcInfo("CLOB", 2005);
                }
                return DialectDerby.jdbcInfo("VARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectDerby.jdbcInfo("SMALLINT", 5);
            }
            case LONG: {
                return DialectDerby.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectDerby.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return DialectDerby.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectDerby.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectDerby.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectDerby.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return DialectDerby.jdbcInfo("SMALLINT", -6);
            }
            case INTEGER: {
                return DialectDerby.jdbcInfo("INTEGER", 4);
            }
            case AUTOINC: {
                return DialectDerby.jdbcInfo("INTEGER GENERATED BY DEFAULT AS IDENTITY", 4);
            }
            case FTINDEXED: {
                return DialectDerby.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return DialectDerby.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectDerby.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return DialectDerby.jdbcInfo("VARCHAR(4000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case 5: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 5: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 0;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        return query;
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String colFmt;
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext");
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String ftColumnName = ftColumn.getFullQuotedName();
        if (ftColumn.getJdbcType() == 2005 && (colFmt = this.getClobCast(false)) != null) {
            ftColumnName = String.format(colFmt, ftColumnName, 255);
        }
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>(1);
        if (nthMatch == 1) {
            info.joins.add(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.whereExpr = String.format("NX_CONTAINS(%s, ?) = 1", ftColumnName);
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = "1";
        info.scoreAlias = "NXSCORE" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS VARCHAR(%d))";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/derby.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/derby.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR(36)"));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextSearchEnabled", Boolean.valueOf(!this.fulltextSearchDisabled));
        properties.put("derbyFunctions", (Serializable)((Object)"org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions"));
        properties.put("noSemicolon", Boolean.TRUE);
        return properties;
    }

    @Override
    public String getValidationQuery() {
        return "VALUES 1";
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return sql + String.format(" OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        while (t != null) {
            if (t instanceof SQLException) {
                String sqlState = ((SQLException)t).getSQLState();
                if ("23503".equals(sqlState)) {
                    return true;
                }
                if ("40001".equals(sqlState)) {
                    return true;
                }
            }
            t = t.getCause();
        }
        return false;
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

