/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.file.versioning;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;

public class FileVersioningService
extends StandardVersioningService {
    public static final String APPLY_OTTC_FILE_VERSIONING = "applyOttcFileVersioning";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) throws DocumentException {
        if (this.doApplyFileVersioning(doc, options)) {
            try {
                this.incrementByOption(doc, VersioningOption.MINOR);
                Document document = doc.checkIn(null, checkinComment);
                return document;
            }
            finally {
                options.remove(APPLY_OTTC_FILE_VERSIONING);
            }
        }
        return super.doPostSave(doc, option, checkinComment, options);
    }

    protected boolean doApplyFileVersioning(Document doc, Map<String, Serializable> options) throws DocumentException {
        return doc.isCheckedOut() && BooleanUtils.isTrue((Boolean)((Boolean)options.get(APPLY_OTTC_FILE_VERSIONING)));
    }

    protected DocumentModel readModel(Document doc) throws ClientException {
        try {
            String[] fileSchema = new String[]{"file"};
            return DocumentModelFactory.createDocumentModel((Document)doc, (String[])fileSchema);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }
}

