/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.comments;

import fr.toutatice.ecm.platform.automation.blob.BlobHelper;
import fr.toutatice.ecm.platform.automation.comments.CommentType;
import java.security.Principal;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.platform.comment.workflow.utils.FollowTransitionUnrestricted;

public abstract class AbstractCommentOperation {
    public DocumentModel execute(CoreSession session, DocumentModel document, DocumentModel parent, String content, String author, Date creationDate, String title, BlobList blobs) {
        Boolean moderated;
        CommentableDocument commentableDocument = (CommentableDocument)document.getAdapter(CommentableDocument.class);
        CommentType commentType = CommentType.fromParentType(document.getType());
        String schema = commentType.getSchema();
        if (StringUtils.isEmpty((String)author)) {
            Principal principal = session.getPrincipal();
            if (principal == null) {
                throw new ClientException("No author for comment.");
            }
            author = principal.getName();
        }
        if (creationDate == null) {
            creationDate = new Date();
        }
        DocumentModel comment = session.createDocumentModel(commentType.getType());
        comment.setProperty(schema, "text", (Object)content);
        comment.setProperty(schema, "author", (Object)author);
        comment.setProperty(schema, "creationDate", (Object)creationDate);
        if (CommentType.POST.equals((Object)commentType)) {
            comment.setProperty(schema, "title", (Object)StringUtils.trimToEmpty((String)title));
            comment = BlobHelper.setBlobs(comment, blobs);
        }
        comment = parent == null ? commentableDocument.addComment(comment) : commentableDocument.addComment(parent, comment);
        if (CommentType.POST.equals((Object)commentType) && BooleanUtils.isNotTrue((Boolean)(moderated = (Boolean)document.getProperty(schema, "moderated")))) {
            FollowTransitionUnrestricted transition = new FollowTransitionUnrestricted(session, comment.getRef(), "moderation_publish");
            transition.runUnrestricted();
        }
        return comment;
    }
}

