/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.massvalidation;

import com.osivia.cns.proto.massvalidation.DocumentToModifyDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="massValidation")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=132)
public class MassValidationBean {
    private static final String MASS_VALIDATION_EVENT = "massValidationEvent";
    private static final String PV_MASS_VALIDATION_CHOOSE = "mass_validation";
    private static final String PV_MASS_VALIDATION = "mass_validation_2";
    private static final String PV_MASS_VALIDATION_CONFIRM = "mass_validation_3";
    private static final String PV_MASS_VAL_CHOOSE_DOCS = "mass_validation_choose_docs";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    private Map<String, Serializable> propertiesToModify;
    private Boolean withValidation = null;
    private List<DocumentToModifyDTO> docsToModify = new ArrayList<DocumentToModifyDTO>();

    public Integer getNbDocToModify() {
        Integer nbDocToModify = 0;
        for (DocumentToModifyDTO d : this.docsToModify) {
            if (!d.getApplyModifications().booleanValue()) continue;
            Integer n = nbDocToModify;
            Integer n2 = nbDocToModify = Integer.valueOf(nbDocToModify + 1);
        }
        return nbDocToModify;
    }

    public List<DocumentToModifyDTO> getDocsToModify() {
        return this.docsToModify;
    }

    public void setDocsToModify(List<DocumentToModifyDTO> docsToModify) {
        this.docsToModify = docsToModify;
    }

    public Boolean getWithValidation() {
        return this.withValidation;
    }

    public void setWithValidation(Boolean withValidation) {
        this.withValidation = withValidation;
    }

    public String goToChooseValidation() {
        return PV_MASS_VALIDATION_CHOOSE;
    }

    public String goToChooseDocs() {
        this.docsToModify.clear();
        DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
        DocumentModelList docs = this.documentManager.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + currentFolder.getPathAsString() + "' AND ecm:mixinType <> 'Folderish'" + " AND ecm:isVersion = 0 AND ecm:mixinType != 'HiddenInNavigation' AND ecm:currentLifeCycleState != 'deleted'  ORDER BY ecm:path");
        DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        for (DocumentModel child : docs) {
            DocumentToModifyDTO d = new DocumentToModifyDTO();
            d.setDoc(child);
            if (!child.getCurrentLifeCycleState().equals("project")) {
                d.setAvaliable(DocumentToModifyDTO.DocumentToModifyState.VALIDATED);
                d.setApplyModifications(false);
            } else if (routingService.getDocumentRoutesForAttachedDocument(this.documentManager, child.getId()).size() > 0) {
                d.setAvaliable(DocumentToModifyDTO.DocumentToModifyState.IN_WORKFLOW);
                d.setApplyModifications(false);
            } else {
                d.setAvaliable(DocumentToModifyDTO.DocumentToModifyState.AVALIABLE);
            }
            DocumentModel parent = this.documentManager.getDocument(child.getParentRef());
            String parentTitle = "";
            while (parent != null && !parent.getId().equals(currentFolder.getId())) {
                parentTitle = parent.getTitle() + " >> " + parentTitle;
                parent = this.documentManager.getDocument(parent.getParentRef());
            }
            d.setParentTitle(parentTitle);
            this.docsToModify.add(d);
        }
        return PV_MASS_VAL_CHOOSE_DOCS;
    }

    public String goToStartValidation() {
        return PV_MASS_VALIDATION;
    }

    public String backToChoose() {
        return PV_MASS_VALIDATION_CHOOSE;
    }

    public String validate() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        this.propertiesToModify = new HashMap<String, Serializable>();
        this.propertiesToModify.put("cns:cycle_vie", doc.getPropertyValue("cns:cycle_vie"));
        this.propertiesToModify.put("dc:subjects", doc.getPropertyValue("dc:subjects"));
        this.propertiesToModify.put("dc:nature", doc.getPropertyValue("dc:nature"));
        this.propertiesToModify.put("cns:s_info_associe", doc.getPropertyValue("cns:s_info_associe"));
        this.propertiesToModify.put("dc:source", doc.getPropertyValue("dc:source"));
        return PV_MASS_VALIDATION_CONFIRM;
    }

    public String confirmValidate() {
        EventProducer eventProducer;
        try {
            eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            return PV_MASS_VALIDATION_CONFIRM;
        }
        DocumentModelListImpl listToModify = new DocumentModelListImpl();
        for (DocumentToModifyDTO d : this.docsToModify) {
            if (!d.getApplyModifications().booleanValue()) continue;
            listToModify.add((Object)d.getDoc());
        }
        EventContextImpl ctx = new EventContextImpl(this.documentManager, this.documentManager.getPrincipal(), new Object[]{listToModify});
        ctx.setProperties(this.propertiesToModify);
        ctx.setProperty("withValidation", (Serializable)this.withValidation);
        Event event = ctx.newEvent(MASS_VALIDATION_EVENT);
        try {
            eventProducer.fireEvent(event);
        }
        catch (ClientException e) {
            return PV_MASS_VALIDATION_CONFIRM;
        }
        return "done";
    }
}

