/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.publish;

import fr.toutatice.ecm.platform.web.publication.ToutaticePublishActionsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationTreeNotAvailable;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;

@Name(value="publishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=132)
public class CNSPublishActionsBean
extends ToutaticePublishActionsBean {
    private static final long serialVersionUID = -4846952536986036993L;
    private static final Log log = LogFactory.getLog(CNSPublishActionsBean.class);

    public boolean canPublishTo(PublicationNode publicationNode) throws ClientException {
        boolean canPublish = super.canPublishTo(publicationNode);
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (!canPublish) {
            Lock lock = this.documentManager.getLockInfo(doc.getRef());
            boolean bl = canPublish = lock != null;
        }
        if (canPublish && "approved".equals(doc.getCurrentLifeCycleState())) {
            PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
            canPublish = tree != null ? tree.canPublishTo(publicationNode) : false;
        }
        return canPublish;
    }

    public boolean canRepublish(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if ("approved".equals(doc.getCurrentLifeCycleState())) {
            if (!this.canUnpublish(publishedDocument)) {
                return false;
            }
            if (!publishedDocument.getSourceVersionLabel().equals(doc.getVersionLabel())) {
                return true;
            }
            if (doc.isDirty()) {
                return true;
            }
        }
        return false;
    }

    protected List<String> filterEmptyTrees(Collection<String> trees) throws PublicationTreeNotAvailable, ClientException {
        ArrayList<String> filteredTrees = new ArrayList<String>();
        for (String tree : trees) {
            try {
                PublicationTree pTree = this.publisherService.getPublicationTree(tree, this.documentManager, null, this.navigationContext.getCurrentDocument());
                if (pTree == null) continue;
                if (pTree.getTreeType().equals("CNSRootSectionsPublicationTree")) {
                    if (pTree.getChildrenNodes().size() <= 0) continue;
                    filteredTrees.add(tree);
                    continue;
                }
                filteredTrees.add(tree);
            }
            catch (PublicationTreeNotAvailable e) {
                log.warn((Object)("Publication tree " + tree + " is not available : check config"));
                log.debug((Object)("Publication tree " + tree + " is not available : root cause is "), (Throwable)e);
            }
        }
        return filteredTrees;
    }
}

