/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.security;

import java.security.Principal;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;
import org.nuxeo.runtime.api.Framework;

public class CnsDomainSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(CnsDomainSecurityPolicy.class);
    private static final String RESTRICTED_DOMAIN_NAME = Framework.getProperty((String)"cns.domainSecurity.restrictedDomain", (String)"ged-cns");
    private static final String ALLOWED_PROFILE = Framework.getProperty((String)"cns.domainSecurity.allowedProfiles", (String)"CNS_commun-cns");
    private static final SQLQuery.Transformer CNS_RESTRICTED_DOMAIN_TRANSFORMER = new CnsDomainSecurityTransformer();

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        try {
            if (CnsDomainSecurityPolicy.doPolicyApply(doc)) {
                access = this.restrictToProfile(doc, principal, additionalPrincipals);
            }
        }
        catch (DocumentException e) {
            log.error((Object)("Failed to evaluate the policy, error: " + e.getMessage()));
        }
        return access;
    }

    private Access restrictToProfile(Document doc, Principal principal, String[] additionalPrincipals) {
        String[] allPrincipals;
        String[] stringArray = allPrincipals = principal != null ? (String[])ArrayUtils.add((Object[])additionalPrincipals, (Object)principal.getName()) : additionalPrincipals;
        if (this.hasAllowedProfile(allPrincipals)) {
            return Access.UNKNOWN;
        }
        return Access.DENY;
    }

    private boolean hasAllowedProfile(String[] allPrincipals) {
        for (String principal : allPrincipals) {
            if (!StringUtils.equals((String)principal, (String)ALLOWED_PROFILE)) continue;
            return true;
        }
        return false;
    }

    private static boolean doPolicyApply(Document doc) throws DocumentException {
        return CnsDomainSecurityPolicy.docIsInRestrictedDomain(doc);
    }

    private static boolean docIsInRestrictedDomain(Document doc) throws DocumentException {
        String domainName = null;
        String path = doc.getPath();
        if (StringUtils.isNotBlank((String)(path = StringUtils.removeStart((String)path, (String)"/")))) {
            domainName = StringUtils.split((String)path, (char)'/')[0];
        }
        return StringUtils.equals(domainName, (String)RESTRICTED_DOMAIN_NAME);
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return CNS_RESTRICTED_DOMAIN_TRANSFORMER;
    }

    static /* synthetic */ String access$000() {
        return RESTRICTED_DOMAIN_NAME;
    }

    public static class CnsDomainSecurityTransformer
    implements SQLQuery.Transformer {
        private static final long serialVersionUID = 1L;
        private static final String TTC_DOMAINID = "ttc:domainID";
        private static final Predicate NOT_IN_DOMAIN = new Predicate((Operand)new Reference("ttc:domainID"), Operator.NOTEQ, (Operand)new StringLiteral(CnsDomainSecurityPolicy.access$000()));

        private boolean hasAllowedProfile(List<String> allGroups) {
            for (String principal : allGroups) {
                if (!StringUtils.equals((String)principal, (String)ALLOWED_PROFILE)) continue;
                return true;
            }
            return false;
        }

        public SQLQuery transform(Principal principal, SQLQuery query) {
            List allGroups;
            NuxeoPrincipal nuxeoPrincipal = (NuxeoPrincipal)principal;
            if (!(nuxeoPrincipal.isAdministrator() || StringUtils.equals((String)principal.getName(), (String)"system") || this.hasAllowedProfile(allGroups = nuxeoPrincipal.getAllGroups()))) {
                WhereClause where = query.where;
                Predicate predicate = where == null || where.predicate == null ? NOT_IN_DOMAIN : new Predicate((Operand)NOT_IN_DOMAIN, Operator.AND, (Operand)where.predicate);
                query = new SQLQuery(query.select, query.from, new WhereClause(predicate), query.groupBy, query.having, query.orderBy, query.limit, query.offset);
            }
            return query;
        }
    }
}

