/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.impl;

import java.util.List;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.impl.WSSBackendAdapter;
import org.nuxeo.wss.impl.WSSFakeBackend;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.Site;

public class WSSVirtualBackendAdapter
extends WSSBackendAdapter {
    private String urlRoot;

    public WSSVirtualBackendAdapter(Backend backend, String virtualRoot) {
        super(backend, virtualRoot);
        this.urlRoot = virtualRoot + backend.getRootUrl();
    }

    @Override
    public boolean exists(String location) {
        return this.getBackend(location).exists(location);
    }

    @Override
    public WSSListItem getItem(String location) throws WSSException {
        return this.getBackend(location).getItem(location);
    }

    @Override
    public List<WSSListItem> listItems(String location) throws WSSException {
        return this.getBackend(location).listItems(location);
    }

    @Override
    public void begin() throws WSSException {
    }

    @Override
    public void saveChanges() throws WSSException {
        super.saveChanges();
    }

    @Override
    public WSSListItem moveItem(String location, String destination) throws WSSException {
        return this.getBackend(location).moveItem(location, destination);
    }

    @Override
    public void removeItem(String location) throws WSSException {
        this.getBackend(location).removeItem(location);
    }

    @Override
    public WSSListItem createFolder(String parentPath, String name) throws WSSException {
        return this.getBackend(parentPath).createFolder(parentPath, name);
    }

    @Override
    public WSSListItem createFileItem(String parentPath, String name) throws WSSException {
        return this.getBackend(parentPath).createFileItem(parentPath, name);
    }

    @Override
    public DWSMetaData getMetaData(String location, WSSRequest wssRequest) throws WSSException {
        return this.getBackend(location).getMetaData(location, wssRequest);
    }

    @Override
    public Site getSite(String location) throws WSSException {
        return this.getBackend(location).getSite(location);
    }

    protected WSSBackend getBackend(String location) {
        Backend backend = this.backend.getBackend(this.cleanLocation(location));
        if (backend == null) {
            return new WSSFakeBackend();
        }
        return new WSSBackendAdapter(backend, this.virtualRoot);
    }
}

