/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class JavaIntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public JavaIntegerSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.1.0.4");
    }

    protected JavaIntegerSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!StringTools.isDigit(c)) {
                return false;
            }
            if (c == '0') {
                return strValue.length() <= 1;
            }
        }
        if (!StringTools.isDigit(strValue, pos)) {
            return false;
        }
        if (StringTools.isCharASCII(strValue, pos, '0')) {
            return false;
        }
        ++pos;
        while (StringTools.isDigit(strValue, pos)) {
            ++pos;
        }
        if (pos != strValue.length()) {
            return false;
        }
        try {
            Integer.valueOf(strValue);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

