/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.AsyncCallback;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultOperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.util.MultipartInput;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class DefaultSession
implements Session {
    protected final AbstractAutomationClient client;
    protected final Connector connector;
    protected final LoginInfo login;
    protected String defaultSchemas = null;

    public DefaultSession(AbstractAutomationClient client, Connector connector, LoginInfo login) {
        this.client = client;
        this.connector = connector;
        this.login = login;
    }

    @Override
    public AutomationClient getClient() {
        return this.client;
    }

    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public LoginInfo getLogin() {
        return this.login;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return this.client.getAdapter(this, type);
    }

    @Override
    public String getDefaultSchemas() {
        return this.defaultSchemas;
    }

    @Override
    public void setDefaultSchemas(String defaultSchemas) {
        this.defaultSchemas = defaultSchemas;
    }

    @Override
    public Object execute(OperationRequest request) throws Exception {
        Request req;
        String ctype;
        String content = JsonMarshalling.writeRequest(request);
        Object input = request.getInput();
        if (input instanceof OperationInput && ((OperationInput)input).isBinary()) {
            MultipartInput mpinput = new MultipartInput();
            mpinput.setRequest(content);
            ctype = mpinput.getContentType();
            if (input instanceof Blob) {
                Blob blob = (Blob)input;
                mpinput.setBlob(blob);
            } else if (input instanceof Blobs) {
                mpinput.setBlobs((Blobs)input);
            } else {
                throw new IllegalArgumentException("Unsupported binary input object: " + input);
            }
            req = new Request(1, request.getUrl(), mpinput);
        } else {
            req = new Request(1, request.getUrl(), content);
            ctype = "application/json+nxrequest";
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            req.put(entry.getKey(), entry.getValue());
        }
        req.put("Accept", "application/json+nxentity, */*");
        req.put("Content-Type", ctype);
        if (req.get("X-NXDocumentProperties") == null && this.defaultSchemas != null) {
            req.put("X-NXDocumentProperties", this.defaultSchemas);
        }
        return this.connector.execute(req);
    }

    @Override
    public void execute(final OperationRequest request, final AsyncCallback<Object> cb) {
        this.client.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.execute(request));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public Blob getFile(String path) throws Exception {
        Request req = new Request(0, path);
        return (Blob)this.connector.execute(req);
    }

    @Override
    public Blobs getFiles(String path) throws Exception {
        Request req = new Request(0, this.client.getBaseUrl() + path);
        return (Blobs)this.connector.execute(req);
    }

    @Override
    public void getFile(final String path, final AsyncCallback<Blob> cb) throws Exception {
        this.client.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.getFile(path));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public void getFiles(final String path, final AsyncCallback<Blobs> cb) throws Exception {
        this.client.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.getFiles(path));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public OperationRequest newRequest(String id) throws Exception {
        return this.newRequest(id, new HashMap<String, Object>());
    }

    @Override
    public OperationRequest newRequest(String id, Map<String, Object> ctx) throws Exception {
        OperationDocumentation op = this.getOperation(id);
        if (op == null) {
            throw new IllegalArgumentException("No such operation: " + id);
        }
        return new DefaultOperationRequest(this, op, ctx);
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        return this.client.getRegistry().getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        return this.client.getRegistry().getOperations();
    }

    @Override
    public void close() {
    }
}

