/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import fr.gouv.education.tribu.api.model.AbstractResponse;
import fr.gouv.education.tribu.api.model.TribuApiResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;

public abstract class AbstractWsController {
    protected static final Log LOGGER = LogFactory.getLog((String)"tribu.api");
    protected static final Log STK_LOGGER = LogFactory.getLog((String)"tribu.api-stacktraces");
    protected static final String LOG_SEPARATOR = " ";
    @Autowired
    protected ApplicationContext context;

    protected ResponseEntity<String> logAndReturn(AbstractResponse result, String query, String user, Long startTime, ContentErrorCode error, Object ... args) {
        if (result != null) {
            if (result.getContents() != null && result.getContents().isEmpty()) {
                error = ContentErrorCode.WARN_NO_DATA;
            }
        } else {
            result = new TribuApiResponse(null);
        }
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        String logMsg = this.formatLog(query, user, startTime, Long.valueOf(elapsedTime), error, args);
        if (error.getLevel() == LogLevel.ERROR) {
            result.setTicket(startTime.toString());
            LOGGER.error((Object)logMsg);
        } else if (error.getLevel() == LogLevel.WARN) {
            LOGGER.warn((Object)logMsg);
        } else if (error.getLevel() == LogLevel.INFO) {
            LOGGER.info((Object)logMsg);
        } else if (error.getLevel() == LogLevel.DEBUG) {
            LOGGER.debug((Object)logMsg);
        }
        ObjectMapper mapper = new ObjectMapper();
        result.setElapsedTime(Long.valueOf(elapsedTime));
        result.setCode(error.getCode());
        String message = error.getMessage();
        if (args.length > 0) {
            message = String.format(error.getMessage(), args);
        }
        result.setMessage(message);
        try {
            String resultStr = mapper.writeValueAsString((Object)result);
            return new ResponseEntity((Object)resultStr, error.getStatus());
        }
        catch (JsonProcessingException e) {
            return this.logStackAndReturn((Exception)((Object)e), query, user, startTime, ContentErrorCode.ERROR_TECH, new Object[0]);
        }
    }

    protected ResponseEntity<String> logStackAndReturn(Exception e, String query, String user, Long startTime, ContentErrorCode error, Object ... args) {
        ResponseEntity retStr = this.logAndReturn(null, query, user, startTime, error, args);
        String logMsg = this.formatLog(query, user, startTime, null, error, args);
        STK_LOGGER.error((Object)logMsg, (Throwable)e);
        return retStr;
    }

    private String formatLog(String query, String user, Long startTime, Long elapsedTime, ContentErrorCode error, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(error.getCode());
        sb.append(LOG_SEPARATOR);
        sb.append(user);
        sb.append(LOG_SEPARATOR);
        sb.append(query);
        sb.append(LOG_SEPARATOR);
        sb.append(elapsedTime);
        sb.append(LOG_SEPARATOR);
        if (error.getLevel() == LogLevel.ERROR) {
            sb.append(startTime);
            sb.append(LOG_SEPARATOR);
        }
        StringBuilder sbErr = new StringBuilder();
        if (StringUtils.isNotBlank((String)error.getMessage())) {
            String message = error.getMessage();
            if (args.length > 0) {
                message = String.format(error.getMessage(), args);
            }
            sbErr.append(message);
            sbErr.append(LOG_SEPARATOR);
            sb.append((CharSequence)sbErr);
        }
        return sb.toString();
    }
}

