/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.controller;

import org.springframework.boot.logging.LogLevel;
import org.springframework.http.HttpStatus;

public enum ContentErrorCode {
    INFO_OK(LogLevel.INFO, "I01", null, HttpStatus.OK),
    WARN_NO_DATA(LogLevel.WARN, "W01", "Aucun document trouv\u00e9", HttpStatus.NO_CONTENT),
    WARN_WRONG_PARAMETER(LogLevel.WARN, "W02", "%s est requis", HttpStatus.BAD_REQUEST),
    WARN_APIKEY(LogLevel.WARN, "W03", "Cl\u00e9 API incorrecte", HttpStatus.FORBIDDEN),
    WARN_MISSING_APIKEY(LogLevel.WARN, "W04", "Header cl\u00e9 API manquant", HttpStatus.FORBIDDEN),
    WARN_BAD_TOKEN(LogLevel.WARN, "W05", "Demande t\u00e9l\u00e9chargement direct incorrcte ou expir\u00e9e", HttpStatus.FORBIDDEN),
    ERROR_BACKEND(LogLevel.ERROR, "E01", "Erreur d'acc\u00e8s aux donn\u00e9es", HttpStatus.INTERNAL_SERVER_ERROR),
    ERROR_TECH(LogLevel.ERROR, "E02", "Erreur interne", HttpStatus.INTERNAL_SERVER_ERROR);

    private final LogLevel level;
    private final String message;
    private final String code;
    private final HttpStatus status;

    private ContentErrorCode(LogLevel level, String code, String message, HttpStatus status) {
        this.level = level;
        this.code = code;
        this.message = message;
        this.status = status;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public HttpStatus getStatus() {
        return this.status;
    }
}

