/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.controller;

import fr.gouv.education.tribu.api.controller.AbstractWsController;
import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import fr.gouv.education.tribu.api.controller.binaries.BytesRange;
import fr.gouv.education.tribu.api.controller.binaries.ConstrainedInputStream;
import fr.gouv.education.tribu.api.model.BinaryContent;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.service.ContentService;
import fr.gouv.education.tribu.api.service.token.DownloadToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/directdownload"})
@Api(value="Download")
public class DownloadController
extends AbstractWsController {
    private static final String DD = "/directdownload";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    @Autowired
    private ContentService contentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="T\u00e9l\u00e9chargmeent direct")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=204, message="Aucun r\u00e9sultat"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=403, message="Non autoris\u00e9"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=500, message="Erreur interne")})
    @RequestMapping(value={"/{uuid}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getFile(@PathVariable(value="uuid") String uuid, @RequestParam(name="token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long startTime = System.currentTimeMillis();
        DownloadToken tokenObject = this.contentService.checkToken(uuid, token);
        if (token == null || tokenObject == null) {
            return this.logAndReturn(null, DD, token, Long.valueOf(startTime), ContentErrorCode.WARN_BAD_TOKEN, new Object[0]);
        }
        ServletOutputStream output = response.getOutputStream();
        String appId = tokenObject.getAppId();
        try {
            BinaryContent content = this.contentService.startDownload(uuid, appId);
            long lastModified = System.currentTimeMillis();
            response.setContentType(content.getMimeType());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + content.getFileName() + "\"");
            response.setHeader("Content-Length", String.valueOf(content.getCount()));
            response.setDateHeader("Last-Modified", lastModified);
            FileInputStream in = new FileInputStream(content.getTempFile());
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)output, 4096);
            try {
                byte[] b = new byte[4096];
                int i = -1;
                while ((i = ((InputStream)in).read(b)) != -1) {
                    out.write(b, 0, i);
                }
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
                IOUtils.closeQuietly((Closeable)out);
            }
        }
        catch (RepositoryException e) {
            return this.logAndReturn(null, DD, tokenObject.getUser() + "@" + tokenObject.getAppId(), Long.valueOf(startTime), ContentErrorCode.ERROR_BACKEND, new Object[0]);
        }
        return this.logAndReturn(null, DD, tokenObject.getUser() + "@" + tokenObject.getAppId(), Long.valueOf(startTime), ContentErrorCode.INFO_OK, new Object[0]);
    }

    private void stream(HttpServletRequest request, HttpServletResponse response, BinaryContent content, OutputStream output) throws IOException {
        long length = content.getCount();
        long lastModified = System.currentTimeMillis();
        String contentType = content.getMimeType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + content.getFileName() + "\"");
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            return;
        }
        BytesRange full = new BytesRange(0L, length - 1L, length);
        ArrayList<BytesRange> ranges = new ArrayList<BytesRange>();
        String range = request.getHeader("Range");
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                response.setHeader("Content-Range", "bytes */" + length);
                response.sendError(416);
                return;
            }
            if (ranges.isEmpty()) {
                for (String part : range.substring(6).split(",")) {
                    NumberUtils.toInt((String)StringUtils.substringBefore((String)part, (String)"-"), (int)-1);
                    long start = NumberUtils.toInt((String)StringUtils.substringBefore((String)part, (String)"-"), (int)-1);
                    long end = NumberUtils.toInt((String)StringUtils.substringAfter((String)part, (String)"-"), (int)-1);
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    } else if (end == -1L || end > length - 1L) {
                        end = length - 1L;
                    }
                    if (start > end) {
                        response.setHeader("Content-Range", "bytes */" + length);
                        response.sendError(416);
                        return;
                    }
                    ranges.add(new BytesRange(start, end, length));
                }
            }
        }
        response.reset();
        response.setBufferSize(8192);
        response.setDateHeader("Last-Modified", lastModified);
        if (range == null) {
            response.setContentType(contentType);
            response.setHeader("Content-Length", String.valueOf(content.getCount()));
            this.copy(content, output, 0L, content.getCount());
        } else {
            BytesRange r;
            response.setHeader("Accept-Ranges", "bytes");
            response.setStatus(206);
            if (ranges.isEmpty() || full.equals(ranges.get(0))) {
                r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.getStart() + "-" + r.getEnd() + "/" + r.getTotal());
                response.setHeader("Content-Length", String.valueOf(r.getLength()));
                this.copy(content, output, r.getStart(), r.getLength());
            } else if (ranges.size() == 1) {
                r = (BytesRange)ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.getStart() + "-" + r.getEnd() + "/" + r.getTotal());
                response.setHeader("Content-Length", String.valueOf(r.getLength()));
                this.copy(content, output, r.getStart(), r.getLength());
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                ServletOutputStream sos = (ServletOutputStream)output;
                for (BytesRange r2 : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r2.getStart() + "-" + r2.getEnd() + "/" + r2.getTotal());
                    this.copy(content, output, r2.getStart(), r2.getLength());
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(BinaryContent content, OutputStream output, long start, long length) throws IOException {
        InputStream input = content.getStream();
        try {
            int read;
            byte[] buffer = new byte[8192];
            if (start > 0L || length != content.getCount()) {
                input = new ConstrainedInputStream(input, length);
                input.skip(start);
            }
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)input);
        }
    }
}

