/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo;

import fr.gouv.education.tribu.api.model.ApiUser;
import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.NuxeoRepo;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.PortalSSOAuthInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NuxeoRepoImpl
implements NuxeoRepo {
    @Value(value="${nuxeo.secretKey}")
    private String secretKey;
    @Autowired
    @Qualifier(value="appMap")
    private Map<String, ApiUser> appMap;
    @Autowired
    private GenericObjectPool<HttpAutomationClient> pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(String appId, NuxeoCommand command) throws RepositoryException {
        HttpAutomationClient client = null;
        ApiUser user = (ApiUser)this.appMap.get(appId);
        String userId = user.getNuxeoUser();
        if (userId == null) {
            throw new RepositoryException("Unable to get a valid user for app " + appId);
        }
        try {
            client = (HttpAutomationClient)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to get a connection to nuxeo from the pool", e);
        }
        try {
            Object object;
            Session session;
            if (userId != null) {
                client.setRequestInterceptor((RequestInterceptor)new PortalSSOAuthInterceptor(this.secretKey, userId));
            }
            try {
                session = client.getSession();
            }
            catch (Exception e) {
                throw new RepositoryException("Unable to login with " + userId, e);
            }
            Object object2 = object = command.execute(session);
            return object2;
        }
        finally {
            this.pool.returnObject((Object)client);
        }
    }
}

