/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo.commands;

import fr.gouv.education.tribu.api.model.BinaryContent;
import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.StreamedSession;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.client.model.StreamBlob;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FileContentStreamCommand
implements NuxeoCommand {
    public static final String PDF_CONTENT = "pdf:content";
    public static final String PDF_CONVERSION_ERROR = "errorOnPdfConversion";
    Document document;
    String docPath;
    String fieldName;
    String timestamp;
    boolean streamingSupport = true;

    public FileContentStreamCommand(String docUuid) {
        this.docPath = docUuid;
        this.fieldName = "file:content";
    }

    public Object execute(Session session) throws RepositoryException {
        try {
            if (this.document == null) {
                this.document = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.docPath).execute();
            }
            String[] tokens = this.fieldName.split("/");
            boolean pdfConversion = false;
            if (PDF_CONTENT.equals(tokens[0])) {
                tokens[0] = "file:content";
                pdfConversion = true;
            }
            PropertyMap map = this.document.getProperties().getMap(tokens[0]);
            for (int i = 1; i < tokens.length; ++i) {
                map = map.getMap(tokens[i]);
            }
            String pathFile = map.getString("data");
            if (!pdfConversion && this.streamingSupport) {
                String url = pathFile;
                StreamBlob blob = (StreamBlob)((StreamedSession)session).getStreamedFile(url);
                BinaryContent content = new BinaryContent();
                String fileName = blob.getFileName();
                if (fileName == null || "null".equals(fileName)) {
                    fileName = this.document.getTitle();
                }
                Long fileSize = this.document.getProperties().getLong("common:size");
                content.setName(fileName);
                content.setFileSize(fileSize.longValue());
                content.setMimeType(blob.getMimeType());
                content.setStream(blob.getStream());
                content.setLongLiveSession(session);
                return content;
            }
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    public String getId() {
        String id = "FileContentCommand";
        id = this.document == null ? id + this.docPath : id + this.document;
        if (this.timestamp != null) {
            id = id + this.timestamp;
        }
        id = id + "/" + this.fieldName;
        return id;
    }
}

