/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo.commands;

import fr.gouv.education.tribu.api.model.SearchForm;
import fr.gouv.education.tribu.api.repo.NuxeoQueryCommand;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchCommand
extends NuxeoQueryCommand {
    private static final String BACKEND_DATE_PATTERN = "yyyy-MM-dd";
    private SearchForm search;
    private String workspacePath;

    public SearchCommand(SearchForm search, String workspacePath) {
        this.search = search;
        this.workspacePath = workspacePath;
    }

    protected StringBuilder getQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ");
        query.append(" ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
        query.append(" AND ecm:mixinType <> 'Folderish' ");
        query.append(" AND ecm:mixinType <> 'isLocalPublishLive'");
        if (StringUtils.isNotBlank((String)this.search.getFulltext())) {
            query.append(" AND ecm:fulltext ILIKE '%" + this.search.getFulltext() + "%' ");
        }
        if (StringUtils.isNotBlank((String)this.search.getTitle())) {
            query.append(" AND dc:title ILIKE '%" + this.search.getTitle() + "%' ");
        }
        if (StringUtils.isNotBlank((String)this.workspacePath)) {
            query.append(" AND ecm:path STARTSWITH '" + this.workspacePath + "' ");
        }
        if (this.search.getModificationBeginDate() != null && this.search.getModificationEndDate() != null) {
            String from = DateFormatUtils.format((Date)this.search.getModificationBeginDate(), (String)BACKEND_DATE_PATTERN);
            Date endDate = DateUtils.addDays((Date)this.search.getModificationEndDate(), (int)1);
            String to = DateFormatUtils.format((Date)endDate, (String)BACKEND_DATE_PATTERN);
            query.append(" AND (dc:modified BETWEEN DATE '");
            query.append(from);
            query.append("' AND DATE '");
            query.append(to);
            query.append("') ");
        }
        if (this.search.getSort() != null && StringUtils.isNotEmpty((String)this.search.getSort().getOrderBy())) {
            query.append("ORDER BY ");
            query.append(this.search.getSort().getOrderBy());
            if (BooleanUtils.isTrue((Boolean)this.search.getReversedSort())) {
                query.append(" DESC");
            } else {
                query.append(" ASC");
            }
        }
        return query;
    }

    protected String getDocumentProperties() {
        return "*";
    }
}

