/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.security;

import fr.gouv.education.tribu.api.security.APIKeyAuthFilter;
import fr.gouv.education.tribu.api.security.APIKeyAuthenticationManager;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration
@EnableWebSecurity
public class WsSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${tribu.api.key}")
    private String principalRequestValue;

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        APIKeyAuthFilter filter = new APIKeyAuthFilter("Authorization");
        filter.setAuthenticationManager((AuthenticationManager)new APIKeyAuthenticationManager(this.principalRequestValue));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)httpSecurity.antMatcher("/contents/**").csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilter((Filter)filter).authorizeRequests().anyRequest()).authenticated();
    }
}

