/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.service;

import fr.gouv.education.tribu.api.model.ApiUser;
import fr.gouv.education.tribu.api.model.BinaryContent;
import fr.gouv.education.tribu.api.model.ContentDto;
import fr.gouv.education.tribu.api.model.DownloadForm;
import fr.gouv.education.tribu.api.model.DownloadUrlResponse;
import fr.gouv.education.tribu.api.model.SearchContentDto;
import fr.gouv.education.tribu.api.model.SearchForm;
import fr.gouv.education.tribu.api.model.TribuApiResponse;
import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.NuxeoRepo;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.repo.commands.FileContentCommand;
import fr.gouv.education.tribu.api.repo.commands.GetDocumentCommand;
import fr.gouv.education.tribu.api.repo.commands.SearchCommand;
import fr.gouv.education.tribu.api.service.ContentService;
import fr.gouv.education.tribu.api.service.ContentServiceException;
import fr.gouv.education.tribu.api.service.token.DownloadToken;
import fr.gouv.education.tribu.api.service.token.DownloadTokenService;
import java.util.ArrayList;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ContentServiceImpl
implements ContentService {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private DownloadTokenService tokenService;
    @Autowired
    private NuxeoRepo repo;
    @Autowired
    @Qualifier(value="appMap")
    private Map<String, ApiUser> appMap;

    public TribuApiResponse search(SearchForm search) throws RepositoryException, ContentServiceException {
        ApiUser apiUser = (ApiUser)this.appMap.get(search.getAppId());
        NuxeoCommand command = (NuxeoCommand)this.context.getBean(SearchCommand.class, new Object[]{search, apiUser.getWorkspacePath()});
        PaginableDocuments searchResults = (PaginableDocuments)this.repo.executeCommand(search.getAppId(), command);
        ArrayList<SearchContentDto> docs = new ArrayList<SearchContentDto>();
        for (Document result : searchResults) {
            SearchContentDto dto = (SearchContentDto)this.toDto(result, "SearchContentDto");
            docs.add(dto);
        }
        TribuApiResponse response = new TribuApiResponse(docs);
        response.setCurrentPageIndex(Integer.valueOf(searchResults.getCurrentPageIndex()));
        response.setNumberOfPages(Integer.valueOf(searchResults.getNumberOfPages()));
        response.setResultsCount(Integer.valueOf(searchResults.getResultsCount()));
        response.setPageSize(Integer.valueOf(searchResults.getPageSize()));
        return response;
    }

    private ContentDto toDto(Document document, String compomentName) throws ContentServiceException {
        ContentDto dto = (ContentDto)this.context.getBean(compomentName);
        return dto.toDto(document);
    }

    public DownloadUrlResponse download(DownloadForm dlForm) throws RepositoryException, ContentServiceException {
        NuxeoCommand command = (NuxeoCommand)this.context.getBean(GetDocumentCommand.class, new Object[]{dlForm});
        PaginableDocuments searchResults = (PaginableDocuments)this.repo.executeCommand(dlForm.getAppId(), command);
        ArrayList<SearchContentDto> docs = new ArrayList<SearchContentDto>(1);
        for (Document result : searchResults) {
            SearchContentDto dto = (SearchContentDto)this.toDto(result, "SearchContentDto");
            docs.add(dto);
        }
        DownloadUrlResponse response = (DownloadUrlResponse)this.context.getBean(DownloadUrlResponse.class, new Object[]{docs});
        if (searchResults.size() > 0) {
            DownloadToken tokenObject = (DownloadToken)this.context.getBean(DownloadToken.class);
            tokenObject.setDocUuid(searchResults.get(0).getId());
            tokenObject.setAppId(dlForm.getAppId());
            tokenObject.setUser(dlForm.getUser());
            this.tokenService.putInCache(tokenObject);
            response.toResponse(tokenObject.getToken());
        }
        return response;
    }

    public DownloadToken checkToken(String docUuid, String token) {
        DownloadToken tokenInCache = this.tokenService.getInCache(token);
        if (tokenInCache != null && tokenInCache.getDocUuid().equals(docUuid)) {
            this.tokenService.removeFromCache(token);
            return tokenInCache;
        }
        return null;
    }

    public BinaryContent startDownload(String uuid, String appId) throws RepositoryException {
        NuxeoCommand command = (NuxeoCommand)this.context.getBean(FileContentCommand.class, new Object[]{uuid});
        BinaryContent binaryContent = (BinaryContent)this.repo.executeCommand(appId, command);
        return binaryContent;
    }
}

