/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.cas.fim;

import java.util.HashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.Request;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.osivia.cas.fim.FimCredentials;

public class FimCredentialsToPrincipalResolver
implements PrincipalResolver {
    private final Log logger = LogFactory.getLog((String)"fim");
    private ConnectionFactory connectionFactory;

    public FimCredentialsToPrincipalResolver(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal resolve(Credential credential) {
        FimCredentials fimCredentials = (FimCredentials)credential;
        String principalId = fimCredentials.getId();
        try {
            if (fimCredentials.getHashNumen() != null) {
                try (Connection conn = this.connectionFactory.getConnection();){
                    conn.open();
                    SearchOperation search = new SearchOperation(conn);
                    SearchResult result = (SearchResult)search.execute((Request)new SearchRequest("ou=users,dc=osivia,dc=org", "(portalPersonHashNumen=" + fimCredentials.getHashNumen() + ")", new String[]{"uid"})).getResult();
                    result.getEntry();
                    if (result.size() == 1) {
                        LdapEntry entry = result.getEntry();
                        principalId = entry.getAttribute("uid").getStringValue();
                        this.logger.info((Object)("auth via hashnumen " + fimCredentials.getHashNumen() + " (" + principalId + ")"));
                    } else if (result.size() > 1) {
                        for (LdapEntry entry : result.getEntries()) {
                            this.logger.error((Object)("auth impossible via hashnumen " + fimCredentials.getHashNumen() + " (trouv\u00e9 " + entry.getAttribute("uid").getStringValue() + ")"));
                        }
                    } else {
                        result = (SearchResult)search.execute((Request)new SearchRequest("ou=users,dc=osivia,dc=org", "(uid=" + fimCredentials.getId() + ")", new String[]{"uid"})).getResult();
                        if (result.size() == 0) {
                            if (fimCredentials.getMailAca() != null) {
                                principalId = fimCredentials.getMailAca();
                                this.logger.info((Object)("auth via mailaca " + fimCredentials.getMailAca() + " (nouveau compte)"));
                            } else {
                                this.logger.info((Object)("auth via ctemail " + principalId + " (nouveau compte)"));
                            }
                        } else {
                            this.logger.error((Object)("auth via ctemail " + principalId + " (compte existant)"));
                        }
                    }
                }
            }
            if (principalId == null) {
                return null;
            }
            principalId = principalId.toLowerCase();
        }
        catch (Exception e) {
            String fullStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            this.logger.error((Object)fullStackTrace);
        }
        HashMap convertedAttributes = new HashMap();
        convertedAttributes.putAll(fimCredentials.getAttributes());
        return new SimplePrincipal(principalId, convertedAttributes);
    }

    public boolean supports(Credential credential) {
        return credential instanceof FimCredentials;
    }
}

