/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.attributes;

import fr.gouv.education.foad.customizer.attributes.WorkpaceTab;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.theme.PageRendition;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class CustomizedAttributesBundle
implements IAttributesBundle {
    private static final String FIM_URL_RETOUR = "freduurlretour";
    private static final String APPLICATIONS = "osivia.sso.applications";
    private static final String TOOLBAR_HELP_URL = "toolbar.help.url";
    private static final String CGU_URL = "cgu.url";
    private static final String STATS_SERVER_URL = "stats.server.url";
    private static final String STATS_SERVER_SITEID = "stats.server.siteid";
    private static final String STATS_DIM_SPACEID = "stats.dim.spaceid";
    private static final String STATS_DIM_SPACETITLE = "stats.dim.spacetitle";
    private static final String SPACE_TITLE = "stats.space.title";
    private static final String SPACE_ID = "stats.space.id";
    private static final String WORKSPACE_TABS = "workspace.tabs";
    private static final String PAGE_CONTENT_TITLE = "page.content.title";
    private static final IAttributesBundle INSTANCE = new CustomizedAttributesBundle();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Set<String> names = new HashSet();
    private final List<String> applications;
    private final IPortalUrlFactory portalUrlFactory;
    private final ICMSServiceLocator cmsServiceLocator;
    private final IBundleFactory bundleFactory;

    private CustomizedAttributesBundle() {
        this.names.add(APPLICATIONS);
        this.names.add(TOOLBAR_HELP_URL);
        this.names.add(CGU_URL);
        this.names.add(STATS_SERVER_URL);
        this.names.add(STATS_SERVER_SITEID);
        this.names.add(STATS_DIM_SPACEID);
        this.names.add(STATS_DIM_SPACETITLE);
        this.names.add(SPACE_TITLE);
        this.names.add(SPACE_ID);
        this.names.add(WORKSPACE_TABS);
        this.names.add(PAGE_CONTENT_TITLE);
        this.applications = new ArrayList();
        this.applications.add(NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout"));
        this.applications.add(System.getProperty("cas.logout"));
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public static IAttributesBundle getInstance() {
        return INSTANCE;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        String helpUrl;
        String headerUrlRetour;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        Page page = renderPageCommand.getPage();
        Document rootDocument = this.getCurrentRootDocument(renderPageCommand);
        ArrayList<String> applisToLogout = new ArrayList<String>(this.applications);
        if (portalControllerContext != null && portalControllerContext.getHttpServletRequest() != null && StringUtils.isNotBlank((String)(headerUrlRetour = portalControllerContext.getHttpServletRequest().getHeader(FIM_URL_RETOUR)))) {
            String portalLogout = (String)attributes.get("osivia.toolbar.signOutURL");
            applisToLogout.add(portalLogout);
            attributes.put("osivia.toolbar.signOutURL", headerUrlRetour);
        }
        attributes.put(APPLICATIONS, applisToLogout);
        String helpPath = System.getProperty("help.path");
        if (StringUtils.isBlank((String)helpPath)) {
            helpUrl = null;
        } else {
            if (!StringUtils.startsWith((String)helpPath, (String)"/")) {
                helpPath = NuxeoController.webIdToCmsPath((String)helpPath);
            }
            helpUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, helpPath, null, null, null, null, null, null, null);
        }
        attributes.put(TOOLBAR_HELP_URL, helpUrl);
        String cguPath = page.getProperty("osivia.services.cgu.path");
        if (StringUtils.isNotBlank((String)cguPath)) {
            if (!StringUtils.startsWith((String)cguPath, (String)"/")) {
                cguPath = NuxeoController.webIdToCmsPath((String)cguPath);
            }
            String cguUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, cguPath, null, null, null, null, null, null, null);
            attributes.put(CGU_URL, cguUrl);
        }
        if (rootDocument != null) {
            this.computeStatistics(portalControllerContext, rootDocument, attributes);
            this.computeWorkspaceTabs(renderPageCommand, rootDocument, attributes);
        }
        this.computePageContentTitle(portalControllerContext, page, rootDocument, attributes);
    }

    private String getContentPath(ControllerContext controllerContext, Page page) {
        NavigationalStateContext nsContext = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
        PageNavigationalState pageState = nsContext.getPageNavigationalState(page.getId().toString());
        String[] sPath = null;
        if (pageState != null) {
            sPath = pageState.getParameter(new QName("", "osivia.cms.contentPath"));
        }
        String pathPublication = null;
        if (sPath != null && sPath.length > 0) {
            pathPublication = sPath[0];
        }
        return pathPublication;
    }

    private Document getCurrentRootDocument(RenderPageCommand renderPageCommand) {
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        Page page = renderPageCommand.getPage();
        String basePath = page.getProperty("osivia.cms.basePath");
        CMSItem cmsItem = null;
        if (StringUtils.isNotEmpty((String)basePath)) {
            String path = basePath;
            try {
                cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                DocumentType type = cmsItem.getType();
                while (type != null && !type.isRootType()) {
                    CMSObjectPath parent = CMSObjectPath.parse((String)path).getParent();
                    path = parent.toString();
                    cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                    type = cmsItem.getType();
                }
            }
            catch (CMSException cMSException) {
                // empty catch block
            }
        }
        Document document = cmsItem != null && cmsItem.getNativeItem() instanceof Document ? (Document)cmsItem.getNativeItem() : null;
        return document;
    }

    private void computeStatistics(PortalControllerContext portalControllerContext, Document rootDocument, Map<String, Object> attributes) throws ControllerException {
        String spaceTitle = rootDocument.getTitle();
        attributes.put(SPACE_TITLE, spaceTitle);
        String spaceId = rootDocument.getString("webc:url");
        attributes.put(SPACE_ID, spaceId);
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_URL))) {
            attributes.put(STATS_SERVER_URL, System.getProperty(STATS_SERVER_URL));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_SITEID))) {
            attributes.put(STATS_SERVER_SITEID, System.getProperty(STATS_SERVER_SITEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACEID))) {
            attributes.put(STATS_DIM_SPACEID, System.getProperty(STATS_DIM_SPACEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACETITLE))) {
            attributes.put(STATS_DIM_SPACETITLE, System.getProperty(STATS_DIM_SPACETITLE));
        }
    }

    private void computeWorkspaceTabs(RenderPageCommand renderPageCommand, Document rootDocument, Map<String, Object> attributes) {
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        Page page = renderPageCommand.getPage();
        String basePath = page.getProperty("osivia.cms.basePath");
        if ("Workspace".equals(rootDocument.getType())) {
            List rooms = this.getRooms(cmsService, cmsContext, rootDocument.getPath(), rootDocument.getPath());
            ArrayList<Object> tabs = CollectionUtils.isEmpty((Collection)rooms) ? new ArrayList<WorkpaceTab>(1) : new ArrayList(rooms.size() + 1);
            WorkpaceTab workspaceTab = this.createWorkspaceTab(portalControllerContext, rootDocument, basePath);
            tabs.add(workspaceTab);
            if (CollectionUtils.isNotEmpty((Collection)rooms)) {
                for (Document room : rooms) {
                    WorkpaceTab roomTab = this.createWorkspaceTab(portalControllerContext, room, basePath);
                    tabs.add(roomTab);
                }
            }
            attributes.put(WORKSPACE_TABS, tabs);
        }
    }

    private List<Document> getRooms(ICMSService cmsService, CMSServiceCtx cmsContext, String rootPath, String parentPath) {
        ArrayList<Document> rooms;
        List navigationItems;
        try {
            navigationItems = cmsService.getPortalNavigationSubitems(cmsContext, rootPath, parentPath);
        }
        catch (CMSException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
            navigationItems = null;
        }
        if (CollectionUtils.isEmpty((Collection)navigationItems)) {
            rooms = null;
        } else {
            rooms = new ArrayList<Document>();
            for (CMSItem navigationItem : navigationItems) {
                Document document;
                if (!(navigationItem.getNativeItem() instanceof Document) || !"Room".equals((document = (Document)navigationItem.getNativeItem()).getType())) continue;
                rooms.add(document);
                List children = this.getRooms(cmsService, cmsContext, rootPath, document.getPath());
                if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
                rooms.addAll(children);
            }
        }
        return rooms;
    }

    private WorkpaceTab createWorkspaceTab(PortalControllerContext portalControllerContext, Document document, String currentPath) {
        WorkpaceTab tab = new WorkpaceTab();
        tab.setTitle(document.getTitle());
        String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, document.getPath(), null, null, null, null, null, null, null);
        tab.setUrl(url);
        boolean active = StringUtils.equals((String)currentPath, (String)document.getPath());
        tab.setActive(active);
        boolean home = "Workspace".equals(document.getType());
        tab.setHome(home);
        return tab;
    }

    private void computePageContentTitle(PortalControllerContext portalControllerContext, Page page, Document rootDocument, Map<String, Object> attributes) {
        String contentTitle;
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
        Locale locale = httpServletRequest.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String basePath = page.getProperty("osivia.cms.basePath");
        String contentPath = this.getContentPath(controllerContext, page);
        Window maximizedWindow = PortalObjectUtils.getMaximizedWindow((ControllerContext)controllerContext, (Page)page);
        if (maximizedWindow != null) {
            contentTitle = null;
        } else if (StringUtils.isNotEmpty((String)contentPath) && !StringUtils.equals((String)basePath, (String)contentPath)) {
            contentTitle = null;
        } else if (rootDocument != null && "Workspace".equals(rootDocument.getType())) {
            contentTitle = rootDocument.getString("ttcs:welcomeTitle");
            if (StringUtils.isBlank((String)contentTitle)) {
                contentTitle = bundle.getString("WORKSPACE_WELCOME_TITLE_DEFAULT");
            }
        } else if (StringUtils.startsWith((String)page.getName(), (String)"home-")) {
            contentTitle = bundle.getString("HOME_CONTENT_TITLE");
        } else {
            LocalizedString displayName = page.getDisplayName();
            contentTitle = displayName.getString(locale, true);
        }
        attributes.put(PAGE_CONTENT_TITLE, contentTitle);
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

