/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.plugin.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class TileFragmentModule
extends FragmentModule {
    public static final String ID = "tile";
    private static final String JSP_NAME = "tile";
    private static final String PATH = "path";
    private static final String TARGET = "target";
    private static final List<String> PROPERTIES = Arrays.asList("path", "target");
    private final DocumentDAO documentDao = DocumentDAO.getInstance();

    public TileFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        String target;
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH);
        if (StringUtils.isNotEmpty((String)path)) {
            path = nuxeoController.getComputedPath(path);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            Document nuxeoDocument = documentContext.getDoc();
            DocumentDTO documentDto = this.documentDao.toDTO(nuxeoDocument);
            request.setAttribute("document", (Object)documentDto);
        }
        if (StringUtils.isNotEmpty((String)(target = window.getProperty(TARGET)))) {
            String url = !StringUtils.containsAny((String)target, (String)"/.") ? "/nuxeo/web/" + target : target;
            Link targetLink = nuxeoController.getLinkFromNuxeoURL(url);
            request.setAttribute("targetLink", (Object)targetLink);
        }
    }

    public void doAdmin(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        for (String property : PROPERTIES) {
            String value = window.getProperty(property);
            request.setAttribute(property, (Object)value);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            for (String property : PROPERTIES) {
                String value = StringUtils.trimToNull((String)request.getParameter(property));
                window.setProperty(property, value);
            }
        }
    }

    public String getViewJSPName() {
        return "tile";
    }

    public String getAdminJSPName() {
        return "tile";
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }
}

