/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.plugin.menubar;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;

public class FoadMenubarModule
implements MenubarModule {
    private static final String MERGED_DROPDOWN_MENU_ID = "MERGED";
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IBundleFactory bundleFactory;
    private final DocumentDAO documentDao;

    public FoadMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.documentDao = DocumentDAO.getInstance();
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> spaceDocumentContext) throws PortalException {
        this.hideConfigurationItems(portalControllerContext, menubar);
        this.mergeDropdownMenus(portalControllerContext, menubar);
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) throws PortalException {
        this.removeItems(menubar, documentContext);
        this.mergeDropdownMenus(portalControllerContext, menubar);
        this.addLiveEditionItems(portalControllerContext, menubar, documentContext);
    }

    private void hideConfigurationItems(PortalControllerContext portalControllerContext, List<MenubarItem> menubar) {
        MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "CONFIGURATION");
        if (dropdown != null) {
            for (MenubarItem item : menubar) {
                MenubarContainer parent = item.getParent();
                if ((parent == null || !parent.equals(dropdown)) && !"PRINT".equals(item.getId())) continue;
                item.setVisible(false);
            }
        }
    }

    private void removeItems(List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) {
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add("REMOTE_PUBLISHING_URL");
        identifiers.add("SYNCHRONIZE_ACTION");
        identifiers.add("ADD_TOUTATICEPAD");
        BasicPublicationInfos publicationInfos = (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
        if (publicationInfos.isDraft()) {
            identifiers.add("VALIDATION_WF_URL");
        }
        boolean mailEnabled = true;
        String forbiddenpath = System.getProperty("foad.bulkdownload.forbiddenpath");
        String[] split = forbiddenpath.split(",");
        String path = publicationInfos.getContentPath();
        for (int i = 0; i < split.length; ++i) {
            String trim = StringUtils.trim((String)split[i]);
            if (!StringUtils.isNotBlank((String)trim) || !path.startsWith(trim)) continue;
            mailEnabled = false;
            break;
        }
        if (!mailEnabled) {
            identifiers.add("SHARE_BY_EMAIL");
        }
        ArrayList<MenubarItem> removedItems = new ArrayList<MenubarItem>(identifiers.size());
        for (MenubarItem item : menubar) {
            if (!identifiers.contains(item.getId())) continue;
            removedItems.add(item);
        }
        menubar.removeAll(removedItems);
    }

    private void mergeDropdownMenus(PortalControllerContext portalControllerContext, List<MenubarItem> menubar) {
        MenubarDropdown merged;
        MenubarDropdown otherOptions;
        MenubarDropdown share;
        HashMap<MenubarDropdown, ArrayList<MenubarItem>> dropdowns = new HashMap<MenubarDropdown, ArrayList<MenubarItem>>();
        MenubarItem refresh = null;
        for (MenubarItem item : menubar) {
            MenubarContainer parent = item.getParent();
            if ("REFRESH".equals(item.getId())) {
                refresh = item;
                continue;
            }
            if (!(parent instanceof MenubarDropdown)) continue;
            MenubarDropdown dropdown = (MenubarDropdown)parent;
            ArrayList<MenubarItem> dropdownItems = (ArrayList<MenubarItem>)dropdowns.get(dropdown);
            if (dropdownItems == null) {
                dropdownItems = new ArrayList<MenubarItem>();
                dropdowns.put(dropdown, dropdownItems);
            }
            dropdownItems.add(item);
        }
        HashMap<MenubarDropdown, Integer> increments = new HashMap<MenubarDropdown, Integer>();
        MenubarDropdown edition = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
        if (edition != null) {
            increments.put(edition, 1000);
        }
        if ((share = this.menubarService.getDropdown(portalControllerContext, "SHARE")) != null) {
            increments.put(share, 2000);
        }
        if ((otherOptions = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS")) != null) {
            increments.put(otherOptions, 3000);
        }
        if ((merged = this.menubarService.getDropdown(portalControllerContext, MERGED_DROPDOWN_MENU_ID)) == null) {
            merged = new MenubarDropdown(MERGED_DROPDOWN_MENU_ID, null, "glyphicons glyphicons-option-vertical", MenubarGroup.GENERIC, 40);
            merged.setReducible(true);
            this.menubarService.addDropdown(portalControllerContext, merged);
        }
        for (Map.Entry entry : increments.entrySet()) {
            MenubarDropdown dropdown = (MenubarDropdown)entry.getKey();
            List items = (List)dropdowns.get(dropdown);
            Integer increment = (Integer)increments.get(dropdown);
            if (!CollectionUtils.isNotEmpty((Collection)items) || increment == null) continue;
            MenubarItem header = new MenubarItem(dropdown.getId() + "_HEADER", dropdown.getTitle(), (MenubarContainer)merged, increment - 100, null);
            header.setState(true);
            header.setDivider(true);
            menubar.add(header);
            for (MenubarItem item : items) {
                item.setParent((MenubarContainer)merged);
                item.setOrder(item.getOrder() + increment);
                item.setDivider(false);
            }
        }
        if (refresh != null) {
            refresh.setParent((MenubarContainer)merged);
            refresh.setOrder(4000);
            refresh.setDivider(true);
        }
    }

    private void addLiveEditionItems(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext<? extends EcmDocument> documentContext) throws PortalException {
        NuxeoDocumentContext nuxeoDocumentContext;
        DocumentType documentType;
        if (documentContext != null && documentContext instanceof NuxeoDocumentContext && (documentType = (nuxeoDocumentContext = (NuxeoDocumentContext)documentContext).getType()) != null && documentType.isFile()) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            PortletRequest request = portalControllerContext.getRequest();
            BasicPublicationInfos publicationInfos = (BasicPublicationInfos)nuxeoDocumentContext.getPublicationInfos(BasicPublicationInfos.class);
            BasicPermissions permissions = (BasicPermissions)nuxeoDocumentContext.getPermissions(BasicPermissions.class);
            DocumentDTO documentDto = this.documentDao.toDTO(nuxeoDocumentContext.getDoc());
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            MenubarDropdown liveEditionDropdown = new MenubarDropdown("LIVE_EDITION", null, "glyphicons glyphicons-pencil", MenubarGroup.CMS, 6);
            liveEditionDropdown.setReducible(false);
            this.menubarService.addDropdown(portalControllerContext, liveEditionDropdown);
            if (documentDto.isLiveEditable()) {
                String onlyOfficeTitle;
                if (permissions.isEditableByUser()) {
                    onlyOfficeTitle = bundle.getString("MENUBAR_ONLYOFFICE_TITLE");
                    String onlyOfficeWithLockText = bundle.getString("MENUBAR_ONLYOFFICE_WITH_LOCK");
                    String onlyOfficeWithLockUrl = this.getOnlyOfficeUrl(portalControllerContext, documentDto.getPath(), onlyOfficeTitle, true, true);
                    MenubarItem onlyOfficeWithLock = new MenubarItem("ONLYOFFICE_WITH_LOCK", onlyOfficeWithLockText, null, (MenubarContainer)liveEditionDropdown, 1, onlyOfficeWithLockUrl, null, null, null);
                    menubar.add(onlyOfficeWithLock);
                    String onlyOfficeWithoutLockText = bundle.getString("MENUBAR_ONLYOFFICE_WITHOUT_LOCK");
                    String onlyOfficeWithoutLockUrl = this.getOnlyOfficeUrl(portalControllerContext, documentDto.getPath(), onlyOfficeTitle, true, false);
                    MenubarItem onlyOfficeWithoutLock = new MenubarItem("ONLYOFFICE_WITHOUT_LOCK", onlyOfficeWithoutLockText, null, (MenubarContainer)liveEditionDropdown, 2, onlyOfficeWithoutLockUrl, null, null, null);
                    menubar.add(onlyOfficeWithoutLock);
                }
                if (StringUtils.isNotEmpty((String)request.getRemoteUser())) {
                    onlyOfficeTitle = bundle.getString("MENUBAR_ONLYOFFICE_READ_ONLY_TITLE");
                    String onlyOfficeReadOnlyText = bundle.getString("MENUBAR_ONLYOFFICE_READ_ONLY");
                    String onlyOfficeReadOnlyUrl = this.getOnlyOfficeUrl(portalControllerContext, documentDto.getPath(), onlyOfficeTitle, false, false);
                    MenubarItem onlyOfficeReadOnly = new MenubarItem("ONLYOFFICE_READ_ONLY", onlyOfficeReadOnlyText, null, (MenubarContainer)liveEditionDropdown, 3, onlyOfficeReadOnlyUrl, null, null, null);
                    menubar.add(onlyOfficeReadOnly);
                }
            }
            if (documentType.isLiveEditable() && permissions.isEditableByUser() && (StringUtils.isNotEmpty((String)publicationInfos.getDriveUrl()) || publicationInfos.isDriveEnabled())) {
                if (StringUtils.isNotEmpty((String)publicationInfos.getDriveUrl())) {
                    MenubarItem drive = new MenubarItem("DRIVE", bundle.getString("MENUBAR_DRIVE_EDIT"), null, (MenubarContainer)liveEditionDropdown, 4, publicationInfos.getDriveUrl(), null, null, null);
                    drive.setDivider(true);
                    menubar.add(drive);
                } else {
                    MenubarItem driveWarning = new MenubarItem("DRIVE_WARNING", bundle.getString("MENUBAR_DRIVE_NOT_STARTED_WARNING"), (MenubarContainer)liveEditionDropdown, 3, null);
                    driveWarning.setDisabled(true);
                    driveWarning.setDivider(true);
                    menubar.add(driveWarning);
                    MenubarItem drive = new MenubarItem("DRIVE", bundle.getString("MENUBAR_DRIVE_EDIT"), null, (MenubarContainer)liveEditionDropdown, 4, "#", null, null, null);
                    drive.setDisabled(true);
                    menubar.add(drive);
                }
            }
            if (documentType.isFile()) {
                Link link = nuxeoController.getLink(documentDto.getDocument(), "download");
                MenubarItem download = new MenubarItem("DOWNLOAD", bundle.getString("MENUBAR_DOWNLOAD"), "glyphicons glyphicons-download-alt", (MenubarContainer)liveEditionDropdown, 5, link.getUrl(), "_blank", null, null);
                download.setDivider(true);
                menubar.add(download);
            }
        }
    }

    private String getOnlyOfficeUrl(PortalControllerContext portalControllerContext, String path, String title, boolean edit, boolean lock) throws PortalException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", path);
        properties.put("osivia.hideTitle", String.valueOf(1));
        properties.put("osivia.onlyoffice.mode", BooleanUtils.toString((boolean)edit, (String)"edit", (String)"view"));
        properties.put("osivia.onlyoffice.withLock", String.valueOf(lock));
        properties.put("osivia.title", title);
        return this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-onlyoffice-portletInstance", properties);
    }
}

