/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.regions;

import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.theming.IRenderedRegions;

public class RegionsCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "foad.customizer.regions";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String CHARTE_CONTEXT_PATH = "/foad-charte";
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private ICustomizationModulesRepository repository;

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.regions.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        Map attributes = context.getAttributes();
        IRenderedRegions renderedRegion = (IRenderedRegions)attributes.get("osivia.customizer.regions.renderedRegions");
        String contextPath = (String)attributes.get("osivia.customizer.regions.themeContextPath");
        if (CHARTE_CONTEXT_PATH.equals(contextPath)) {
            renderedRegion.removeRenderedRegion("toolbar");
            renderedRegion.removeRenderedRegion("search");
            renderedRegion.removeRenderedRegion("tabs");
            renderedRegion.customizeRenderedRegion("breadcrumb", "/regions/breadcrumb.jsp");
            renderedRegion.customizeRenderedRegion("drawer-toolbar", "/regions/drawer-toolbar.jsp");
            renderedRegion.customizeRenderedRegion("footer", "/regions/footer.jsp");
            renderedRegion.customizeRenderedRegion("toolbar-administration", "/regions/toolbar-administration.jsp");
            renderedRegion.customizeRenderedRegion("toolbar-tasks", "/regions/toolbar-tasks.jsp");
            renderedRegion.customizeRenderedRegion("toolbar-user-menu", "/regions/toolbar-user-menu.jsp");
            renderedRegion.customizeRenderedRegion("toolbar-v2-access", "/regions/toolbar-v2-access.jsp");
            renderedRegion.customizeRenderedRegion("content-title", "/regions/content-title.jsp");
            renderedRegion.customizeRenderedRegion("header-title", "/regions/header-title.jsp");
            renderedRegion.customizeRenderedRegion("header-logo-large", "/regions/header-logo-large.jsp");
            renderedRegion.customizeRenderedRegion("stats", "/regions/stats.jsp");
            renderedRegion.customizeRenderedRegion("workspace-tabs", "/regions/workspace-tabs.jsp");
        }
    }
}

