/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.attributes;

import fr.gouv.education.foad.customizer.attributes.WorkpaceTab;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.theme.PageRendition;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class CustomizedAttributesBundle
implements IAttributesBundle {
    private static final String PORTAL_SIGNOUT = "/portal/signout";
    private final Log logger = LogFactory.getLog(CustomizedAttributesBundle.class);
    private static final String FIM_URL_RETOUR = "freduurlretour";
    private static final String APPLICATIONS = "osivia.sso.applications";
    private static final String MAIN_APP = "osivia.sso.logout";
    private static final String CGU_URL = "cgu.url";
    private static final String HELP_FAQ_URL = "help.faq.url";
    private static final String HELP_TUTORIALS_URL = "help.tutorials.url";
    private static final String HELP_CONTACT_URL = "help.contact.url";
    private static final String STATS_SERVER_URL = "stats.server.url";
    private static final String STATS_SERVER_SITEID = "stats.server.siteid";
    private static final String STATS_DIM_SPACEID = "stats.dim.spaceid";
    private static final String STATS_DIM_SPACETITLE = "stats.dim.spacetitle";
    private static final String SPACE_TITLE = "stats.space.title";
    private static final String SPACE_ID = "stats.space.id";
    private static final String PV2_URL = "foad.portalv2.url";
    private static final String WORKSPACE_TABS = "workspace.tabs";
    private static final String PAGE_CONTENT_TITLE = "page.content.title";
    private static final IAttributesBundle INSTANCE = new CustomizedAttributesBundle();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Set<String> names = new HashSet();
    private final List<String> applications;
    private final IPortalUrlFactory portalUrlFactory;
    private final ICMSServiceLocator cmsServiceLocator;
    private final IBundleFactory bundleFactory;

    private CustomizedAttributesBundle() {
        this.names.add(MAIN_APP);
        this.names.add(APPLICATIONS);
        this.names.add(CGU_URL);
        this.names.add(HELP_FAQ_URL);
        this.names.add(HELP_TUTORIALS_URL);
        this.names.add(HELP_CONTACT_URL);
        this.names.add(STATS_SERVER_URL);
        this.names.add(STATS_SERVER_SITEID);
        this.names.add(STATS_DIM_SPACEID);
        this.names.add(STATS_DIM_SPACETITLE);
        this.names.add(SPACE_TITLE);
        this.names.add(SPACE_ID);
        this.names.add(WORKSPACE_TABS);
        this.names.add(PAGE_CONTENT_TITLE);
        this.names.add(PV2_URL);
        this.applications = new ArrayList();
        this.applications.add(NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout"));
        this.applications.add(System.getProperty("cas.logout"));
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public static IAttributesBundle getInstance() {
        return INSTANCE;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        String contactUrl;
        String headerUrlRetour;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        Page page = renderPageCommand.getPage();
        Document document = this.getCurrentDocument(renderPageCommand);
        Document rootDocument = this.getCurrentRootDocument(controllerContext, document);
        ArrayList<String> applisToLogout = new ArrayList<String>(this.applications);
        String portalLogout = PORTAL_SIGNOUT;
        attributes.put(MAIN_APP, portalLogout);
        if (portalControllerContext != null && portalControllerContext.getHttpServletRequest() != null && StringUtils.isNotBlank((String)(headerUrlRetour = portalControllerContext.getHttpServletRequest().getHeader(FIM_URL_RETOUR)))) {
            applisToLogout.add(portalLogout);
            attributes.put(MAIN_APP, headerUrlRetour);
        }
        attributes.put(APPLICATIONS, applisToLogout);
        String cguUrl = this.getUrlFromProperty(portalControllerContext, "osivia.services.cgu.path");
        attributes.put(CGU_URL, cguUrl);
        String faqUrl = this.getUrlFromProperty(portalControllerContext, "help.faq.path");
        attributes.put(HELP_FAQ_URL, faqUrl);
        String tutorialsUrl = this.getUrlFromProperty(portalControllerContext, "help.tutorials.path");
        attributes.put(HELP_TUTORIALS_URL, tutorialsUrl);
        String mailto = System.getProperty("help.contact.mailto");
        if (StringUtils.isBlank((String)mailto)) {
            contactUrl = null;
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("mailto:");
            builder.append(mailto);
            String subject = System.getProperty("help.contact.subject");
            if (StringUtils.isNotBlank((String)subject)) {
                builder.append("?subject=");
                builder.append(StringEscapeUtils.escapeHtml((String)subject));
            }
            contactUrl = builder.toString();
        }
        attributes.put(HELP_CONTACT_URL, contactUrl);
        this.computeStatistics(portalControllerContext, rootDocument, attributes);
        if (rootDocument != null) {
            this.computeWorkspaceTabs(renderPageCommand, rootDocument, attributes);
        }
        this.computePageContentTitle(portalControllerContext, page, document, attributes);
        if (StringUtils.isNotBlank((String)System.getProperty(PV2_URL))) {
            attributes.put(PV2_URL, System.getProperty(PV2_URL));
        }
    }

    private Document getCurrentDocument(RenderPageCommand renderPageCommand) {
        CMSItem cmsItem;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        Page page = renderPageCommand.getPage();
        String path = this.getContentPath(controllerContext, page);
        if (StringUtils.isEmpty((String)path)) {
            cmsItem = null;
        } else {
            try {
                cmsItem = cmsService.getContent(cmsContext, path);
            }
            catch (CMSException e) {
                cmsItem = null;
            }
        }
        Document document = cmsItem != null && cmsItem.getNativeItem() instanceof Document ? (Document)cmsItem.getNativeItem() : null;
        return document;
    }

    private String getContentPath(ControllerContext controllerContext, Page page) {
        NavigationalStateContext nsContext = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
        PageNavigationalState pageState = nsContext.getPageNavigationalState(page.getId().toString());
        String[] sPath = null;
        if (pageState != null) {
            sPath = pageState.getParameter(new QName("", "osivia.cms.contentPath"));
        }
        String pathPublication = null;
        if (sPath != null && sPath.length > 0) {
            pathPublication = sPath[0];
        }
        return pathPublication;
    }

    private Document getCurrentRootDocument(ControllerContext controllerContext, Document document) {
        CMSItem cmsItem;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        if (document == null) {
            cmsItem = null;
        } else {
            try {
                String path = document.getPath();
                cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                DocumentType type = cmsItem.getType();
                while (type != null && !type.isRootType()) {
                    CMSObjectPath parent = CMSObjectPath.parse((String)path).getParent();
                    path = parent.toString();
                    cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                    type = cmsItem.getType();
                }
            }
            catch (CMSException e) {
                cmsItem = null;
            }
        }
        Document rootDocument = cmsItem != null && cmsItem.getNativeItem() instanceof Document ? (Document)cmsItem.getNativeItem() : null;
        return rootDocument;
    }

    private void computeStatistics(PortalControllerContext portalControllerContext, Document rootDocument, Map<String, Object> attributes) throws ControllerException {
        if (rootDocument != null) {
            String spaceTitle = rootDocument.getTitle();
            attributes.put(SPACE_TITLE, spaceTitle);
            String spaceId = rootDocument.getString("webc:url");
            attributes.put(SPACE_ID, spaceId);
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_URL))) {
            attributes.put(STATS_SERVER_URL, System.getProperty(STATS_SERVER_URL));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_SITEID))) {
            attributes.put(STATS_SERVER_SITEID, System.getProperty(STATS_SERVER_SITEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACEID))) {
            attributes.put(STATS_DIM_SPACEID, System.getProperty(STATS_DIM_SPACEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACETITLE))) {
            attributes.put(STATS_DIM_SPACETITLE, System.getProperty(STATS_DIM_SPACETITLE));
        }
    }

    private void computeWorkspaceTabs(RenderPageCommand renderPageCommand, Document rootDocument, Map<String, Object> attributes) {
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        Page page = renderPageCommand.getPage();
        String basePath = page.getProperty("osivia.cms.basePath");
        if ("Workspace".equals(rootDocument.getType())) {
            List rooms = this.getRooms(cmsService, cmsContext, rootDocument.getPath(), rootDocument.getPath());
            ArrayList<Object> tabs = CollectionUtils.isEmpty((Collection)rooms) ? new ArrayList<WorkpaceTab>(1) : new ArrayList(rooms.size() + 1);
            WorkpaceTab workspaceTab = this.createWorkspaceTab(portalControllerContext, rootDocument, basePath);
            tabs.add(workspaceTab);
            if (CollectionUtils.isNotEmpty((Collection)rooms)) {
                for (Document room : rooms) {
                    WorkpaceTab roomTab = this.createWorkspaceTab(portalControllerContext, room, basePath);
                    tabs.add(roomTab);
                }
            }
            attributes.put(WORKSPACE_TABS, tabs);
        }
    }

    private List<Document> getRooms(ICMSService cmsService, CMSServiceCtx cmsContext, String rootPath, String parentPath) {
        ArrayList<Document> rooms;
        List navigationItems = null;
        try {
            navigationItems = cmsService.getPortalNavigationSubitems(cmsContext, rootPath, parentPath);
        }
        catch (NullPointerException e) {
            this.logger.warn((Object)("Can not compute rooms for space " + rootPath));
        }
        catch (CMSException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
        }
        if (CollectionUtils.isEmpty((Collection)navigationItems)) {
            rooms = null;
        } else {
            rooms = new ArrayList<Document>();
            for (CMSItem navigationItem : navigationItems) {
                Document document;
                if (!(navigationItem.getNativeItem() instanceof Document) || !"Room".equals((document = (Document)navigationItem.getNativeItem()).getType()) || !BooleanUtils.isTrue((Boolean)document.getProperties().getBoolean("ttc:showInMenu"))) continue;
                rooms.add(document);
                List children = this.getRooms(cmsService, cmsContext, rootPath, document.getPath());
                if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
                rooms.addAll(children);
            }
        }
        return rooms;
    }

    private WorkpaceTab createWorkspaceTab(PortalControllerContext portalControllerContext, Document document, String currentPath) {
        WorkpaceTab tab = new WorkpaceTab();
        tab.setTitle(document.getTitle());
        String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, document.getPath(), null, null, null, null, null, null, null);
        tab.setUrl(url);
        boolean active = StringUtils.equals((String)currentPath, (String)document.getPath());
        tab.setActive(active);
        boolean home = "Workspace".equals(document.getType());
        tab.setHome(home);
        return tab;
    }

    private void computePageContentTitle(PortalControllerContext portalControllerContext, Page page, Document document, Map<String, Object> attributes) {
        String contentTitle;
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
        Locale locale = httpServletRequest.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        Window maximizedWindow = PortalObjectUtils.getMaximizedWindow((ControllerContext)controllerContext, (Page)page);
        if (maximizedWindow != null) {
            contentTitle = null;
        } else if (document != null && ("Workspace".equals(document.getType()) || "Room".equals(document.getType()))) {
            contentTitle = StringUtils.trimToNull((String)document.getString("ttcs:welcomeTitle"));
            if ("Workspace".equals(document.getType())) {
                contentTitle = StringUtils.defaultIfEmpty((String)contentTitle, (String)bundle.getString("WORKSPACE_WELCOME_TITLE_DEFAULT"));
            }
        } else if (StringUtils.startsWith((String)page.getName(), (String)"home-")) {
            String appName = System.getProperty("application.name", "Tribu");
            contentTitle = bundle.getString("HOME_CONTENT_TITLE", new Object[]{appName});
        } else {
            contentTitle = null;
        }
        attributes.put(PAGE_CONTENT_TITLE, contentTitle);
    }

    private String getUrlFromProperty(PortalControllerContext portalControllerContext, String property) {
        String url;
        String path = System.getProperty(property);
        if (StringUtils.isBlank((String)path)) {
            url = null;
        } else {
            if (!StringUtils.startsWith((String)path, (String)"/")) {
                path = NuxeoController.webIdToCmsPath((String)path);
            }
            url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
        }
        return url;
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

