/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletExternalContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPortletExternalContextImpl
extends PortletExternalContextImpl {
    private Map<String, String[]> _requestParameters;

    @Override
    public String getResponseCharacterEncoding() {
        RenderResponse renderResponse = (RenderResponse)this.getPortletResponse();
        return renderResponse.getCharacterEncoding();
    }

    @Override
    public String getResponseContentType() {
        RenderResponse renderResponse = (RenderResponse)this.getPortletResponse();
        return renderResponse.getContentType();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
    }

    @Override
    public String getRequestCharacterEncoding() {
        return null;
    }

    @Override
    protected String getNamespace() {
        return ((RenderResponse)this.getPortletResponse()).getNamespace();
    }

    public RenderPortletExternalContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context, request, response);
    }

    @Override
    protected String getRequestParameter(String name) {
        String[] retObj = this.getRequestParameterValues(name);
        if (retObj == null) {
            return null;
        }
        return retObj[0];
    }

    @Override
    protected Enumeration<String> enumerateRequestParameterNames() {
        Map<String, String[]> requestParameters = this.getSavedRequestParameters();
        if (null != requestParameters) {
            return Collections.enumeration(requestParameters.keySet());
        }
        return Collections.enumeration(Collections.emptyList());
    }

    @Override
    public void redirect(String url) throws IOException {
        if (null == url) {
            throw new NullPointerException("Path to redirect is null");
        }
        PortalActionURL actionURL = new PortalActionURL(url);
        if ((actionURL.isInContext(this.getRequestContextPath()) || null != actionURL.getParameter("org.jboss.portletbridge.VIEWID")) && !"true".equalsIgnoreCase(actionURL.getParameter("javax.portlet.faces.DirectLink"))) {
            this.internalRedirect(actionURL);
        }
    }

    @Override
    protected String createActionUrl(PortalActionURL url) {
        String viewId = this.getViewIdFromUrl(url);
        RenderResponse renderResponse = (RenderResponse)this.getPortletResponse();
        PortletURL portletURL = renderResponse.createActionURL();
        portletURL.setParameter("org.jboss.portletbridge.VIEWID", viewId);
        portletURL.setParameter("org.jboss.portletbridge.NAMESPACE", renderResponse.getNamespace());
        for (String key : url.getParameters().keySet()) {
            String value = url.getParameter(key);
            if ("javax.portlet.faces.PortletMode".equals(key)) {
                PortletMode mode = new PortletMode(value);
                try {
                    portletURL.setPortletMode(mode);
                }
                catch (PortletModeException e) {}
                continue;
            }
            if ("javax.portlet.faces.WindowState".equals(key)) {
                try {
                    WindowState state = new WindowState(value);
                    portletURL.setWindowState(state);
                }
                catch (WindowStateException e) {}
                continue;
            }
            if ("javax.portlet.faces.Secure".equals(key)) {
                try {
                    portletURL.setSecure(Boolean.getBoolean(value));
                }
                catch (PortletSecurityException e) {}
                continue;
            }
            portletURL.setParameter(key, value);
        }
        return portletURL.toString();
    }

    @Override
    public void dispatch(String path) throws IOException {
        if (null == path) {
            throw new NullPointerException("Path to new view is null");
        }
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (null == dispatcher) {
            throw new IllegalStateException("Dispatcher for render request is not created");
        }
        try {
            RenderRequest renderRequest = (RenderRequest)this.getPortletRequest();
            RenderResponse portletResponse = (RenderResponse)this.getPortletResponse();
            dispatcher.include(renderRequest, portletResponse);
        }
        catch (PortletException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private Map<String, String[]> getSavedRequestParameters() {
        if (null == this._requestParameters) {
            HashMap<String, String[]> requestParameters = new HashMap<String, String[]>();
            Map<String, String[]> savedRequestParameters = this.windowState.getRequestParameters();
            if (savedRequestParameters != null) {
                requestParameters.putAll(savedRequestParameters);
            }
            Enumeration parameterNames = this.getPortletRequest().getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                requestParameters.put(name, this.getPortletRequest().getParameterValues(name));
            }
            this._requestParameters = Collections.unmodifiableMap(requestParameters);
        }
        return this._requestParameters;
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        Map<String, String[]> requestParameters = this.getSavedRequestParameters();
        if (null != requestParameters) {
            return requestParameters.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.getSavedRequestParameters();
    }
}

