/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.iiop;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.util.Conversion;

public class ReferenceData
implements Serializable {
    static final long serialVersionUID = 2024043833676010079L;
    private Object servantId;
    private Object objectId;

    public static byte[] create(Object servantId, Object objectId) {
        return Conversion.toByteArray(new ReferenceData(servantId, objectId));
    }

    public static byte[] create(Object id) {
        return Conversion.toByteArray(id);
    }

    public static Object extractServantId(byte[] refData, ClassLoader cl) throws IOException, ClassNotFoundException {
        Object obj = Conversion.toObject(refData, cl);
        if (obj != null && obj instanceof ReferenceData) {
            return ((ReferenceData)obj).servantId;
        }
        return obj;
    }

    public static Object extractServantId(byte[] refData) throws IOException, ClassNotFoundException {
        return ReferenceData.extractServantId(refData, Thread.currentThread().getContextClassLoader());
    }

    public static Object extractObjectId(byte[] refData, ClassLoader cl) throws IOException, ClassNotFoundException {
        Object obj = Conversion.toObject(refData, cl);
        if (obj != null && obj instanceof ReferenceData) {
            return ((ReferenceData)obj).objectId;
        }
        return obj;
    }

    public static Object extractObjectId(byte[] refData) throws IOException, ClassNotFoundException {
        return ReferenceData.extractObjectId(refData, Thread.currentThread().getContextClassLoader());
    }

    private ReferenceData(Object servantId, Object objectId) {
        this.servantId = servantId;
        this.objectId = objectId;
    }
}

