/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.spi;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.common.invocation.resolver.MapAttributeResolver;
import org.jboss.portal.common.invocation.resolver.PrincipalAttributeResolver;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.portlet.spi.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractUserContext
implements UserContext {
    private static final Map<String, String> EMPTY_STRING_TO_STRING_MAP = Collections.emptyMap();
    private static final List<Locale> EMPTY_LOCALE_LIST = Collections.emptyList();
    private final String id;
    private final HttpServletRequest clientRequest;
    private final AttributeResolver attributeResolver;

    public AbstractUserContext(HttpServletRequest clientRequest) throws IllegalArgumentException {
        if (clientRequest == null) {
            throw new IllegalArgumentException("No client request provided");
        }
        this.id = clientRequest.getRemoteUser();
        this.clientRequest = clientRequest;
        this.attributeResolver = new PrincipalAttributeResolver(clientRequest);
    }

    public AbstractUserContext(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("No user id provided");
        }
        this.id = id;
        this.clientRequest = null;
        this.attributeResolver = new MapAttributeResolver();
    }

    public AbstractUserContext() {
        this.id = null;
        this.clientRequest = null;
        this.attributeResolver = new MapAttributeResolver();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getInformations() {
        return EMPTY_STRING_TO_STRING_MAP;
    }

    @Override
    public Locale getLocale() {
        return this.clientRequest != null ? this.clientRequest.getLocale() : Locale.ENGLISH;
    }

    @Override
    public List<Locale> getLocales() {
        if (this.clientRequest == null) {
            return EMPTY_LOCALE_LIST;
        }
        return Tools.toList((Enumeration)this.clientRequest.getLocales());
    }

    @Override
    public void setAttribute(String attrKey, Object attrValue) {
        this.attributeResolver.setAttribute((Object)attrKey, attrValue);
    }

    @Override
    public Object getAttribute(String attrKey) {
        return this.attributeResolver.getAttribute((Object)attrKey);
    }
}

